/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Testcase
extends Definition
implements IParameterisedAssignment {
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<runs_on_type>";
    private static final String FULLNAMEPART3 = ".<system_type>";
    private static final String FULLNAMEPART4 = ".<statement_block>";
    private static final String FULLNAMEPART5 = ".<finally_block>";
    private static final String DASHALLOWEDONLYFORTEMPLATES = "Using not used symbol (`-') as the default parameter is allowed only for modified templates";
    private static final String KIND = "testcase";
    private final FormalParameterList formalParList;
    private final Reference runsOnReference;
    private Component_Type runsOnType = null;
    private final Reference systemReference;
    private Component_Type systemType = null;
    private final StatementBlock block;
    private NamedBridgeScope bridgeScope = null;

    public Def_Testcase(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Reference systemRef, StatementBlock block) {
        super(identifier);
        this.formalParList = formalParameters;
        if (this.formalParList != null) {
            this.formalParList.setMyDefinition(this);
        }
        this.runsOnReference = runsOnRef;
        this.systemReference = systemRef;
        this.block = block;
        if (block != null) {
            block.setMyDefinition(this);
            block.setFullNameParent(this);
        }
        if (this.formalParList != null) {
            this.formalParList.setFullNameParent(this);
        }
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (systemRef != null) {
            systemRef.setFullNameParent(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_TESTCASE;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.runsOnReference == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.systemReference == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.block == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParList;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        return "testcase.gif";
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList == null || this.lastTimeChecked == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals((parameter = this.formalParList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.runsOnReference != null) {
            this.runsOnReference.setMyScope(this.bridgeScope);
        }
        if (this.systemReference != null) {
            this.systemReference.setMyScope(this.bridgeScope);
        }
        this.formalParList.setMyScope(this.bridgeScope);
        if (this.block != null) {
            this.block.setMyScope(this.formalParList);
            this.bridgeScope.addSubScope(this.block.getLocation(), this.block);
        }
        this.bridgeScope.addSubScope(this.formalParList.getLocation(), this.formalParList);
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public Reference getRunsOnReference(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnReference;
    }

    public Component_Type getSystemType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.systemType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.removeSyntaxDecoration();
        this.isUsed = false;
        this.runsOnType = null;
        this.systemType = null;
        if (this.runsOnReference != null) {
            this.runsOnType = this.runsOnReference.chkComponentypeReference(timestamp);
            if (this.runsOnType != null) {
                Scope formalParlistPreviosScope = this.formalParList.getParentScope();
                if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                    ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                } else {
                    RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                    this.formalParList.setMyScope(tempScope);
                }
            }
        }
        if (this.systemReference != null) {
            this.systemType = this.systemReference.chkComponentypeReference(timestamp);
        }
        if (this.formalParList.hasNotusedDefaultValue()) {
            this.formalParList.getLocation().reportSemanticError(DASHALLOWEDONLYFORTEMPLATES);
            return;
        }
        boolean canSkip = false;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            canSkip = true;
        }
        if (!canSkip) {
            this.formalParList.reset();
        }
        this.formalParList.check(timestamp, this.getAssignmentType());
        if (canSkip) {
            return;
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionTestcase", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.block != null) {
            this.block.check(timestamp);
            this.block.postCheck();
            this.block.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.checkDocumentComment();
    }

    @Override
    public void postCheck() {
        Module module;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        super.postCheck();
        this.formalParList.postCheck();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(index).getReferenceType()) && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, index);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            declarationCollector.addDeclaration(this);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            int result = 1;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.formalParList != null) {
                if (enveloped) {
                    this.formalParList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParList.getLocation())) {
                    try {
                        this.formalParList.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.formalParList.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.runsOnReference != null) {
                if (enveloped) {
                    this.runsOnReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.runsOnReference.getLocation());
                } else if (reparser.envelopsDamage(this.runsOnReference.getLocation())) {
                    try {
                        this.runsOnReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.runsOnReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.systemReference != null) {
                if (enveloped) {
                    this.systemReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.systemReference.getLocation());
                } else if (reparser.envelopsDamage(this.systemReference.getLocation())) {
                    try {
                        this.systemReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.systemReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.block != null) {
                if (enveloped) {
                    this.block.updateSyntax(reparser, false);
                    reparser.updateLocation(this.block.getLocation());
                } else if (reparser.envelopsDamage(this.block.getLocation())) {
                    try {
                        this.block.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.block.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.runsOnReference != null) {
            this.runsOnReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnReference.getLocation());
        }
        if (this.systemReference != null) {
            this.systemReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.systemReference.getLocation());
        }
        if (this.block != null) {
            this.block.updateSyntax(reparser, false);
            reparser.updateLocation(this.block.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnReference != null) {
            this.runsOnReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.systemReference != null) {
            this.systemReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.block != null) {
            this.block.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.runsOnReference != null && !this.runsOnReference.accept(v)) {
            return false;
        }
        if (this.systemReference != null && !this.systemReference.accept(v)) {
            return false;
        }
        return this.block == null || this.block.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        if (this.formalParList != null) {
            this.formalParList.setGenName(genName);
        }
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        aData.addBuiltinTypeImport("TtcnError");
        aData.addBuiltinTypeImport("TC_End");
        aData.addBuiltinTypeImport("TitanFloat");
        aData.addBuiltinTypeImport("TitanVerdictType");
        aData.addBuiltinTypeImport("TTCN_Logger");
        aData.addCommonLibraryImport("TTCN_Runtime");
        source.append(MessageFormat.format("\tpublic static final TitanVerdictType testcase_{0}", genName));
        source.append('(');
        if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            this.formalParList.generateCode(aData, source);
            source.append(", ");
        }
        source.append("final boolean has_timer, final TitanFloat timer_value) {\n");
        source.append("\t\tTTCN_Runtime.check_begin_testcase(has_timer, timer_value);\n");
        this.getLocation().create_location_object(aData, source, "TESTCASE", this.getIdentifier().getDisplayName());
        if (this.formalParList != null) {
            this.formalParList.generateCodeSetUnbound(aData, source);
            this.formalParList.generateCodeShadowObjects(aData, source);
        }
        source.append("\t\ttry {\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Runtime.begin_testcase(\"{0}\", \"{1}\", \"{2}\", \"{3}\", ", this.getMyScope().getModuleScopeGen().getIdentifier().getDisplayName(), this.identifier.getDisplayName(), this.runsOnType.getMyScope().getModuleScopeGen().getIdentifier().getDisplayName(), this.runsOnType.getComponentBody().getIdentifier().getDisplayName()));
        if (this.systemType == null) {
            source.append(MessageFormat.format(" \"{0}\", \"{1}\", ", this.runsOnType.getMyScope().getModuleScopeGen().getIdentifier().getDisplayName(), this.runsOnType.getComponentBody().getIdentifier().getDisplayName()));
        } else {
            source.append(MessageFormat.format(" \"{0}\", \"{1}\", ", this.systemType.getMyScope().getModuleScopeGen().getIdentifier().getDisplayName(), this.systemType.getComponentBody().getIdentifier().getDisplayName()));
        }
        source.append("has_timer, timer_value);\n");
        this.block.generateCode(aData, source);
        source.append("\t\t} catch (TtcnError error) {\n");
        source.append("\t\t\t// intentionally empty\n");
        source.append("\t\t} catch (TC_End error) {\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.FUNCTION_UNQUALIFIED, \"Test case {0} was stopped.\");\n", this.identifier.getDisplayName()));
        source.append("\t\t} catch (Exception exception) {\n");
        source.append("\t\t\tnew TtcnError(exception);\n");
        source.append(MessageFormat.format("\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.FUNCTION_UNQUALIFIED, \"Test case {0} was stopped.\");\n", this.identifier.getDisplayName()));
        if (aData.getAddSourceInfo()) {
            source.append("\t\t} finally {\n");
            this.getLocation().release_location_object(aData, source);
        }
        source.append("\t\t}\n");
        source.append("\t\treturn new TitanVerdictType(TTCN_Runtime.end_testcase());\n");
        source.append("\t}\n\n");
        sb.append((CharSequence)source);
        if (this.formalParList == null || this.formalParList.getNofParameters() == 0) {
            aData.addBuiltinTypeImport("Ttcn3Float");
            StringBuilder executeAllTestcases = aData.getExecuteAllTestcase();
            executeAllTestcases.append(MessageFormat.format("\t\t{0}(false, new TitanFloat( new Ttcn3Float( 0.0 ) ));\n", this.getGenNameFromScope(aData, source, "testcase_")));
        }
        StringBuilder executeTestcase = aData.getExecuteTestcase();
        executeTestcase.append("if(\"").append(this.identifier.getDisplayName()).append("\".equals(tescase_name)) {\n");
        if (this.formalParList == null || this.formalParList.getNofParameters() == 0) {
            aData.addBuiltinTypeImport("Ttcn3Float");
            executeTestcase.append(MessageFormat.format("\t\t\t{0}(false, new TitanFloat( new Ttcn3Float( 0.0 ) ));\n", this.getGenNameFromScope(aData, source, "testcase_")));
        } else {
            executeTestcase.append("\t\t\tthrow new TtcnError(MessageFormat.format(\"Test case {0} in module {1} cannot be executed individually (without control part) because it has parameters.\", tescase_name, module_name));\n");
        }
        executeTestcase.append("\t\t} else ");
        if (this.formalParList == null || this.formalParList.getNofParameters() == 0) {
            StringBuilder listTestcases = aData.getListTestcases();
            listTestcases.append(MessageFormat.format("\t\tSystem.out.println(\"{0}.{1}\");\n", this.getMyScope().getModuleScope().getIdentifier().getDisplayName(), this.identifier.getDisplayName()));
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText(KIND).addText(" ");
        this.hoverContent.addStyledText(this.getFullName(), 1);
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addParamsContent(this.hoverContent, this.formalParList);
            dc.addVerdictsContent(this.hoverContent);
            dc.addConfigContent(this.hoverContent);
            dc.addRequirementsContent(this.hoverContent);
            dc.addPurposeContent(this.hoverContent);
            dc.addPriorityContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        } else if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            this.hoverContent.addTag("Parameters");
            for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParList.getParameterByIndex(i);
                String paramType = param.getFormalParamType();
                StringBuilder sb = new StringBuilder(param.getIdentifier().getDisplayName());
                sb.append(" (").append(paramType != null ? paramType : "<?>").append(")");
                this.hoverContent.addIndentedText(sb.toString(), "");
            }
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n");
        if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParList.getParameterByIndex(i);
                sb.append(ind).append("@param").append(" ").append(param.getIdentifier().getDisplayName()).append("\n");
            }
        }
        sb.append(ind).append("@verdict").append(" pass ").append("\n").append(ind).append("@verdict").append(" fail ").append("\n").append(ind).append("@verdict").append(" inconc ").append("\n");
        sb.append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

