/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.statements.Assignment_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Return_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Property_Type
extends Type {
    private static final String INITIALVALUEWITHOUTSETTER = "A property without a setter cannot have an initial value";
    private static final String EMPTYBODY = "An empty property body is not allowed";
    private static final String GETMISSINGRETURN = "Statement block of a property getter should have a `return' statement";
    private static final String MODIFIERFINALABSTRACT = "Property {0} cannot be both abstract and final";
    private static final String ABSTRACTWITHBODY = "Abstract {0} should not have a body";
    private static final String ABSTRACTWITHOUTBODY = "Abstract properties shall contain a property body";
    private static final String GETTER = "getter";
    private static final String SETTER = "setter";
    private Type myType;
    private StatementBlock getterStatementBlock;
    private StatementBlock setterStatementBlock;
    private TTCN3Template getterTemplate;
    private Assignment_Statement setterAssignment;
    private TTCN3Template initValTemplate;
    private FormalParameterList fpList;
    private boolean hasGetter;
    private boolean hasSetter;
    private boolean hasBody;
    private boolean isAutoProperty;
    private boolean isAbstract;
    private boolean isFinal;
    private boolean isDeterministic;
    private boolean isInternal;
    private boolean isGetterAbstract;
    private boolean isSetterAbstract;
    private boolean isGetterFinal;
    private boolean isSetterFinal;
    private boolean isGetterDeterministic;
    private boolean isSetterDeterministic;
    private VisibilityModifier getterModifier;
    private VisibilityModifier setterModifier;
    private Location getterVisibilityLocation;
    private Location setterVisibilityLocation;
    private Location getterModifierLocation;
    private Location setterModifierLocation;

    public Property_Type(Type type, boolean isAbstract, boolean isFinal, boolean isDeterministic, boolean isInternal) {
        this.myType = type;
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.isDeterministic = isDeterministic;
        this.isInternal = isInternal;
        this.setterStatementBlock = null;
        this.getterStatementBlock = null;
        this.setterAssignment = null;
        this.getterTemplate = null;
        this.initValTemplate = null;
        this.isAutoProperty = true;
        this.hasSetter = false;
        this.hasGetter = false;
        this.hasBody = false;
        FormalParameter valueParam = new FormalParameter(null, Assignment.Assignment_type.A_PAR_VAL_IN, this.myType, new Identifier(Identifier.Identifier_type.ID_TTCN, "value"), null, null);
        ArrayList<FormalParameter> paramList = new ArrayList<FormalParameter>();
        paramList.add(valueParam);
        this.fpList = new FormalParameterList(paramList);
    }

    public void setStatementBlockGetter(StatementBlock sb, TTCN3Template template, VisibilityModifier modifier, boolean isAbstract, boolean isFinal, boolean isDeterministic, Location visibilityLocation, Location modifierLocation) {
        this.hasGetter = true;
        this.getterStatementBlock = sb;
        this.getterModifier = modifier;
        this.isGetterAbstract = isAbstract;
        this.isGetterFinal = isFinal;
        this.isGetterDeterministic = isDeterministic;
        this.getterVisibilityLocation = visibilityLocation;
        this.getterModifierLocation = modifierLocation;
        this.getterTemplate = template;
        if (this.getterStatementBlock == null && this.getterTemplate != null) {
            Return_Statement rs = new Return_Statement(this.getterTemplate);
            rs.setLocation(this.getterTemplate.getLocation());
            this.getterStatementBlock = new StatementBlock();
            this.getterStatementBlock.addStatement(rs);
        }
        if (this.getterStatementBlock != null) {
            this.getterStatementBlock.setIsGetter();
            this.getterStatementBlock.setOwnerIsProperty();
            this.getterStatementBlock.setFullNameParent(this);
        }
    }

    public void setStatementBlockSetter(StatementBlock sb, Assignment_Statement assignment, VisibilityModifier modifier, boolean isAbstract, boolean isFinal, boolean isDeterministic, Location visibilityLocation, Location modifierLocation) {
        this.hasSetter = true;
        this.setterStatementBlock = sb;
        this.isSetterAbstract = isAbstract;
        this.isSetterFinal = isFinal;
        this.isSetterDeterministic = isDeterministic;
        this.setterVisibilityLocation = visibilityLocation;
        this.setterModifierLocation = modifierLocation;
        this.setterAssignment = assignment;
        if (this.setterStatementBlock == null && this.setterAssignment != null) {
            this.setterStatementBlock = new StatementBlock();
            this.setterStatementBlock.addStatement(this.setterAssignment);
        }
        if (this.setterStatementBlock != null) {
            this.setterStatementBlock.setIsSetter();
            this.setterStatementBlock.setOwnerIsProperty();
            this.setterStatementBlock.setFullNameParent(this);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.hasBody && !this.hasGetter() && !this.hasSetter()) {
            this.getLocation().reportSemanticError(EMPTYBODY);
        }
        this.checkModifiers();
        if (this.isAbstract && !this.hasBody) {
            this.getLocation().reportSemanticError(ABSTRACTWITHOUTBODY);
        }
        if (this.getterStatementBlock != null) {
            this.getterStatementBlock.check(timestamp);
            if (this.getterStatementBlock.hasReturn(timestamp) == StatementBlock.ReturnStatus_type.RS_NO) {
                this.getterStatementBlock.getLocation().reportSemanticError(GETMISSINGRETURN);
            }
        }
        if (this.setterStatementBlock != null) {
            this.setterStatementBlock.setValueParamList(this.fpList);
            this.setterStatementBlock.check(timestamp);
        }
        if (this.initValTemplate != null) {
            if (!this.hasSetter()) {
                this.initValTemplate.getLocation().reportSemanticError(INITIALVALUEWITHOUTSETTER);
                this.initValTemplate.setIsErroneous(true);
            }
            this.initValTemplate.setMyGovernor(this.myType);
            IValue value = this.initValTemplate.getValue();
            if (value != null) {
                value.setMyGovernor(this.myType);
                this.myType.checkThisValueRef(timestamp, value);
                this.myType.checkThisValue(timestamp, value, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
            }
        }
    }

    public void checkModifiers() {
        if (this.isAbstract) {
            this.isGetterAbstract = true;
            this.isSetterAbstract = true;
        }
        if (this.isGetterAbstract) {
            if (this.isGetterFinal) {
                this.getterModifierLocation.reportSemanticError(MessageFormat.format(MODIFIERFINALABSTRACT, GETTER));
            }
            if (this.getterStatementBlock != null || this.getterTemplate != null) {
                Location getterLoc = this.getterStatementBlock == null ? this.getterTemplate.getLocation() : this.getterStatementBlock.getLocation();
                getterLoc.reportSemanticError(MessageFormat.format(ABSTRACTWITHBODY, GETTER));
            }
        }
        if (this.isSetterAbstract) {
            if (this.isSetterFinal) {
                this.setterModifierLocation.reportSemanticError(MessageFormat.format(MODIFIERFINALABSTRACT, SETTER));
            }
            if (this.setterStatementBlock != null || this.setterAssignment != null) {
                Location setterLoc = this.setterStatementBlock == null ? this.setterAssignment.getLocation() : this.setterStatementBlock.getLocation();
                setterLoc.reportSemanticError(MessageFormat.format(ABSTRACTWITHBODY, SETTER));
            }
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_PROPERTY;
    }

    @Override
    public String getTypename() {
        return "property";
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return this.myType.getTypetype();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.getterStatementBlock != null) {
            this.getterStatementBlock.setMyScope(scope);
        }
        if (this.setterStatementBlock != null) {
            this.setterStatementBlock.setMyScope(scope);
        }
        if (this.initValTemplate != null) {
            this.initValTemplate.setMyScope(scope);
        }
    }

    public boolean hasSetter() {
        return this.isAutoProperty ? true : this.hasSetter;
    }

    public boolean hasGetter() {
        return this.isAutoProperty ? true : this.hasGetter;
    }

    public void setInitValTemplate(TTCN3Template template) {
        this.initValTemplate = template;
    }

    public void setHasBody() {
        this.hasBody = true;
    }

    public void setIsAutoProperty(boolean isAutoProperty) {
        this.isAutoProperty = isAutoProperty;
    }

    @Override
    public String getOutlineIcon() {
        return null;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        return this.myType;
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType result = this.getTypeRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return result;
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        return this.myType;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        return false;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        return false;
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return false;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return null;
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return null;
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        return null;
    }

    public void setDefinitions(Definition definition) {
        if (this.getterStatementBlock != null) {
            this.getterStatementBlock.setMyDefinition(definition);
        }
        if (this.setterStatementBlock != null) {
            this.setterStatementBlock.setMyDefinition(definition);
        }
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isAutoProperty() {
        return this.isAutoProperty;
    }

    public void generateAutoProperty(Definition definition) {
        if (!this.isAutoProperty) {
            return;
        }
        VisibilityModifier vm = definition.getVisibilityModifier();
        Reference valueRef = new Reference(null, Reference.Ref_Type.REF_VALUE);
        Identifier valueId = new Identifier(Identifier.Identifier_type.ID_TTCN, "value", null);
        FieldSubReference valueSubReference = new FieldSubReference(valueId);
        valueRef.addSubReference(valueSubReference);
        Reference thisRef = new Reference(definition.getIdentifier(), Reference.Ref_Type.REF_BASIC);
        FieldSubReference thisSubReference = new FieldSubReference(definition.getIdentifier());
        thisRef.addSubReference(thisSubReference);
        SpecificValue_Template temp = new SpecificValue_Template(new Referenced_Value(thisRef));
        SpecificValue_Template tempValue = new SpecificValue_Template(new Referenced_Value(valueRef));
        Assignment_Statement ass = new Assignment_Statement(thisRef, tempValue);
        this.setStatementBlockGetter(null, temp, vm, this.isAbstract, this.isFinal, this.isDeterministic, null, null);
        this.setStatementBlockSetter(null, ass, vm, this.isAbstract, this.isFinal, this.isDeterministic, null, null);
    }
}

