/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.wizards.NewConfigFileCreationWizardPage;
import org.eclipse.titan.designer.wizards.NewConfigFileOptionsWizardPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public final class NewConfigFileWizard
extends BasicNewResourceWizard {
    public static final String NEWCONFIGFILEWIZARD = "org.eclipse.titan.designer.wizards.NewConfigFileWizard";
    private static final String WIZARD_TITLE = "New Configuration File";
    private NewConfigFileCreationWizardPage mainPage;
    private NewConfigFileOptionsWizardPage optionsPage;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WIZARD_TITLE);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewConfigFileCreationWizardPage(this.getSelection(), this);
        this.addPage((IWizardPage)this.mainPage);
        this.optionsPage = new NewConfigFileOptionsWizardPage();
        this.addPage((IWizardPage)this.optionsPage);
    }

    NewConfigFileOptionsWizardPage getOptionsPage() {
        return this.optionsPage;
    }

    public boolean performFinish() {
        IFile newConfigFile;
        if (this.mainPage.getContainerFullPath().append(this.mainPage.getFileName()).getFileExtension() == null) {
            this.mainPage.setFileName(this.mainPage.getFileName() + '.' + GlobalParser.SUPPORTED_CONFIG_FILE_EXTENSIONS[0]);
        }
        if ((newConfigFile = this.mainPage.createNewFile()) != null) {
            try {
                ProjectFileHandler pfHandler = new ProjectFileHandler(newConfigFile.getProject());
                pfHandler.saveProjectSettings();
                newConfigFile.touch((IProgressMonitor)new NullProgressMonitor());
                PropertyNotificationManager.firePropertyChange((IResource)newConfigFile);
                this.selectAndRevealNewModule(newConfigFile);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        return true;
    }

    private void selectAndRevealNewModule(IFile newModule) {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            IEditorDescriptor desc = ConfigTextEditor.findCFGEditor(workbench);
            IWorkbenchPage page = window.getActivePage();
            try {
                page.openEditor((IEditorInput)new FileEditorInput(newModule), desc.getId());
            }
            catch (PartInitException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        this.selectAndReveal((IResource)newModule);
    }
}

