/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Connect_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Function_Instance_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Map_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Start_Component_Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ComponentCreateExpression;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.windows.ComponentFinderGraphEditor;
import org.eclipse.titanium.graph.visualization.BadLayoutException;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class ComponentFinderFromEditor
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.doOpenComponentFinderGraphForSelected();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doOpenComponentFinderGraphForSelected();
        return null;
    }

    private void doOpenComponentFinderGraphForSelected() {
        Definition def = this.findSelection();
        if (!(def instanceof Def_Testcase)) {
            return;
        }
        IFile selectedFile = (IFile)def.getLocation().getFile();
        final IProject project = selectedFile.getProject();
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final DirectedSparseGraph graph = new DirectedSparseGraph();
        HashMap<String, NodeDescriptor> labels = new HashMap<String, NodeDescriptor>();
        final Def_Testcase tc = (Def_Testcase)def;
        System.out.println("dOCFGFS: " + tc.getFullName());
        HashMap<Component_Type, List<Component_Type>> components = new HashMap<Component_Type, List<Component_Type>>();
        Component_Type ct = tc.getRunsOnType(CompilationTimeStamp.getBaseTimestamp());
        components.put(ct, new ArrayList());
        TestcaseVisitor vis = new TestcaseVisitor(new ArrayList<Def_Function>(), components, ct);
        tc.accept((ASTVisitor)vis);
        for (Map.Entry entry : vis.getComponents().entrySet()) {
            for (Object object : (List)entry.getValue()) {
            }
        }
        for (Map.Entry entry : vis.getComponents().entrySet()) {
            NodeDescriptor node = new NodeDescriptor(((Component_Type)entry.getKey()).getFullName(), ((Component_Type)entry.getKey()).getFullName(), NodeColours.LIGHT_GREEN, project, false, ((Component_Type)entry.getKey()).getLocation());
            if (!graph.containsVertex((Object)node)) {
                graph.addVertex((Object)node);
                labels.put(node.getName(), node);
            }
            for (Component_Type ct2 : (List)entry.getValue()) {
                EdgeDescriptor edge;
                NodeDescriptor node2 = new NodeDescriptor(ct2.getFullName(), ct2.getFullName(), NodeColours.LIGHT_GREEN, project, false, ct2.getLocation());
                if (!graph.containsVertex((Object)node2)) {
                    graph.addVertex((Object)node2);
                    labels.put(node2.getName(), node2);
                }
                if (graph.containsEdge((Object)(edge = new EdgeDescriptor(((Component_Type)entry.getKey()).getFullName() + "->" + ct2.getFullName(), Color.black)))) continue;
                graph.addEdge((Object)edge, (Object)((NodeDescriptor)labels.get(((Component_Type)entry.getKey()).getFullName())), (Object)((NodeDescriptor)labels.get(ct2.getFullName())), EdgeType.DIRECTED);
            }
        }
        String path = "";
        try {
            path = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path"));
        }
        catch (CoreException exc) {
            System.out.println("hiba");
        }
        final String oldPath = path;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                System.out.println("Dialog: " + tc.getFullName());
                FileDialog dialog = new FileDialog(new Shell(), 8192);
                dialog.setText("Save graph");
                dialog.setFilterPath(oldPath);
                dialog.setFilterExtensions(new String[]{"*.dot"});
                String graphFilePath = dialog.open();
                if (graphFilePath == null) {
                    return;
                }
                String newPath = graphFilePath.substring(0, graphFilePath.lastIndexOf(File.separator) + 1);
                try {
                    QualifiedName name = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path");
                    project.setPersistentProperty(name, newPath);
                    GraphHandler.saveGraphToDot((Graph<NodeDescriptor, EdgeDescriptor>)graph, graphFilePath, tc.getFullName());
                }
                catch (BadLayoutException be) {
                    ErrorReporter.logExceptionStackTrace((String)("Error while saving image to " + newPath), (Throwable)be);
                }
                catch (Exception ce) {
                    ErrorReporter.logExceptionStackTrace((String)("Error while saving image to " + newPath), (Throwable)ce);
                }
            }
        });
        try {
            IEditorPart editor = page.findEditor((IEditorInput)new FileEditorInput(selectedFile));
            if (editor instanceof ComponentFinderGraphEditor) {
                ((ComponentFinderGraphEditor)editor).refreshGraph();
            } else {
                page.openEditor((IEditorInput)new FileEditorInput(selectedFile), "org.eclipse.titanium.graph.editors.ComponentFinderGraphEditor", true, 3);
            }
        }
        catch (Exception exc) {
            GUIErrorHandler errorHandler = new GUIErrorHandler();
            errorHandler.reportException("Error while parsing the project", exc);
        }
    }

    private Definition findSelection() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor)) {
            return null;
        }
        TTCN3Editor targetEditor = (TTCN3Editor)editor;
        IResource selectedRes = this.extractResource((IEditorPart)targetEditor);
        if (!(selectedRes instanceof IFile)) {
            ErrorReporter.logError((String)("SelectionFinder.findSelection(): Selected resource `" + selectedRes.getName() + "' is not a file."));
            return null;
        }
        IFile selectedFile = (IFile)selectedRes;
        IProject sourceProj = selectedFile.getProject();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)sourceProj);
        Module selectedModule = projectSourceParser.containedModule(selectedFile);
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        TextSelection textSelection = this.extractSelection(selectionService.getSelection());
        int selectionOffset = textSelection.getOffset() + textSelection.getLength();
        SelectionFinderVisitor selVisitor = new SelectionFinderVisitor(selectionOffset);
        selectedModule.accept((ASTVisitor)selVisitor);
        Definition selectedDef = selVisitor.getSelection();
        if (selectedDef == null) {
            ErrorReporter.logWarning((String)"SelectionFinder.findSelection(): Visitor did not find a definition in the selection.");
            IStatusLineManager statusLineManager = targetEditor.getEditorSite().getActionBars().getStatusLineManager();
            statusLineManager.setErrorMessage("No definition selected");
            return null;
        }
        return selectedDef;
    }

    private IResource extractResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    private TextSelection extractSelection(ISelection sel) {
        if (!(sel instanceof TextSelection)) {
            ErrorReporter.logError((String)"Selection is not a TextSelection.");
            return null;
        }
        return (TextSelection)sel;
    }

    private static class ModuleVisitor
    extends ASTVisitor {
        private final List<Component_Type> comps = new ArrayList<Component_Type>();
        private final Def_Port port;

        ModuleVisitor(Def_Port port) {
            this.port = port;
        }

        private List<Component_Type> getComponents() {
            return this.comps;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Component_Type) {
                Component_Type ct = (Component_Type)node;
                List defs = ct.getComponentBody().getDefinitions();
                for (Definition def : defs) {
                    if (def == null || !def.equals(this.port)) continue;
                    this.comps.add(ct);
                    return 2;
                }
            }
            return 3;
        }
    }

    private static class TestcaseVisitor
    extends ASTVisitor {
        private final HashMap<Component_Type, List<Component_Type>> components = new HashMap();
        private final List<Def_Function> checkedFunctions;
        private int counter;
        private boolean cce;
        private final Component_Type comp;

        TestcaseVisitor(List<Def_Function> checkedFunctions, HashMap<Component_Type, List<Component_Type>> components, Component_Type comp) {
            this.components.putAll(components);
            this.checkedFunctions = checkedFunctions;
            this.counter = -1;
            this.cce = false;
            this.comp = comp;
        }

        private HashMap<Component_Type, List<Component_Type>> getComponents() {
            return this.components;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Connect_Statement || node instanceof Map_Statement) {
                this.counter = 0;
            } else if (node instanceof PortReference && (this.counter == 0 || this.counter == 1)) {
                ++this.counter;
                PortReference pr = (PortReference)node;
                Assignment as = pr.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (as != null && as instanceof Def_Port) {
                    Def_Port dp = (Def_Port)as;
                    ModuleVisitor mv = new ModuleVisitor(dp);
                    Module m = dp.getMyScope().getModuleScope();
                    m.accept((ASTVisitor)mv);
                    for (Component_Type ct : mv.getComponents()) {
                        if (!this.components.containsKey(this.comp)) {
                            this.components.put(this.comp, new ArrayList());
                        }
                        if (this.components.get(this.comp).contains(ct) || this.comp.equals(ct)) continue;
                        this.components.get(this.comp).add(ct);
                    }
                }
            } else if (node instanceof Function_Instance_Statement) {
                Function_Instance_Statement fis = (Function_Instance_Statement)node;
                Assignment as = fis.getReference().getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                this.analyzeFunction(as, this.comp);
            } else if (node instanceof ComponentCreateExpression) {
                this.cce = true;
            } else if (node instanceof Reference && this.cce) {
                this.cce = false;
                Reference ref = (Reference)node;
                Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                if (as.getType(CompilationTimeStamp.getBaseTimestamp()) instanceof Component_Type) {
                    Component_Type ct = (Component_Type)as.getType(CompilationTimeStamp.getBaseTimestamp());
                    if (!this.components.containsKey(this.comp)) {
                        this.components.put(this.comp, new ArrayList());
                    }
                    if (!this.components.get(this.comp).contains(ct) && !this.comp.equals(ct)) {
                        this.components.get(this.comp).add(ct);
                    }
                }
            } else if (node instanceof Start_Component_Statement) {
                Assignment as = ((Start_Component_Statement)node).getFunctionInstanceReference().getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                this.analyzeFunction(as, this.comp);
            }
            return 3;
        }

        public void analyzeFunction(Assignment assignment, Component_Type component) {
            Def_Function df;
            if (assignment != null && assignment instanceof Def_Function && !this.checkedFunctions.contains(df = (Def_Function)assignment)) {
                this.checkedFunctions.add(df);
                TestcaseVisitor tv = null;
                if (df.getRunsOnType(CompilationTimeStamp.getBaseTimestamp()) != null) {
                    Component_Type fComp = df.getRunsOnType(CompilationTimeStamp.getBaseTimestamp());
                    if (!this.components.containsKey(this.comp)) {
                        this.components.put(this.comp, new ArrayList());
                    }
                    if (!fComp.equals(component) && !this.components.get(component).contains(fComp)) {
                        this.components.get(component).add(fComp);
                        this.components.put(fComp, new ArrayList());
                    }
                    tv = new TestcaseVisitor(this.checkedFunctions, this.components, fComp);
                } else {
                    tv = new TestcaseVisitor(this.checkedFunctions, this.components, component);
                }
                df.accept((ASTVisitor)tv);
                this.components.putAll(tv.getComponents());
            }
        }
    }

    private static class SelectionFinderVisitor
    extends ASTVisitor {
        private Definition def;
        private final int offset;

        SelectionFinderVisitor(int selectionOffset) {
            this.offset = selectionOffset;
        }

        private Definition getSelection() {
            return this.def;
        }

        public int visit(IVisitableNode node) {
            if (!(node instanceof ILocateableNode)) {
                return 3;
            }
            Location loc = ((ILocateableNode)node).getLocation();
            if (loc == null) {
                return 2;
            }
            if (!loc.containsOffset(this.offset)) {
                return 1;
            }
            if (node instanceof Definition) {
                this.def = (Definition)node;
            }
            return 3;
        }
    }
}

