/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.windows;

import com.google.common.base.Function;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeColours;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.GraphGenerator;
import org.eclipse.titanium.graph.gui.common.CustomVisualizationViewer;
import org.eclipse.titanium.graph.gui.common.Layouts;
import org.eclipse.titanium.graph.gui.dialogs.ExportImagePreferencesDialog;
import org.eclipse.titanium.graph.gui.utils.LayoutEntry;
import org.eclipse.titanium.graph.gui.windows.SatelliteView;
import org.eclipse.titanium.graph.utils.CheckParallelPaths;
import org.eclipse.titanium.graph.utils.CircleCheck;
import org.eclipse.titanium.graph.visualization.BadLayoutException;
import org.eclipse.titanium.graph.visualization.ErrorType;
import org.eclipse.titanium.graph.visualization.GraphHandler;
import org.eclipse.titanium.gui.FindWindow;
import org.eclipse.titanium.gui.Searchable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorPart;

public abstract class GraphEditor
extends EditorPart
implements Searchable<NodeDescriptor> {
    protected DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph;
    protected GraphHandler handler;
    protected Function<NodeDescriptor, String> labeler;
    protected JPanel drawArea;
    protected Frame window;
    protected Dimension windowSize;
    protected LayoutEntry chosenLayout;
    protected IProject project;
    protected SatelliteView satView = null;
    protected Composite editorComposite = null;
    protected FindWindow<NodeDescriptor> wndFind = null;
    protected IHandlerService handlerService = null;
    protected Set<AbstractHandler> handlers = new HashSet<AbstractHandler>();
    protected JMenu layoutMenu;
    protected ActionListener layoutListener;
    protected ButtonGroup layoutGroup;
    protected JMenuBar menuBar;
    protected GraphGenerator generator;
    protected final GUIErrorHandler errorHandler;
    private static final String ID = "org.eclipse.titanium.graph.editors.GraphEditor";
    public static final String GRAPH_CONTEXT_ID = "org.eclipse.titanium.contexts.GraphContext";
    public static final String GRAPH_SAVECMD_ID = "org.eclipse.titanium.commands.GraphSave";
    public static final String GRAPH_EXPORTCMD_ID = "org.eclipse.titanium.commands.GraphExport";
    public static final String GRAPH_SEARCHCMD_ID = "org.eclipse.titanium.commands.GraphSearch";
    protected static final String LOGENTRYNOTE = " (see error log for further information)";

    public GraphEditor() {
        this.chosenLayout = Layouts.LAYOUT_TDAG.newInstance();
        this.errorHandler = new GUIErrorHandler();
    }

    public void dispose() {
        super.dispose();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GraphEditor.this.window != null) {
                    GraphEditor.this.window.dispose();
                }
            }
        });
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphEditor.this.wndFind != null) {
                    GraphEditor.this.wndFind.close();
                }
            }
        });
        IWorkbenchWindow wind = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wind == null) {
            return;
        }
        IEditorReference[] editors = wind.getActivePage().findEditors(null, ID, 2);
        if (editors != null && editors.length == 0 && this.satView != null) {
            this.satView.setEditor(null);
            this.satView.clear();
        }
        for (AbstractHandler hnd : this.handlers) {
            hnd.dispose();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        ErrorReporter.INTERNAL_ERROR((String)"doSave called from a graph editor, where this functionality is not supported.");
    }

    public void doSaveAs() {
        ErrorReporter.INTERNAL_ERROR((String)"doSaveAs called from a graph editor, where this functionality is not supported.");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext(GRAPH_CONTEXT_ID);
        this.handlerService = (IHandlerService)site.getService(IHandlerService.class);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(final Composite parent) {
        this.initGeneratorAndHandler(parent);
        this.editorComposite = new Composite(parent, 0x1040000);
        this.window = SWT_AWT.new_Frame((Composite)this.editorComposite);
        this.windowSize = new Dimension(parent.getSize().x, parent.getSize().y);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point tmpSize = parent.getSize();
                GraphEditor.this.windowSize = new Dimension(tmpSize.x, tmpSize.y);
                if (GraphEditor.this.handler != null) {
                    GraphEditor.this.handler.changeWindowSize(GraphEditor.this.windowSize);
                }
                if (GraphEditor.this.window != null && GraphEditor.this.drawArea != null) {
                    GraphEditor.this.drawArea.setPreferredSize(GraphEditor.this.windowSize);
                    GraphEditor.this.window.setPreferredSize(GraphEditor.this.windowSize);
                    GraphEditor.this.window.repaint();
                }
            }
        });
        this.project = ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
        this.setPartName(this.getPartName() + " - " + this.project.getName());
        this.satView = (SatelliteView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.titanium.graph.gui.windows.SatelliteView");
        if (this.satView != null) {
            this.satView.setEditor(this);
        } else {
            try {
                this.satView = (SatelliteView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.titanium.graph.gui.windows.SatelliteView");
                this.satView.setEditor(this);
            }
            catch (PartInitException e) {
                this.errorHandler.reportException("Error while opening the view", (Exception)((Object)e));
            }
        }
        this.initWindow();
    }

    public void setFocus() {
        IWorkbenchWindow tmpWnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (tmpWnd != null) {
            this.satView = (SatelliteView)tmpWnd.getActivePage().findView("org.eclipse.titanium.graph.gui.windows.SatelliteView");
        }
        final GraphEditor thisEditor = this;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphEditor.this.handler != null && GraphEditor.this.satView != null) {
                    GraphEditor.this.satView.add(GraphEditor.this.handler.getSatelliteViewer());
                    GraphEditor.this.satView.setEditor(thisEditor);
                }
            }
        });
    }

    protected void initWindow() {
        this.drawArea = new JPanel();
        this.window.add((Component)this.drawArea, "Center");
        this.drawArea.setSize(this.windowSize.width, this.windowSize.height);
        this.drawArea.setPreferredSize(new Dimension(this.windowSize.width, this.windowSize.height));
        this.menuBar = new JMenuBar();
        this.window.add((Component)this.menuBar, "North");
        JMenu mnFile = new JMenu("File");
        ActionListener saveGraph = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = "";
                try {
                    path = GraphEditor.this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path"));
                }
                catch (CoreException exc) {
                    GraphEditor.this.errorHandler.reportException("Error while reading persistent property", (Exception)((Object)exc));
                }
                final String oldPath = path;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FileDialog dialog = new FileDialog(GraphEditor.this.editorComposite.getShell(), 8192);
                        dialog.setText("Save Pajek file");
                        dialog.setFilterPath(oldPath);
                        dialog.setFilterExtensions(new String[]{"*.net", "*.dot"});
                        String graphFilePath = dialog.open();
                        if (graphFilePath == null) {
                            return;
                        }
                        String newPath = graphFilePath.substring(0, graphFilePath.lastIndexOf(File.separator) + 1);
                        try {
                            QualifiedName name = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path");
                            GraphEditor.this.project.setPersistentProperty(name, newPath);
                            if ("dot".equals(graphFilePath.substring(graphFilePath.lastIndexOf(46) + 1, graphFilePath.length()))) {
                                GraphHandler.saveGraphToDot(GraphEditor.this.graph, graphFilePath, GraphEditor.this.project.getName());
                            } else {
                                GraphHandler.saveGraphToPajek(GraphEditor.this.graph, graphFilePath);
                            }
                        }
                        catch (BadLayoutException be) {
                            ErrorReporter.logExceptionStackTrace((String)("Error while saving image to " + newPath), (Throwable)be);
                            GraphEditor.this.errorHandler.reportErrorMessage("Bad layout\n\n" + be.getMessage());
                        }
                        catch (Exception ce) {
                            ErrorReporter.logExceptionStackTrace((String)("Error while saving image to " + newPath), (Throwable)ce);
                            GraphEditor.this.errorHandler.reportException("Error while setting persistent property", ce);
                        }
                    }
                });
            }
        };
        final JMenuItem mntmSave = new JMenuItem("Save (Ctrl+S)");
        mntmSave.addActionListener(saveGraph);
        mnFile.add(mntmSave);
        ActionListener exportImage = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = "";
                try {
                    path = GraphEditor.this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path"));
                }
                catch (CoreException exc) {
                    GraphEditor.this.errorHandler.reportException("Error while reading persistent property", (Exception)((Object)exc));
                }
                final String oldPath = path;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ExportImagePreferencesDialog prefDialog = new ExportImagePreferencesDialog(GraphEditor.this.editorComposite.getShell());
                        GraphHandler.ImageExportType mode = prefDialog.open();
                        FileDialog dialog = new FileDialog(GraphEditor.this.editorComposite.getShell(), 8192);
                        dialog.setText("Export image");
                        dialog.setFilterPath(oldPath);
                        dialog.setFilterExtensions(new String[]{"*.png"});
                        String graphFilePath = dialog.open();
                        if (graphFilePath == null) {
                            return;
                        }
                        String newPath = graphFilePath.substring(0, graphFilePath.lastIndexOf(File.separator) + 1);
                        try {
                            QualifiedName name = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Graph_Save_Path");
                            GraphEditor.this.project.setPersistentProperty(name, newPath);
                            GraphEditor.this.handler.saveToImage(graphFilePath, mode);
                        }
                        catch (BadLayoutException be) {
                            GraphEditor.this.errorHandler.reportException("Error while saving image", be);
                            GraphEditor.this.errorHandler.reportErrorMessage(be.getMessage());
                        }
                        catch (CoreException ce) {
                            GraphEditor.this.errorHandler.reportException("Error while setting persistent property", (Exception)((Object)ce));
                        }
                    }
                });
            }
        };
        final JMenuItem mntmExportToImage = new JMenuItem("Export to image file (Ctrl+E)");
        mntmExportToImage.addActionListener(exportImage);
        mnFile.add(mntmExportToImage);
        this.layoutMenu = new JMenu("Layout");
        this.layoutGroup = new ButtonGroup();
        this.layoutListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IProgressMonitor monitor = Job.getJobManager().createProgressGroup();
                monitor.beginTask("Change layout", 100);
                if (!(e.getSource() instanceof LayoutEntry)) {
                    GraphEditor.this.errorHandler.reportErrorMessage("Unexpected error\n\nAn unusual error has been logged (see error log for further information)");
                    ErrorReporter.logError((String)"The layout changing event's source is not of type \"LayoutEntry\"!");
                    return;
                }
                LayoutEntry layout = (LayoutEntry)e.getSource();
                if (GraphEditor.this.handler.getVisualizator() != null) {
                    GraphEditor.this.drawArea.remove((Component)((Object)GraphEditor.this.handler.getVisualizator()));
                }
                try {
                    GraphEditor.this.handler.changeLayout(layout, GraphEditor.this.windowSize);
                    GraphEditor.this.drawArea.add((Component)((Object)GraphEditor.this.handler.getVisualizator()));
                    if (GraphEditor.this.satView != null) {
                        GraphEditor.this.satView.add(GraphEditor.this.handler.getSatelliteViewer());
                    }
                    GraphEditor.this.window.pack();
                }
                catch (BadLayoutException exc) {
                    layout.setSelected(false);
                    GraphEditor.this.chosenLayout.setSelected(true);
                    if (exc.getType() == ErrorType.EMPTY_GRAPH || exc.getType() == ErrorType.NO_OBJECT) {
                        return;
                    }
                    try {
                        GraphEditor.this.handler.changeLayout(GraphEditor.this.chosenLayout, GraphEditor.this.windowSize);
                        GraphEditor.this.drawArea.add((Component)((Object)GraphEditor.this.handler.getVisualizator()));
                        if (GraphEditor.this.satView != null) {
                            GraphEditor.this.satView.add(GraphEditor.this.handler.getSatelliteViewer());
                        }
                        GraphEditor.this.window.pack();
                        monitor.done();
                    }
                    catch (BadLayoutException exc2) {
                        monitor.done();
                        if (exc2.getType() != ErrorType.CYCLIC_GRAPH && exc2.getType() != ErrorType.EMPTY_GRAPH) {
                            GraphEditor.this.errorHandler.reportException("Error while creating layout", exc2);
                        } else {
                            GraphEditor.this.errorHandler.reportErrorMessage(exc2.getMessage());
                        }
                    }
                    catch (IllegalStateException exc3) {
                        monitor.done();
                        GraphEditor.this.errorHandler.reportException("Error while creating layout", exc3);
                    }
                    if (exc.getType() != ErrorType.CYCLIC_GRAPH && exc.getType() != ErrorType.EMPTY_GRAPH) {
                        GraphEditor.this.errorHandler.reportException("Error while creating layout", exc);
                    } else {
                        GraphEditor.this.errorHandler.reportErrorMessage(exc.getMessage());
                    }
                }
                catch (IllegalStateException exc) {
                    layout.setSelected(false);
                    GraphEditor.this.chosenLayout.setSelected(true);
                    try {
                        GraphEditor.this.handler.changeLayout(GraphEditor.this.chosenLayout, GraphEditor.this.windowSize);
                        GraphEditor.this.drawArea.add((Component)((Object)GraphEditor.this.handler.getVisualizator()));
                        if (GraphEditor.this.satView != null) {
                            GraphEditor.this.satView.add(GraphEditor.this.handler.getSatelliteViewer());
                        }
                        GraphEditor.this.window.pack();
                        monitor.done();
                    }
                    catch (BadLayoutException exc2) {
                        monitor.done();
                        if (exc2.getType() != ErrorType.CYCLIC_GRAPH && exc2.getType() != ErrorType.EMPTY_GRAPH) {
                            GraphEditor.this.errorHandler.reportException("Error while creating layout", exc2);
                        } else {
                            GraphEditor.this.errorHandler.reportErrorMessage(exc2.getMessage());
                        }
                    }
                    catch (IllegalStateException exc3) {
                        monitor.done();
                        GraphEditor.this.errorHandler.reportException("Error while creating layout", exc3);
                    }
                    GraphEditor.this.errorHandler.reportException("Error while creating layout", exc);
                }
                GraphEditor.this.chosenLayout = layout.newInstance();
                monitor.done();
            }
        };
        JMenu findMenu = new JMenu("Find");
        final JMenuItem nodeByName = new JMenuItem("Node by name (Ctrl+F)");
        final GraphEditor thisEditor = this;
        nodeByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (GraphEditor.this.wndFind != null) {
                            GraphEditor.this.wndFind.close();
                        }
                        try {
                            GraphEditor.this.wndFind = new FindWindow<NodeDescriptor>(GraphEditor.this.editorComposite.getShell(), thisEditor, GraphEditor.this.graph.getVertices());
                            GraphEditor.this.wndFind.open();
                        }
                        catch (IllegalArgumentException e) {
                            GraphEditor.this.errorHandler.reportException("", e);
                        }
                    }
                });
            }
        });
        findMenu.add(nodeByName);
        JMenu tools = new JMenu("Tools");
        JMenuItem findCircles = new JMenuItem("Show circles");
        JMenuItem findPaths = new JMenuItem("Show parallel paths");
        JMenuItem clearResults = new JMenuItem("Clear Results");
        findCircles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Job circlesJob = new Job("Searching for circles"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (GraphEditor.this.graph == null) {
                            return null;
                        }
                        CircleCheck<NodeDescriptor, EdgeDescriptor> checker = new CircleCheck<NodeDescriptor, EdgeDescriptor>(GraphEditor.this.graph);
                        if (checker.isCyclic()) {
                            for (EdgeDescriptor edgeDescriptor : GraphEditor.this.graph.getEdges()) {
                                edgeDescriptor.setColour(Color.lightGray);
                            }
                            for (Deque deque : checker.getCircles()) {
                                for (EdgeDescriptor e : deque) {
                                    e.setColour(NodeColours.DARK_RED);
                                }
                            }
                            GraphEditor.this.refresh();
                        } else {
                            GraphEditor.this.errorHandler.reportInformation("Result:\n\nThis graph is not cyclic!");
                        }
                        return Status.OK_STATUS;
                    }
                };
                circlesJob.schedule();
            }
        });
        findPaths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Job pathsJob = new Job("Searching for parallel paths"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (GraphEditor.this.graph == null) {
                            return null;
                        }
                        CheckParallelPaths<NodeDescriptor, EdgeDescriptor> checker = null;
                        checker = new CheckParallelPaths<NodeDescriptor, EdgeDescriptor>((Graph<NodeDescriptor, EdgeDescriptor>)GraphEditor.this.graph);
                        if (checker.hasParallelPaths()) {
                            for (EdgeDescriptor edgeDescriptor : GraphEditor.this.graph.getEdges()) {
                                edgeDescriptor.setColour(Color.lightGray);
                            }
                            for (Deque deque : checker.getPaths()) {
                                for (EdgeDescriptor e : deque) {
                                    e.setColour(NodeColours.DARK_RED);
                                }
                            }
                            GraphEditor.this.refresh();
                        } else {
                            GraphEditor.this.errorHandler.reportInformation("Result:\n\nThere are no parallel paths in this graph!");
                        }
                        return Status.OK_STATUS;
                    }
                };
                pathsJob.schedule();
            }
        });
        clearResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                for (EdgeDescriptor e : GraphEditor.this.graph.getEdges()) {
                    e.setColour(Color.black);
                }
                GraphEditor.this.refresh();
            }
        });
        tools.add(findCircles);
        tools.add(findPaths);
        tools.add(clearResults);
        this.menuBar.add(mnFile);
        this.menuBar.add(findMenu);
        this.menuBar.add(tools);
        this.menuBar.add(this.layoutMenu);
        this.handlerService.activateHandler(GRAPH_SEARCHCMD_ID, (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                nodeByName.getActionListeners()[0].actionPerformed(null);
                GraphEditor.this.handlers.add(this);
                return null;
            }
        });
        this.handlerService.activateHandler(GRAPH_SAVECMD_ID, (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                mntmSave.getActionListeners()[0].actionPerformed(null);
                GraphEditor.this.handlers.add(this);
                return null;
            }
        });
        this.handlerService.activateHandler(GRAPH_EXPORTCMD_ID, (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                mntmExportToImage.getActionListeners()[0].actionPerformed(null);
                GraphEditor.this.handlers.add(this);
                return null;
            }
        });
        try {
            this.generator.generateGraph();
            this.setLabeller(this.generator.getLabeler());
            this.setGraph(this.generator.getGraph());
        }
        catch (InterruptedException ex) {
            this.errorHandler.reportException("Error while creating the graph", ex);
        }
    }

    public void setGraph(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> g) {
        this.graph = g;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GraphEditor.this.drawArea == null) {
                    return;
                }
                GraphEditor.this.drawArea.setPreferredSize(GraphEditor.this.windowSize);
                try {
                    GraphEditor.this.drawArea.removeAll();
                    GraphEditor.this.handler.drawGraph(GraphEditor.this.graph, GraphEditor.this.windowSize, GraphEditor.this.chosenLayout);
                    GraphEditor.this.drawArea.add((Component)((Object)GraphEditor.this.handler.getVisualizator()));
                    if (GraphEditor.this.satView != null) {
                        GraphEditor.this.satView.add(GraphEditor.this.handler.getSatelliteViewer());
                    }
                    GraphEditor.this.window.pack();
                    GraphEditor.this.recolour(GraphEditor.this.graph.getVertices());
                }
                catch (BadLayoutException be) {
                    ErrorReporter.logExceptionStackTrace((String)"Error while drawing graph", (Throwable)be);
                    GraphEditor.this.errorHandler.reportErrorMessage(be.getMessage());
                }
            }
        });
    }

    public void setLabeller(Function<NodeDescriptor, String> labeler) {
        this.labeler = labeler;
    }

    public void setSatellite(SatelliteView sat) {
        this.satView = sat;
        if (this.satView != null && this.handler != null) {
            this.satView.add(this.handler.getSatelliteViewer());
        }
    }

    public DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> getGraph() {
        return this.graph;
    }

    public void refresh() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphEditor.this.drawArea.repaint();
                if (GraphEditor.this.satView != null) {
                    GraphEditor.this.satView.repaint();
                }
            }
        });
    }

    public void refreshGraph() {
        if (this.generator == null) {
            return;
        }
        try {
            this.generator.generateGraph();
            this.setLabeller(this.generator.getLabeler());
            this.setGraph(this.generator.getGraph());
        }
        catch (InterruptedException ex) {
            this.errorHandler.reportException("Error while refreshing the graph", ex);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public GraphHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setResults(Collection<NodeDescriptor> results) {
        this.clearResults();
        this.addResults(results);
    }

    @Override
    public void clearResults() {
        this.recolour(this.graph.getVertices());
    }

    @Override
    public void addResults(Collection<NodeDescriptor> results) {
        for (NodeDescriptor node : results) {
            node.setNodeColour(NodeColours.RESULT_COLOUR);
        }
    }

    @Override
    public void elemChosen(NodeDescriptor element) {
        CustomVisualizationViewer visualisator = this.handler.getVisualizator();
        visualisator.jumpToPlace((Point2D)visualisator.getGraphLayout().apply((Object)element));
        for (NodeDescriptor node : this.graph.getVertices()) {
            node.setNodeColour(NodeColours.NOT_RESULT_COLOUR);
        }
        element.setNodeColour(NodeColours.RESULT_COLOUR);
    }

    public abstract void recolour(Collection<NodeDescriptor> var1);

    protected abstract void initGeneratorAndHandler(Composite var1);
}

