/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.preferences.PreferenceUtils;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DecipheringPreferenceHandler {
    private static final String VERSION_ATTRIBUTE_KEY = "version";
    private static final String DECIPHERING_XML_VERSION = "1.0";
    private static final String TAG_ROOT = "org.eclipse.titan.log.viewer.properties.MessageDecipheringPreferencePage";
    private static final String TAG_RULE_SET = "ruleset";
    private static final String TAG_NAME = "name";
    private static final String TAG_MSG_TYPE_LIST = "messagetypelist";
    private static final String TAG_MSG_TYPE = "messagetype";
    private static final String TAG_RULE_LIST = "rulelist";
    private static final String TAG_RULE = "rule";
    private static final String RULESETS_PREFIX = "org.eclipse.titan.log.viewer.preferences.deciphering.rulesets";
    private static final String MSG_TYPES_QUALIFIER = ".msgtypes";
    public static final Pattern MSGTPYE_PATTERN = Pattern.compile("@?([a-z]+[a-z0-9_]*)(\\.([a-z]+[a-z0-9_]*))*", 2);
    public static final Pattern RULE_PATTERN = Pattern.compile("([a-z]+[a-z0-9_]*)(\\.([a-z]+[a-z0-9_]*))*", 2);

    private DecipheringPreferenceHandler() {
    }

    public static String getPreferenceKeyForRulesets() {
        return RULESETS_PREFIX;
    }

    public static String getPreferenceKeyForRuleset(String rulesetName) {
        return "org.eclipse.titan.log.viewer.preferences.deciphering.rulesets." + rulesetName;
    }

    public static String getPreferenceKeyForMessageTypeList(String rulesetName) {
        return DecipheringPreferenceHandler.getPreferenceKeyForRuleset(rulesetName) + MSG_TYPES_QUALIFIER;
    }

    public static String getPreferenceKeyForRuleList(String rulesetName, String msgType) {
        return DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(rulesetName) + "." + msgType;
    }

    public static List<String> getAvailableRuleSets() {
        return PreferenceUtils.deserializeFromString((String)DecipheringPreferenceHandler.getPreferenceStore().getString(RULESETS_PREFIX));
    }

    public static Map<String, List<String>> getRuleset(String name) {
        if (!DecipheringPreferenceHandler.getAvailableRuleSets().contains(name)) {
            return null;
        }
        List msgTypes = PreferenceUtils.deserializeFromString((String)DecipheringPreferenceHandler.getPreferenceStore().getString(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(name)));
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String msgType : msgTypes) {
            List rules = PreferenceUtils.deserializeFromString((String)DecipheringPreferenceHandler.getPreferenceStore().getString(DecipheringPreferenceHandler.getPreferenceKeyForRuleList(name, msgType)));
            result.put(msgType, new ArrayList(rules));
        }
        return result;
    }

    public static void addRuleSet(String rulesetName, Map<String, List<String>> ruleset) {
        IPreferenceStore prefStore = DecipheringPreferenceHandler.getPreferenceStore();
        String rulesetList = prefStore.getString(RULESETS_PREFIX);
        List rulesets = PreferenceUtils.deserializeFromString((String)rulesetList);
        if (!rulesets.contains(rulesetName)) {
            rulesets.add(rulesetName);
            prefStore.setValue(RULESETS_PREFIX, PreferenceUtils.serializeToString((Iterable)rulesets));
        }
        Set<String> msgTypes = ruleset.keySet();
        prefStore.setValue(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(rulesetName), PreferenceUtils.serializeToString(msgTypes));
        for (Map.Entry<String, List<String>> entry : ruleset.entrySet()) {
            prefStore.setValue(DecipheringPreferenceHandler.getPreferenceKeyForRuleList(rulesetName, entry.getKey()), PreferenceUtils.serializeToString((Iterable)entry.getValue()));
        }
    }

    public static void deleteRuleset(String rulesetName) {
        IPreferenceStore prefStore = DecipheringPreferenceHandler.getPreferenceStore();
        String rulesetList = prefStore.getString(RULESETS_PREFIX);
        List rulesets = PreferenceUtils.deserializeFromString((String)rulesetList);
        if (!rulesets.contains(rulesetName)) {
            return;
        }
        rulesets.remove(rulesetName);
        prefStore.setValue(RULESETS_PREFIX, PreferenceUtils.serializeToString((Iterable)rulesets));
        List msgTypesList = PreferenceUtils.deserializeFromString((String)prefStore.getString(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(rulesetName)));
        prefStore.setToDefault(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(rulesetName));
        for (String msgType : msgTypesList) {
            prefStore.setToDefault(DecipheringPreferenceHandler.getPreferenceKeyForRuleList(rulesetName, msgType));
        }
    }

    public static void deleteMsgType(String rulesetName, String msgType) {
        IPreferenceStore prefStore = DecipheringPreferenceHandler.getPreferenceStore();
        List msgTypesList = PreferenceUtils.deserializeFromString((String)prefStore.getString(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(rulesetName)));
        msgTypesList.remove(msgType);
        prefStore.setValue(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(rulesetName), PreferenceUtils.serializeToString((Iterable)msgTypesList));
        prefStore.setToDefault(DecipheringPreferenceHandler.getPreferenceKeyForRuleList(rulesetName, msgType));
    }

    public static void exportToFile(File file) {
        try {
            Document document = DecipheringPreferenceHandler.createDocument();
            Element root = document.getDocumentElement();
            root.setAttribute(VERSION_ATTRIBUTE_KEY, DECIPHERING_XML_VERSION);
            List ruleSets = PreferenceUtils.deserializeFromString((String)DecipheringPreferenceHandler.getPreferenceStore().getString(RULESETS_PREFIX));
            for (String ruleSet : ruleSets) {
                Element ruleSetElem = DecipheringPreferenceHandler.createXMLElementFromRuleSet(document, ruleSet);
                root.appendChild(ruleSetElem);
            }
            DecipheringPreferenceHandler.writeToFile(file, document);
        }
        catch (FileNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(e));
        }
        catch (ParserConfigurationException e) {
            ErrorReporter.logExceptionStackTrace((String)("While exporting into `" + file.getName() + "'"), (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("LogViewerPreferenceRootPage.2") + e));
        }
        catch (TransformerException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("LogViewerPreferenceRootPage.2") + e));
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("LogViewerPreferenceRootPage.2") + e));
        }
    }

    private static Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation implementation = builder.getDOMImplementation();
        return implementation.createDocument(null, TAG_ROOT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, Document document) throws IOException, TransformerException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            file.createNewFile();
            stream = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)stream, "utf-8");
            DOMSource input = new DOMSource(document);
            StreamResult output = new StreamResult(writer);
            TransformerFactory xFormFactory = TransformerFactory.newInstance();
            xFormFactory.setAttribute("indent-number", 2);
            Transformer idTransform = xFormFactory.newTransformer();
            idTransform.setOutputProperty("indent", "yes");
            idTransform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            idTransform.transform(input, output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{writer, stream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{writer, stream});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importFromFile(File file) throws ImportFailedException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(stream);
            Document document = builder.parse(inputSource);
            Element documentElement = document.getDocumentElement();
            if (!documentElement.getNodeName().contentEquals(TAG_ROOT)) {
                throw new ImportFailedException("The xml file is not valid");
            }
            List<String> alreadyExistingRulesets = DecipheringPreferenceHandler.getAvailableRuleSets();
            NodeList rulesets = document.getElementsByTagName(TAG_RULE_SET);
            Boolean overwriteAll = null;
            for (int i = 0; i < rulesets.getLength(); ++i) {
                Element ruleElement = (Element)rulesets.item(i);
                NodeList nameList = ruleElement.getElementsByTagName(TAG_NAME);
                if (nameList.getLength() == 0) {
                    throw new ImportFailedException("The ruleset's name is missing.");
                }
                String rulesetName = nameList.item(0).getTextContent();
                if (rulesetName.length() == 0) {
                    throw new ImportFailedException("The ruleset name can not be the empty string.");
                }
                NodeList messageTypeListList = ruleElement.getElementsByTagName(TAG_MSG_TYPE_LIST);
                if (messageTypeListList.getLength() == 0) {
                    throw new ImportFailedException("The message type list for the ruleset '" + rulesetName + "' is missing.");
                }
                Element messageTypeListElement = (Element)messageTypeListList.item(0);
                NodeList msgTypeList = messageTypeListElement.getElementsByTagName(TAG_MSG_TYPE);
                Map<String, List<String>> msgTypesMap = DecipheringPreferenceHandler.importMessageTypes(rulesetName, msgTypeList);
                if (!alreadyExistingRulesets.contains(rulesetName)) {
                    alreadyExistingRulesets.add(rulesetName);
                    DecipheringPreferenceHandler.addRuleSet(rulesetName, msgTypesMap);
                    continue;
                }
                if (overwriteAll == null) {
                    MessageDialog msgdialog = new MessageDialog(null, "Ruleset exists", null, "The following ruleset already exists: " + rulesetName + ".\nOverwrite the existing ruleset?", 3, new String[]{"Yes", "No", "Yes to All", "No to All"}, 1);
                    int result = msgdialog.open();
                    if (result == 2) {
                        overwriteAll = true;
                    } else if (result == 3) {
                        overwriteAll = false;
                    }
                    if (result != 2 && result != 0) continue;
                    DecipheringPreferenceHandler.addRuleSet(rulesetName, msgTypesMap);
                    alreadyExistingRulesets.add(rulesetName);
                    continue;
                }
                if (!overwriteAll.booleanValue()) continue;
                DecipheringPreferenceHandler.addRuleSet(rulesetName, msgTypesMap);
                alreadyExistingRulesets.add(rulesetName);
            }
            PreferencesHandler.getInstance().setImportLastDir(file.getParentFile().getPath());
        }
        catch (ParserConfigurationException e) {
            try {
                throw new ImportFailedException("Error while parsing the file: " + e.getMessage());
                catch (SAXException e2) {
                    throw new ImportFailedException("Error while parsing the file: " + e2.getMessage());
                }
                catch (IOException e3) {
                    throw new ImportFailedException("Error while parsing the file: " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)stream);
    }

    private static Map<String, List<String>> importMessageTypes(String rulesetName, NodeList msgTypeList) throws ImportFailedException {
        HashMap<String, List<String>> msgTypesMap = new HashMap<String, List<String>>();
        for (int j = 0; j < msgTypeList.getLength(); ++j) {
            Element currentMsgType = (Element)msgTypeList.item(j);
            NodeList msgTypeNameList = currentMsgType.getElementsByTagName(TAG_NAME);
            if (msgTypeList.getLength() == 0) {
                throw new ImportFailedException("The messagetype's name is missing in the ruleset '" + rulesetName + "'");
            }
            String msgTypeName = msgTypeNameList.item(0).getTextContent();
            if (!MSGTPYE_PATTERN.matcher(msgTypeName).matches()) {
                throw new ImportFailedException("Invalid message type in the ruleset '" + rulesetName + "' in the message type '" + msgTypeName + "'.");
            }
            NodeList ruleListList = currentMsgType.getElementsByTagName(TAG_RULE_LIST);
            if (ruleListList.getLength() == 0) {
                throw new ImportFailedException("The ruleList element is missing in the ruleset '" + rulesetName + "' in the message type '" + msgTypeName + "'.");
            }
            ArrayList<String> rulesParsed = new ArrayList<String>();
            NodeList ruleList = ((Element)ruleListList.item(0)).getElementsByTagName(TAG_RULE);
            for (int k = 0; k < ruleList.getLength(); ++k) {
                String rule = ruleList.item(k).getTextContent();
                if (!RULE_PATTERN.matcher(rule).matches()) {
                    throw new ImportFailedException("Invalid rule in the ruleset '" + rulesetName + "' in the message type '" + msgTypeName + "' in the rule '" + rule + "'.");
                }
                rulesParsed.add(rule);
            }
            msgTypesMap.put(msgTypeName, rulesParsed);
        }
        return msgTypesMap;
    }

    private static Element createXMLElementFromRuleSet(Document document, String ruleSetName) {
        Element ruleSetElement = document.createElement(TAG_RULE_SET);
        Element ruleSetNameElement = document.createElement(TAG_NAME);
        ruleSetNameElement.setTextContent(ruleSetName);
        ruleSetElement.appendChild(ruleSetNameElement);
        Element msgTypeListElement = document.createElement(TAG_MSG_TYPE_LIST);
        ruleSetElement.appendChild(msgTypeListElement);
        List msgTypes = PreferenceUtils.deserializeFromString((String)DecipheringPreferenceHandler.getPreferenceStore().getString(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(ruleSetName)));
        for (String msgType : msgTypes) {
            Element msgTypeElement = document.createElement(TAG_MSG_TYPE);
            msgTypeListElement.appendChild(msgTypeElement);
            Element msgTypeNameElement = document.createElement(TAG_NAME);
            msgTypeNameElement.setTextContent(msgType);
            msgTypeElement.appendChild(msgTypeNameElement);
            List rules = PreferenceUtils.deserializeFromString((String)DecipheringPreferenceHandler.getPreferenceStore().getString(DecipheringPreferenceHandler.getPreferenceKeyForRuleList(ruleSetName, msgType)));
            Element ruleListElement = document.createElement(TAG_RULE_LIST);
            msgTypeElement.appendChild(ruleListElement);
            for (String rule : rules) {
                Element ruleElement = document.createElement(TAG_RULE);
                ruleElement.setTextContent(rule);
                ruleListElement.appendChild(ruleElement);
            }
        }
        return ruleSetElement;
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static class ImportFailedException
    extends Exception {
        public ImportFailedException(String msg) {
            super(msg);
        }
    }
}

