/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class PrivateComponentVariableAccess
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "The \"{0}\" is a Private component in the \"{1}\" module. Access is not recommended from \"{2}\" module.";

    public PrivateComponentVariableAccess() {
        super(CodeSmellType.PRIVATE_COMPONENT_VARIABLE_ACCESS);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Module referedModule;
        Module referingModule;
        if (!(node instanceof Reference)) {
            return;
        }
        Reference reference = (Reference)node;
        if (reference.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        Assignment referedAssignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
        if (referedAssignment == null) {
            return;
        }
        if (!(referedAssignment instanceof Definition)) {
            return;
        }
        Definition definition = (Definition)referedAssignment;
        if (definition.getVisibilityModifier().equals((Object)VisibilityModifier.Private) && !(referingModule = reference.getMyScope().getModuleScope()).equals(referedModule = definition.getMyScope().getModuleScope())) {
            problems.report(reference.getLocation(), MessageFormat.format(ERROR_MESSAGE, reference.getDisplayName(), referedModule.getName(), referingModule.getName()));
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Reference.class);
        return ret;
    }
}

