/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class DoWhile_Statement
extends Statement {
    private static final String BOOLEANEXPECTED = "A value or expression of type boolean was expected";
    private static final String FULLNAMEPART1 = ".expr";
    private static final String FULLNAMEPART2 = ".block";
    private static final String STATEMENT_NAME = "do-while";
    private final Value expression;
    private final StatementBlock statementblock;
    private boolean isInfiniteLoop = false;

    public DoWhile_Statement(Value expression, StatementBlock statementblock) {
        this.expression = expression;
        this.statementblock = statementblock;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
            statementblock.setOwnerIsLoop();
        }
    }

    public StatementBlock getStatementBlock() {
        return this.statementblock;
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_DOWHILE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.expression != null) {
            this.expression.setCodeSection(codeSection);
        }
        if (this.statementblock != null) {
            this.statementblock.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return this.isInfiniteLoop;
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            return this.statementblock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public boolean hasReceivingStatement() {
        if (this.statementblock != null) {
            return this.statementblock.hasReceivingStatement(0);
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isInfiniteLoop = false;
        if (this.statementblock != null) {
            this.statementblock.setMyLaicStmt(null, this);
            this.statementblock.check(timestamp);
        }
        if (this.expression != null) {
            IValue last = this.expression.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temporalType = last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(timestamp)) {
                if (!IType.Type_type.TYPE_BOOL.equals((Object)temporalType)) {
                    last.getLocation().reportSemanticError(BOOLEANEXPECTED);
                    this.expression.setIsErroneous(true);
                } else if (!this.expression.isUnfoldable(timestamp) && ((Boolean_Value)last).getValue() && StatementBlock.ReturnStatus_type.RS_NO.equals((Object)this.hasReturn(timestamp))) {
                    this.isInfiniteLoop = true;
                }
                if (this.expression.getMyGovernor() == null) {
                    this.expression.setMyGovernor(new Boolean_Type());
                }
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            if (this.statementblock != null && reparser.envelopsDamage(this.statementblock.getLocation())) {
                this.statementblock.updateSyntax(reparser, true);
                enveloped = true;
                reparser.updateLocation(this.statementblock.getLocation());
            }
            if (this.expression != null) {
                if (enveloped) {
                    this.expression.updateSyntax(reparser, false);
                    reparser.updateLocation(this.expression.getLocation());
                } else if (reparser.envelopsDamage(this.expression.getLocation())) {
                    this.expression.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.expression.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }

    public Value getExpression() {
        return this.expression;
    }

    public void generateCodeConditional(JavaGenData aData, StringBuilder source) {
        if (this.expression.canGenerateSingleExpression()) {
            if (this.expression.returnsNative()) {
                source.append(MessageFormat.format("if ( !{0} )", this.expression.generateSingleExpression(aData)));
            } else {
                source.append(MessageFormat.format("if ( {0}.not() )", this.expression.generateSingleExpression(aData)));
            }
        } else {
            String tempId = aData.getTemporaryVariableName();
            source.append(MessageFormat.format("boolean {0};\n", tempId));
            ExpressionStruct expression2 = new ExpressionStruct();
            expression2.expression.append(tempId);
            expression2.expression.append(" = ");
            this.expression.generateCodeExpressionMandatory(aData, expression2, false);
            if (!this.expression.returnsNative()) {
                expression2.expression.append(".get_value() ");
            }
            expression2.mergeExpression(source);
            source.append(MessageFormat.format("if ( !{0} )", tempId));
        }
        source.append(" {\n");
        source.append("break;\n");
        source.append("}\n");
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        source.append("for ( ; ; ) { \n");
        this.statementblock.generateCode(aData, source);
        StatementBlock.ReturnStatus_type blockReturnStatus = this.statementblock.hasReturn(CompilationTimeStamp.getBaseTimestamp());
        if (!this.isInfiniteLoop && !StatementBlock.ReturnStatus_type.RS_YES.equals((Object)blockReturnStatus)) {
            this.getLocation().update_location_object(aData, source);
            this.generateCodeConditional(aData, source);
        }
        source.append("}\n");
    }
}

