/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.editors.AnnotationHover;
import org.eclipse.titan.designer.editors.BracketCompletionAutoEditStrategy;
import org.eclipse.titan.designer.editors.ClosingBracketIndentationAutoEditStrategy;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.ContentAssitant;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.IntervallBasedDamagerRepairer;
import org.eclipse.titan.designer.editors.actions.IndentationSupport;
import org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner;
import org.eclipse.titan.designer.editors.ttcn3editor.CommentScanner;
import org.eclipse.titan.designer.editors.ttcn3editor.DoubleClickStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.PartitionScanner;
import org.eclipse.titan.designer.editors.ttcn3editor.QuickAssistProcessor;
import org.eclipse.titan.designer.editors.ttcn3editor.Reconciler;
import org.eclipse.titan.designer.editors.ttcn3editor.ReconcilingStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.SmartIndentAfterNewLineAutoEditStrategy;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcn3editor.TextHover;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ContentAssistProcessor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public final class Configuration
extends TextSourceViewerConfiguration {
    private final ColorManager colorManager;
    private DoubleClickStrategy doubleClickStrategy;
    private final TTCN3Editor editor;
    private Reconciler reconciler;
    private PresentationReconciler presentationReconciler = null;

    public Configuration(ColorManager colorManager, TTCN3Editor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return PartitionScanner.PARTITION_TYPES;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.presentationReconciler == null) {
            this.presentationReconciler = new PresentationReconciler();
            this.presentationReconciler.setDocumentPartitioning("__ttcn3_partitioning");
            IntervallBasedDamagerRepairer dr = new IntervallBasedDamagerRepairer((ITokenScanner)new CommentScanner(this.colorManager));
            this.presentationReconciler.setDamager((IPresentationDamager)dr, "_comment_partition_comment_type");
            this.presentationReconciler.setRepairer((IPresentationRepairer)dr, "_comment_partition_comment_type");
            dr = new IntervallBasedDamagerRepairer(new CodeScanner(this.colorManager));
            this.presentationReconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            this.presentationReconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        }
        return this.presentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssitant assistant = new ContentAssitant();
        ContentAssistProcessor pr = new ContentAssistProcessor(this.editor, "__ttcn3_partitioning");
        assistant.setContentAssistProcessor(pr, "__dftl_partition_content_type");
        ContentAssistProcessor docpr = new ContentAssistProcessor(this.editor, "_comment_partition_comment_type");
        assistant.setContentAssistProcessor(docpr, "_comment_partition_comment_type");
        assistant.setDocumentPartitioning("__ttcn3_partitioning");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableColoredLabels(true);
        return assistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new QuickAssistProcessor());
        return assistant;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new TextHover(sourceViewer, (IEditorPart)this.editor);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler == null) {
            ReconcilingStrategy strategy = new ReconcilingStrategy(this.editor);
            this.reconciler = new Reconciler(strategy);
            this.editor.setReconciler(this.reconciler);
        }
        return this.reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        HeuristicalIntervalDetector detector = new HeuristicalIntervalDetector();
        ClosingBracketIndentationAutoEditStrategy strategy2 = new ClosingBracketIndentationAutoEditStrategy();
        strategy2.setHeuristicIntervalDetector(detector);
        SmartIndentAfterNewLineAutoEditStrategy strategy3 = new SmartIndentAfterNewLineAutoEditStrategy();
        strategy3.setHeuristicIntervalDetector(detector);
        return new IAutoEditStrategy[]{new BracketCompletionAutoEditStrategy(), strategy2, strategy3};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{IndentationSupport.getIndentString()};
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//"};
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }
}

