/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.AstSyntaxHighlightTokens;
import org.eclipse.titan.designer.editors.Stylers;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.PlatformUI;

public final class OutlineStyledLabelProvider
extends DelegatingStyledCellLabelProvider {
    protected void erase(Event event, Object element) {
        if ((event.detail & 2) != 0) {
            event.detail &= 0xFFFFFFFD;
            Rectangle bounds = event.getBounds();
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            RGB rgb = StringConverter.asRGB((String)store.getString("org.eclipse.titan.designer.colorstyledSelectionIncativeBackground"), null);
            Color bgColor = new Color((Device)PlatformUI.getWorkbench().getDisplay(), rgb);
            event.gc.setBackground(bgColor);
            event.gc.fillRectangle(bounds);
        }
        super.erase(event, element);
    }

    protected void measure(Event event, Object element) {
        event.detail &= 0xFFFFFFFD;
        super.measure(event, element);
    }

    protected void paint(Event event, Object element) {
        event.detail &= 0xFFFFFFFD;
        super.paint(event, element);
    }

    public OutlineStyledLabelProvider() {
        super(new DelegatingStyledCellLabelProvider.IStyledLabelProvider(){

            public Image getImage(Object element) {
                String iconName = "titan.gif";
                if (element instanceof IOutlineElement) {
                    IOutlineElement e = (IOutlineElement)element;
                    iconName = e.getOutlineIcon();
                } else if (element instanceof List) {
                    iconName = "imports.gif";
                }
                return ImageCache.getImage(iconName);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public StyledString getStyledText(Object element) {
                Identifier identifier = null;
                if (element instanceof IOutlineElement) {
                    IOutlineElement e = (IOutlineElement)element;
                    String outlineText = e.getOutlineText();
                    if (outlineText.length() != 0) {
                        return this.getStyledText(element, outlineText);
                    }
                    identifier = e.getIdentifier();
                } else if (element instanceof List) {
                    return new StyledString("imports");
                }
                if (identifier == null) {
                    return new StyledString("unknown");
                }
                return this.getStyledText(element, identifier.getDisplayName());
            }

            private StyledString getStyledText(Object element, String text) {
                StyledString styledOutline = new StyledString();
                IPreferencesService prefs = Platform.getPreferencesService();
                IToken token = null;
                String category = null;
                if (element instanceof Definition) {
                    Definition commentable;
                    Definition elemDef = (Definition)element;
                    if (elemDef instanceof ICommentable && (commentable = elemDef).hasDocumentComment() && commentable.getDocumentComment().hasCategory()) {
                        category = commentable.getDocumentComment().getCategory();
                    }
                    Location idloc = elemDef.getIdentifier().getLocation();
                    boolean isSemanticHighlightingEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableOutlineSemanticHighlighting", false, null);
                    if (isSemanticHighlightingEnabled) {
                        token = AstSyntaxHighlightTokens.getSyntaxToken(idloc);
                    }
                    if (elemDef.getMyScope().isClassScope()) {
                        Stylers.ColoredStyler styler = null;
                        switch (elemDef.getVisibilityModifier()) {
                            case Private: {
                                styler = new Stylers.ColoredStyler(Stylers.PrivateColor);
                                break;
                            }
                            case Public: {
                                styler = new Stylers.ColoredStyler(Stylers.PublicColor);
                                break;
                            }
                            default: {
                                styler = new Stylers.ColoredStyler(Stylers.ProtectedColor);
                            }
                        }
                        styledOutline.append(text);
                        styledOutline.append(" \u25fc", (StyledString.Styler)styler);
                    }
                }
                if (styledOutline.length() == 0) {
                    if (token != null) {
                        styledOutline.append(text, (StyledString.Styler)new Stylers.TextAttributeStyler((TextAttribute)token.getData()));
                    } else {
                        styledOutline.append(text);
                    }
                }
                if (category != null && category.length() > 0) {
                    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                    RGB categoryColor = StringConverter.asRGB((String)store.getString("org.eclipse.titan.designer.colororg.eclipse.titan.designeroutlineCategoryColor"), null);
                    styledOutline.append(" [").append(category, (StyledString.Styler)new Stylers.TextAttributeStyler(new TextAttribute(new Color((Device)Display.getCurrent(), categoryColor)))).append(']');
                }
                return styledOutline;
            }
        });
    }
}

