/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Types;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_AbsFunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.editors.CompletionProposal;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.Stylers;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public abstract class ProposalContext {
    public static final int HIGHEST = 16;
    public static final int TYPEANDPREFIX_MATCHES = 8;
    public static final int TYPE_MATCHES = 4;
    public static final int PREFIX_MATCHES = 2;
    public static final int OTHER = 1;
    protected ProjectSourceParser sourceParser;
    protected ProposalContextInfo proposalContextInfo;
    protected boolean doFallback;
    private CompilationTimeStamp timestamp;

    public ProposalContext(ProposalContextInfo proposalContextInfo) {
        this.sourceParser = GlobalParser.getProjectSourceParser(proposalContextInfo.file.getProject());
        this.proposalContextInfo = proposalContextInfo;
        this.timestamp = proposalContextInfo.module.getLastCompilationTimeStamp();
        this.doFallback = true;
    }

    public abstract void getProposals(ProposalCollector var1);

    protected List<Definition> getAvailableDefsByType(IType.Type_type typeType) {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        Map<String, Definition> map = null;
        Scope sc = this.getScope();
        if (sc != null) {
            if (sc instanceof StatementBlock) {
                map = ((StatementBlock)sc).getDefinitionMap();
            } else if (sc instanceof Definitions) {
                map = ((Definitions)sc).getDefinitionMap();
            }
            if (map == null) {
                return definitions;
            }
            for (Map.Entry<String, Definition> e : map.entrySet()) {
                Definition def = e.getValue();
                IType deftype = def.getType(this.timestamp);
                if (deftype == null || deftype.getTypetype() != typeType) continue;
                definitions.add(def);
            }
        }
        List<Module> importedModules = this.proposalContextInfo.module.getImportedModules();
        for (Module importEntry : importedModules) {
            Module moduleScope = importEntry.getModuleScope();
            if (!(moduleScope instanceof TTCN3Module)) continue;
            TTCN3Module module = (TTCN3Module)moduleScope;
            Definitions importDefinitions = module.getDefinitions();
            for (int i = 0; i < importDefinitions.getNofAssignments(); ++i) {
                Definition definitionEntry = importDefinitions.getAssignmentByIndex(i);
                IType entryType = definitionEntry.getType(this.timestamp);
                if (entryType instanceof Referenced_Type) {
                    if (((Referenced_Type)entryType).getTypeRefdLast(this.timestamp).getTypetypeTtcn3() != typeType) continue;
                    definitions.add(definitionEntry);
                    continue;
                }
                if (entryType == null || entryType.getTypetype() != typeType) continue;
                definitions.add(definitionEntry);
            }
        }
        return definitions;
    }

    protected List<Assignment> getAvailableAssignmentsByType(IType.Type_type typeType) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        Scope sc = this.getScope();
        if (sc == null) {
            return assignments;
        }
        Assignments asses = this.proposalContextInfo.scope.getAssignmentsScope();
        int nrAss = asses.getNofAssignments();
        for (int i = 0; i < nrAss; ++i) {
            Assignment ass = asses.getAssignmentByIndex(i);
            IType aType = ass.getType(this.timestamp);
            if (aType == null || ass.getType(this.timestamp).getTypetype() != typeType) continue;
            assignments.add(ass);
        }
        return assignments;
    }

    private Scope getScope() {
        Scope sc;
        if (this.timestamp == null) {
            return null;
        }
        for (sc = this.proposalContextInfo.module.getSmallestEnclosingScope(this.proposalContextInfo.offset - this.getPrefix().length()); sc != null && !(sc instanceof Definitions) && !(sc instanceof StatementBlock); sc = sc.getParentScope()) {
        }
        return sc;
    }

    public boolean doFallback() {
        return this.doFallback;
    }

    protected String getPrefix() {
        if (this.proposalContextInfo.context != null && !this.proposalContextInfo.context.isEmpty()) {
            char c;
            StringBuilder sb = new StringBuilder(this.proposalContextInfo.context.length());
            for (int i = this.proposalContextInfo.context.length() - 1; i >= 0 && this.isPrefixChar(c = this.proposalContextInfo.context.charAt(i)); --i) {
                sb.insert(0, c);
            }
            return sb.toString();
        }
        return "";
    }

    protected boolean isPrefixChar(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '_' || c == '@';
    }

    protected void addItemsByType(IType type, ProposalCollector propCollector, String prefixIn, List<String> excludeNames) {
        this.addItemsByType(type, type.getTypetype(), propCollector, prefixIn, excludeNames);
    }

    protected void addItemsByType(IType type, IType.Type_type ttype, ProposalCollector propCollector, String prefixIn, List<String> excludeNames) {
        String prefix = prefixIn != null ? prefixIn : "";
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        switch (ttype) {
            case TYPE_TTCN3_ENUMERATED: {
                TTCN3_Enumerated_Type etype = (TTCN3_Enumerated_Type)type;
                for (EnumItem enumItem : etype.getEnumItems()) {
                    String enumString = enumItem.getId().getDisplayName();
                    Ttcn3HoverContent enumItemHover = etype.getItemHoverContent(enumItem.getId());
                    CompletionProposal enumProposal = new CompletionProposal(enumString, replacementOffset, replacementLength, enumString.length(), ImageCache.getImageByType(ttype), new StyledString(enumString, (StyledString.Styler)new Stylers.ItalicStyler()), null, enumItemHover, enumString.toLowerCase().startsWith(prefix.toLowerCase()) ? 18 : 4);
                    propCollector.addProposal(enumProposal);
                }
                List<Definition> enumDefList = this.getAvailableDefsByType(ttype);
                for (Definition def : enumDefList) {
                    Referenced_Type enumref;
                    if (!(def.getType(this.timestamp) instanceof Referenced_Type) || !((enumref = (Referenced_Type)def.getType(this.timestamp)).getTypeRefdLast(this.timestamp) instanceof TTCN3_Enumerated_Type)) continue;
                    String ename = def.getIdentifier().getDisplayName();
                    Ttcn3HoverContent enumHover = null;
                    if (def instanceof ICommentable) {
                        enumHover = def.getHoverContent(null);
                    }
                    CompletionProposal enumProposal2 = new CompletionProposal(ename, replacementOffset, replacementLength, ename.length(), ImageCache.getImageByType(ttype), new StyledString(ename), null, enumHover, ename.toLowerCase().startsWith(prefix.toLowerCase()) ? 6 : 4);
                    propCollector.addProposal(enumProposal2);
                }
                break;
            }
            case TYPE_TTCN3_CHOICE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_TTCN3_SET: {
                TTCN3_Set_Seq_Choice_BaseType tTCN3_Set_Seq_Choice_BaseType = (TTCN3_Set_Seq_Choice_BaseType)type;
                for (int i = 0; i < tTCN3_Set_Seq_Choice_BaseType.getNofComponents(); ++i) {
                    String name = tTCN3_Set_Seq_Choice_BaseType.getComponentIdentifierByIndex(i).getName();
                    ProposalContext.addProposal(name, name, type.getTypetype(), propCollector, replacementOffset, replacementLength, prefix);
                }
                break;
            }
            case TYPE_BOOL: {
                ProposalContext.addProposal("true", ttype, propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addProposal("false", ttype, propCollector, replacementOffset, replacementLength, prefix);
            }
            case TYPE_BITSTRING: 
            case TYPE_CHARSTRING: 
            case TYPE_HEXSTRING: 
            case TYPE_INTEGER: 
            case TYPE_OCTETSTRING: 
            case TYPE_REAL: 
            case TYPE_UCHARSTRING: 
            case TYPE_TESTCASE: 
            case TYPE_CLASS: {
                this.addItems(ttype, propCollector, excludeNames, replacementOffset, replacementLength, prefix);
                break;
            }
            case TYPE_VERDICT: {
                ProposalContext.addProposal("none", ttype, propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addProposal("pass", ttype, propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addProposal("inconc", ttype, propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addProposal("fail", ttype, propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addProposal("error", ttype, propCollector, replacementOffset, replacementLength, prefix);
                this.addItems(ttype, propCollector, excludeNames, replacementOffset, replacementLength, prefix);
                break;
            }
            case TYPE_COMPONENT: {
                for (String proposalName : Component_Type.SIMPLE_COMPONENT_PROPOSALS) {
                    ProposalContext.addProposal(proposalName, ttype, propCollector, replacementOffset, replacementLength, prefix);
                }
                ProposalContext.addTemplateProposal("create", "create( ${name} );", "create( name )", "", propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addTemplateProposal("create", "create( ${name} ) alive;", "create( name ) alive", "", propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addTemplateProposal("create", "create( ${name}, ${location} );", "create( name, location )", "", propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addTemplateProposal("create", "create( ${name}, ${location} ) alive;", "create( name, location ) alive", "", propCollector, replacementOffset, replacementLength, prefix);
                ProposalContext.addTemplateProposal("start", "start( ${functionName} );", "start( function name )", "", propCollector, replacementOffset, replacementLength, prefix);
                this.addItems(ttype, propCollector, excludeNames, replacementOffset, replacementLength, prefix);
                break;
            }
            case TYPE_PORT: {
                this.addItems(ttype, propCollector, excludeNames, replacementOffset, replacementLength, prefix);
                break;
            }
        }
        propCollector.sortAll();
    }

    protected void addClassProposals(Class_Type classType, ProposalCollector propCollector, int replacementOffset, int replacementLength, String prefix) {
        Map<String, Def_AbsFunction> absFunctions = classType.getAbstractFunctions();
        for (Def_AbsFunction absFunction : absFunctions.values()) {
            String absFunctionName = absFunction.getIdentifier().getTtcnName();
            FormalParameterList fpl = absFunction.getFormalParameterList();
            ProposalContext.addFunctionProposal(absFunctionName, fpl, propCollector, replacementOffset, replacementLength, prefix);
        }
        Definitions members = classType.getMembers();
        Map<String, Definition> membersMap = members.getDefinitionMap();
        for (Definition member : membersMap.values()) {
            String memberName = member.getIdentifier().getTtcnName();
            if (member instanceof Def_Var) {
                ProposalContext.addProposal(memberName, member.getType(this.timestamp).getTypetype(), propCollector, replacementOffset, replacementLength, prefix);
                continue;
            }
            if (!(member instanceof Def_Function)) continue;
            Def_Function f = (Def_Function)member;
            FormalParameterList fpl = f.getFormalParameterList();
            ProposalContext.addFunctionProposal(memberName, fpl, propCollector, replacementOffset, replacementLength, prefix);
        }
        Class_Type baseClassType = classType.getBaseClass();
        if (baseClassType != null) {
            this.addClassProposals(baseClassType, propCollector, replacementOffset, replacementLength, prefix);
        }
        Types traitClasses = classType.getBaseTraits();
        for (int i = 0; i < traitClasses.getNofTypes(); ++i) {
            IType type = traitClasses.getType(i);
            if (type instanceof Referenced_Type) {
                type = type.getTypeRefdLast(this.timestamp);
            }
            if (!(type instanceof Class_Type)) continue;
            Class_Type traitClassType = (Class_Type)type;
            this.addClassProposals(traitClassType, propCollector, replacementOffset, replacementLength, prefix);
        }
    }

    private static void addFunctionProposal(String functionName, FormalParameterList fpl, ProposalCollector propCollector, int replacementOffset, int replacementLength, String prefix) {
        if (fpl == null || fpl.getNofParameters() == 0) {
            ProposalContext.addProposal(functionName + "()", IType.Type_type.TYPE_FUNCTION, propCollector, replacementOffset, replacementLength, prefix);
        } else {
            StringBuilder candidateString = new StringBuilder(functionName);
            candidateString.append('(');
            StringBuilder visibleString = new StringBuilder(functionName);
            visibleString.append('(');
            for (int i = 0; i < fpl.getNofParameters(); ++i) {
                FormalParameter fp = fpl.getParameterByIndex(i);
                String parameterName = fp.getIdentifier().getTtcnName();
                if (i > 0) {
                    candidateString.append(',');
                    visibleString.append(',');
                }
                candidateString.append(" ${");
                candidateString.append(parameterName);
                candidateString.append('}');
                visibleString.append(' ');
                visibleString.append(parameterName);
            }
            candidateString.append(" )");
            visibleString.append(" )");
            ProposalContext.addTemplateProposal(functionName, candidateString.toString(), visibleString.toString(), "", propCollector, replacementOffset, replacementLength, prefix);
        }
    }

    protected static void addProposal(String proposalString, IType.Type_type ttype, ProposalCollector propCollector, int replacementOffset, int replacementLength, String prefix) {
        ProposalContext.addProposal(proposalString, proposalString, ttype, propCollector, replacementOffset, replacementLength, prefix);
    }

    protected static void addProposal(String candidateString, String visibleString, IType.Type_type ttype, ProposalCollector propCollector, int replacementOffset, int replacementLength, String prefix) {
        CompletionProposal proposal = new CompletionProposal(candidateString, replacementOffset, replacementLength, candidateString.length(), ImageCache.getImageByType(ttype), new StyledString(visibleString, (StyledString.Styler)new Stylers.ItalicStyler()), null, null, candidateString.toLowerCase().startsWith(prefix.toLowerCase()) ? 18 : 4);
        propCollector.addProposal(proposal);
    }

    private void addItems(IType.Type_type ttype, ProposalCollector propCollector, List<String> excludeNames, int replacementOffset, int replacementLength, String prefix) {
        Ttcn3HoverContent doc;
        List<Definition> defList = this.getAvailableDefsByType(ttype);
        for (Definition a : defList) {
            String name = a.getIdentifier().getDisplayName();
            if (excludeNames != null && excludeNames.contains(name)) continue;
            doc = a.getHoverContent(null);
            CompletionProposal proposal = new CompletionProposal(name, replacementOffset, replacementLength, name.length(), ImageCache.getImageByType(ttype), new StyledString(name), null, doc, name.toLowerCase().startsWith(prefix.toLowerCase()) ? 6 : 4);
            propCollector.addProposal(proposal);
        }
        List<Assignment> aList = this.getAvailableAssignmentsByType(ttype);
        block4: for (Assignment a : aList) {
            switch (a.getAssignmentType()) {
                case A_TYPE: {
                    continue block4;
                }
            }
            doc = null;
            if (a instanceof ICommentable) {
                ICommentable d = (ICommentable)((Object)a);
                doc = d.getHoverContent(null);
            }
            String name = a.getIdentifier().getDisplayName();
            CompletionProposal proposal = new CompletionProposal(name, replacementOffset, replacementLength, name.length(), ImageCache.getImageByType(ttype), new StyledString(name), null, doc, name.toLowerCase().startsWith(prefix.toLowerCase()) ? 6 : 4);
            propCollector.addProposal(proposal);
        }
    }

    protected static void addTemplateProposal(String prefixString, String candidateString, String visibleString, String description, ProposalCollector propCollector, int replacementOffset, int replacementLength, String prefix) {
        try {
            propCollector.addTemplateProposal(prefixString, new Template(visibleString, description, propCollector.getContextIdentifier(), candidateString, false), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    protected IType getType(String name) {
        if (this.proposalContextInfo.scope == null) {
            return null;
        }
        Reference reference = TTCN3ReferenceAnalyzer.parseForCompletion(this.proposalContextInfo.file, name);
        if (reference == null) {
            return null;
        }
        CompilationTimeStamp timestamp = this.proposalContextInfo.module.getLastCompilationTimeStamp();
        Assignment assignment = this.proposalContextInfo.scope.getAssBySRef(timestamp, reference);
        if (assignment == null) {
            return null;
        }
        IType type = assignment.getType(timestamp);
        return type;
    }
}

