/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.titan.runtime.core.Module_List;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TtcnError;

public final class Runtime_Parallel_main {
    private Runtime_Parallel_main() {
    }

    public static int parallelMain(String[] argv) {
        int returnValue = 0;
        TitanComponent.self.set(new TitanComponent(1));
        TTCN_Runtime.set_state(TTCN_Runtime.executorStateEnum.SINGLE_CONTROLPART);
        if (argv.length != 2) {
            System.out.println("For now only 2 arguments can be passed the host address and port number");
            return -1;
        }
        String local_addr = null;
        String MC_host = argv[0];
        try {
            int MC_port = Integer.parseInt(argv[1]);
            if (MC_port < 0 || MC_port > 65536) {
                throw new NumberFormatException();
            }
            TTCN_Snapshot.initialize();
            TTCN_Logger.initialize_logger();
            TTCN_Logger.set_start_time();
            System.out.println("TTCN-3 Host Controller (parallel mode)");
            try {
                Module_List.pre_init_modules();
                returnValue = TTCN_Runtime.hc_main(local_addr, MC_host, MC_port);
            }
            catch (TtcnError error) {
                returnValue = -1;
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Fatal error. Invalid MC port: " + argv[1]);
            returnValue = -1;
        }
        catch (Throwable e) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.ERROR_UNQUALIFIED, "Fatal error. Aborting execution.");
            StringWriter error = new StringWriter();
            e.printStackTrace(new PrintWriter(error));
            TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
            TTCN_Logger.log_event_str("Dynamic test case error: ");
            TTCN_Logger.log_event_str(error.toString());
            TTCN_Logger.end_event();
            returnValue = -1;
        }
        TitanComponent.clear_component_names();
        TTCN_EncDec.clear_error();
        TTCN_Logger.terminate_logger();
        TTCN_Snapshot.terminate();
        return returnValue;
    }
}

