/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.definitions.SpecialASN1Module;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Setting
extends ASTNode
implements ISetting {
    protected boolean isErroneous = false;
    private String genName;
    protected CompilationTimeStamp lastTimeChecked;
    protected Location location = NULL_Location.INSTANCE;

    @Override
    public final boolean getIsErroneous(CompilationTimeStamp timestamp) {
        return this.isErroneous;
    }

    @Override
    public final void setIsErroneous(boolean isErroneous) {
        this.isErroneous = isErroneous;
    }

    @Override
    public abstract ISetting.Setting_type getSettingtype();

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public final boolean isAsn() {
        if (this.myScope == null) {
            return false;
        }
        return Module.module_type.ASN_MODULE.equals((Object)this.myScope.getModuleScope().getModuletype());
    }

    @Override
    public void setGenName(String genName) {
        this.genName = genName;
    }

    @Override
    public void setGenName(String prefix, String suffix) {
        if (prefix.length() == 0 || suffix.length() == 0) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while seting the generated name of setting `" + this.getFullName() + "''"));
            this.genName = "<FATAL ERROR>";
            return;
        }
        this.genName = !(prefix.endsWith("_") && !prefix.endsWith("__") || suffix.startsWith("_") && !suffix.startsWith("__")) ? prefix + "_" + suffix : prefix + suffix;
    }

    public String getGenNameOwn() {
        if (this.genName == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous setting `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.genName;
    }

    @Override
    public String getGenNameOwn(JavaGenData aData) {
        Module generatedModule;
        if (this.myScope == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous setting `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        StringBuilder returnValue = new StringBuilder();
        Module myModule = this.myScope.getModuleScopeGen();
        if (!myModule.equals(generatedModule = aData.getModuleScope()) && !SpecialASN1Module.isSpecAsss(myModule)) {
            returnValue.append(myModule.getName()).append('.');
            if (myModule.getProject() != generatedModule.getProject()) {
                aData.addInterModuleImport(myModule.getName());
            }
        }
        returnValue.append(this.getGenNameOwn());
        return returnValue.toString();
    }
}

