/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SimpleTypeMappingTarget
extends TypeMappingTarget {
    private static final String FULLNAMEPART1 = ".<target_type>";
    private final Type targetType;

    public SimpleTypeMappingTarget(Type targetType) {
        this.targetType = targetType;
        if (targetType != null) {
            targetType.setFullNameParent(this);
        }
    }

    @Override
    public TypeMappingTarget.TypeMapping_type getTypeMappingType() {
        return TypeMappingTarget.TypeMapping_type.SIMPLE;
    }

    @Override
    public String getMappingName() {
        return "simple";
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.targetType == child) {
            return builder.append(FULLNAMEPART1);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.targetType != null) {
            this.targetType.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Type sourceType, Port_Type portType, boolean legacy, boolean incoming) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (sourceType != null && !sourceType.isIdentical(timestamp, this.targetType)) {
            this.targetType.getLocation().reportSemanticError(MessageFormat.format("The source and target types must be the same: `{0}'' was expected instead of `{1}''", sourceType.getTypename(), this.targetType.getTypename()));
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.targetType != null) {
            this.targetType.updateSyntax(reparser, false);
            reparser.updateLocation(this.targetType.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targetType != null) {
            this.targetType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.targetType == null || this.targetType.accept(v);
    }

    @Override
    public PortGenerator.MessageTypeMappingTarget fillTypeMappingTarget(JavaGenData aData, StringBuilder source, IType sourceType, AtomicBoolean hasSliding) {
        hasSliding.set(false);
        if (this.targetType == null) {
            return new PortGenerator.MessageTypeMappingTarget(null, null);
        }
        return new PortGenerator.MessageTypeMappingTarget(this.targetType.getGenNameValue(aData, source), this.targetType.getTypename());
    }
}

