/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class RangedArrayDimension
extends ArrayDimension {
    private static final String FULLNAMEPART1 = ".<lower>";
    private static final String FULLNAMEPART2 = ".<upper>";
    private static final String OPERANDERROR1 = "An integer value was expected as lower boundary";
    private static final String OPERANDERROR2 = "An integer value was expected as upper boundary";
    private static final String OPERANDERROR3 = "The lower boundary is greater than the upper boundary";
    private static final String OPERANDERROR4 = "Using a large integer value ({0}) as the lower boundary of an array dimension is not supported";
    private static final String OPERANDERROR5 = "Using a large integer value ({0}) as the upper boundary of an array dimension is not supported";
    private final Value lower;
    private final Value upper;
    private long size;
    private long offset;

    public RangedArrayDimension(Value lower, Value upper) {
        this.lower = lower;
        this.upper = upper;
        this.size = 0L;
        this.offset = 0L;
        if (lower != null) {
            lower.setFullNameParent(this);
        }
        if (upper != null) {
            upper.setFullNameParent(this);
        }
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.lower != null) {
            this.lower.setMyScope(scope);
        }
        if (this.upper != null) {
            this.upper.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.lower == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.upper == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public long getOffset() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.offset;
    }

    @Override
    public long getSize() {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.size;
    }

    @Override
    public String createStringRepresentation() {
        this.check(CompilationTimeStamp.getBaseTimestamp());
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (this.lower == null) {
            builder.append("<erroneous>");
        } else {
            builder.append(this.lower.createStringRepresentation());
        }
        builder.append(" .. ");
        if (this.upper == null) {
            builder.append("<erroneous>");
        } else {
            builder.append(this.upper.createStringRepresentation());
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.setIsErroneous(false);
        if (this.lower == null || this.upper == null) {
            return;
        }
        IValue lowerLast = this.lower.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_CONSTANT, null);
        if (lowerLast == null || lowerLast.getIsErroneous(timestamp)) {
            return;
        }
        long lowerLimit = 0L;
        switch (lowerLast.getValuetype()) {
            case INTEGER_VALUE: {
                if (lowerLast.isUnfoldable(timestamp)) {
                    this.lower.getLocation().reportSemanticError(OPERANDERROR1);
                    this.setIsErroneous(true);
                    break;
                }
                if (!IValue.Value_type.INTEGER_VALUE.equals((Object)lowerLast.getValuetype())) break;
                if (!((Integer_Value)lowerLast).isNative()) {
                    this.lower.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR4, ((Integer_Value)lowerLast).getValueValue()));
                    this.setIsErroneous(true);
                    break;
                }
                lowerLimit = ((Integer_Value)lowerLast).getValue();
                break;
            }
            default: {
                this.lower.getLocation().reportSemanticError(OPERANDERROR1);
                this.lower.setIsErroneous(true);
            }
        }
        IValue upperLast = this.upper.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_CONSTANT, null);
        if (upperLast == null || upperLast.getIsErroneous(timestamp)) {
            return;
        }
        long upperLimit = 0L;
        switch (upperLast.getValuetype()) {
            case INTEGER_VALUE: {
                if (upperLast.isUnfoldable(timestamp)) {
                    this.upper.getLocation().reportSemanticError(OPERANDERROR2);
                    this.setIsErroneous(true);
                    break;
                }
                if (!IValue.Value_type.INTEGER_VALUE.equals((Object)upperLast.getValuetype())) break;
                if (!((Integer_Value)upperLast).isNative()) {
                    this.upper.getLocation().reportSemanticError(MessageFormat.format(OPERANDERROR5, ((Integer_Value)upperLast).getValueValue()));
                    this.setIsErroneous(true);
                    break;
                }
                upperLimit = ((Integer_Value)upperLast).getValue();
                break;
            }
            default: {
                this.upper.getLocation().reportSemanticError(OPERANDERROR2);
                this.upper.setIsErroneous(true);
            }
        }
        if (!(this.getIsErroneous(timestamp) || this.lower.getIsErroneous(timestamp) || this.upper.getIsErroneous(timestamp))) {
            if (upperLimit < lowerLimit) {
                this.getLocation().reportSemanticError(OPERANDERROR3);
                this.setIsErroneous(true);
            } else {
                this.size = upperLimit - lowerLimit + 1L;
                this.offset = lowerLimit;
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lower != null) {
            this.lower.updateSyntax(reparser, false);
            reparser.updateLocation(this.lower.getLocation());
        }
        if (this.upper != null) {
            this.upper.updateSyntax(reparser, false);
            reparser.updateLocation(this.upper.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.lower != null) {
            this.lower.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.upper != null) {
            this.upper.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.lower != null && !this.lower.accept(v)) {
            return false;
        }
        return this.upper == null || this.upper.accept(v);
    }

    @Override
    public String getValueType(JavaGenData aData, StringBuilder source, IType elementType, Scope scope) {
        if (this.isErroneous) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for `" + this.getFullName() + "''"));
            return "FATAL ERROR in RangedArrayDImension:getValueType";
        }
        aData.addBuiltinTypeImport("TitanValue_Array");
        return MessageFormat.format("TitanValue_Array<{0}>", elementType.getGenNameValue(aData, source));
    }

    @Override
    public String getTemplateType(JavaGenData aData, StringBuilder source, IType elementType, Scope scope) {
        if (this.isErroneous) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for `" + this.getFullName() + "''"));
            return "FATAL ERROR in RangedArrayDImension:getTemplateType";
        }
        aData.addBuiltinTypeImport("TitanTemplate_Array");
        return MessageFormat.format("TitanTemplate_Array<{0}, {1}>", elementType.getGenNameValue(aData, source), elementType.getGenNameTemplate(aData, source));
    }
}

