/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.actions.ExternalTitanAction;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.properties.data.TITANFlagsOptionsData;

public final class CheckSemantic
extends ExternalTitanAction {
    private static final String JOB_TITLE = "Semantic check";

    public void run(IAction action) {
        this.doCheckSemantics();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doCheckSemantics();
        return null;
    }

    private void doCheckSemantics() {
        if (!TITANInstallationValidator.check(true)) {
            return;
        }
        if (!LicenseValidator.check()) {
            return;
        }
        this.processSelection();
        if (this.files == null || this.files.isEmpty()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Semantic check ...failed", (String)"No valid files were selected.");
            return;
        }
        this.reportOnTheFlyOutdating();
        TITANJob titanJob = new TITANJob(JOB_TITLE, this.files, this.workingDir, this.project);
        titanJob.setPriority(50);
        titanJob.setUser(true);
        titanJob.setRule((ISchedulingRule)this.project);
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        ArrayList<String> command = new ArrayList<String>();
        StringBuilder output = new StringBuilder();
        command.add(PathConverter.convert((String)this.getCompilerPath().toOSString(), (boolean)reportDebugInformation, (StringBuilder)output));
        TITANDebugConsole.println(output);
        boolean useRuntime2 = false;
        try {
            if ("true".equals(this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime")))) {
                useRuntime2 = true;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while reading persistent property", (Throwable)e);
        }
        if (this.singleSelectedProject == null) {
            TITANConsole.println("Using the general preferences to do the external semantic check");
            command.add("-s" + this.getTITANActionFlags());
            IProject proj = this.getSelectionProject();
            if (proj != null) {
                String flags = TITANFlagsOptionsData.getTITANFlags(proj, useRuntime2);
                command.add(" " + flags);
            }
        } else {
            TITANConsole.println("Using the project properties to do the external semantic check");
            String flags = TITANFlagsOptionsData.getTITANFlags(this.singleSelectedProject, useRuntime2);
            command.add("-s " + (String)flags);
        }
        for (String filePath : this.files.keySet()) {
            command.add('\'' + filePath + '\'');
        }
        titanJob.addCommand(command, JOB_TITLE);
        titanJob.removeCompilerMarkers();
        String markersAfterCompiler = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.ontheflyMarkersAfterCompiler", "Are removed", null);
        if ("Are removed".equals(markersAfterCompiler)) {
            titanJob.removeOnTheFlyMarkers();
        }
        titanJob.schedule();
        if (this.javaProjects.size() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(JOB_TITLE).append(" was not executed for the selected item(s) from the following project(s):\n");
            for (String name : this.javaProjects) {
                sb.append(name).append('\n');
            }
            this.javaProjects.clear();
            MessageDialog.openInformation(null, (String)JOB_TITLE, (String)sb.toString());
        }
    }

    @Override
    protected String getExtensionPattern() {
        return "^(ttcn|ttcn3|ttcnpp|asn|asn1|cfg)$";
    }
}

