/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.OutlineViewSorter;
import org.eclipse.titan.designer.editors.asn1editor.ASN1Editor;
import org.eclipse.titan.designer.editors.asn1editor.OutlineContentProvider;
import org.eclipse.titan.designer.editors.asn1editor.OutlineLabelProvider;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public final class OutlinePage
extends ContentOutlinePage {
    private final ASN1Editor editor;
    private TreeViewer viewer;

    public OutlinePage(ASN1Editor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        OutlineViewSorter comperator = new OutlineViewSorter();
        comperator.setSortByName(store.getBoolean("org.eclipse.titan.designer.outline.sortAlphabetically"));
        this.viewer.setComparator((ViewerComparator)comperator);
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)this.getModule());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        IActionBars bars = this.getSite().getActionBars();
        Action sortToggler = new Action("Sort"){

            public void run() {
                ViewerComparator comperator = OutlinePage.this.viewer.getComparator();
                if (comperator == null) {
                    comperator = new OutlineViewSorter();
                    OutlinePage.this.viewer.setComparator(comperator);
                }
                if (comperator instanceof OutlineViewSorter) {
                    store.setValue("org.eclipse.titan.designer.outline.sortAlphabetically", this.isChecked());
                    ((OutlineViewSorter)comperator).setSortByName(this.isChecked());
                }
                OutlinePage.this.viewer.refresh();
            }
        };
        sortToggler.setImageDescriptor(ImageCache.getImageDescriptor("sort_alphabetically.gif"));
        sortToggler.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.sortAlphabetically"));
        bars.getToolBarManager().add((IAction)sortToggler);
    }

    public void update() {
        Control control = this.getControl();
        if (!control.isDisposed()) {
            control.setRedraw(false);
            this.getTreeViewer().setInput((Object)this.getModule());
            control.setRedraw(true);
        }
    }

    public void refresh() {
        Control control = this.getControl();
        if (control.isDisposed()) {
            return;
        }
        control.setRedraw(false);
        Module module = this.getModule();
        if (this.getTreeViewer().getInput() == module) {
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandToLevel(2);
        } else {
            this.getTreeViewer().setInput((Object)this.getModule());
        }
        control.setRedraw(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        Identifier identifier = null;
        if (selectedElement instanceof IOutlineElement) {
            identifier = ((IOutlineElement)selectedElement).getIdentifier();
        }
        if (identifier == null || identifier.getLocation() == null) {
            return;
        }
        Location location = identifier.getLocation();
        this.editor.selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
    }

    private Module getModule() {
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module module = sourceParser.containedModule(file);
        if (module == null || module.getLastCompilationTimeStamp() == null) {
            return null;
        }
        return module;
    }
}

