/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.Arrays;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.editors.CompletionProposal;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.graphics.ImageCache;

public class DocumentCommentContext
extends ProposalContext {
    private static final String[] HTML_TAGS = new String[]{"<b>", "<code>", "<em>", "<li>", "<ol>", "<p>", "<pre>", "<strong>", "<ul>"};
    private static final String LINE_BREAK = "<br>";

    public DocumentCommentContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        String prefix = this.getPrefix();
        if (!prefix.isEmpty()) {
            if (prefix.startsWith("<")) {
                this.addHtmlTagProposals(propCollector, prefix);
            } else if (prefix.startsWith("@")) {
                this.addDocCommentTagProposals(propCollector, prefix);
            } else {
                String tag = this.getTagBeforePrefix();
                if (Arrays.asList(ICommentable.DOC_COMMENT_TAGS).contains(tag)) {
                    this.addDocCommentTagParamProposals(propCollector, tag, prefix);
                }
            }
        } else {
            String tag = this.getTagBeforeSpace();
            if (Arrays.asList(ICommentable.DOC_COMMENT_TAGS).contains(tag)) {
                this.addDocCommentTagParamProposals(propCollector, tag, "");
            }
        }
    }

    private String getTagBeforeSpace() {
        if (this.proposalContextInfo.context != null && !this.proposalContextInfo.context.isEmpty()) {
            char c;
            char c2;
            int i;
            for (i = this.proposalContextInfo.context.length() - 1; i >= 0 && (c2 = this.proposalContextInfo.context.charAt(i)) == ' '; --i) {
            }
            StringBuilder sb = new StringBuilder(this.proposalContextInfo.context.length());
            while (i >= 0 && this.isPrefixChar(c = this.proposalContextInfo.context.charAt(i))) {
                sb.insert(0, c);
                --i;
            }
            return sb.toString();
        }
        return "";
    }

    private String getTagBeforePrefix() {
        if (this.proposalContextInfo.context != null && !this.proposalContextInfo.context.isEmpty()) {
            char c;
            char c2;
            int i;
            for (i = this.proposalContextInfo.context.length() - 1; i >= 0 && this.isPrefixChar(c2 = this.proposalContextInfo.context.charAt(i)); --i) {
            }
            while (i >= 0 && (c2 = this.proposalContextInfo.context.charAt(i)) == ' ') {
                --i;
            }
            StringBuilder sb = new StringBuilder(this.proposalContextInfo.context.length());
            while (i >= 0 && this.isPrefixChar(c = this.proposalContextInfo.context.charAt(i))) {
                sb.insert(0, c);
                --i;
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    protected boolean isPrefixChar(char c) {
        return Character.isAlphabetic(c) || Character.isDigit(c) || c == '_' || c == '@' || c == '<';
    }

    private void addDocCommentTagProposals(ProposalCollector propCollector, String prefix) {
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        for (String tag : ICommentable.DOC_COMMENT_TAGS) {
            CompletionProposal proposal = new CompletionProposal(tag, replacementOffset, replacementLength, tag.length(), ImageCache.getImage(this.proposalContextInfo.module.getOutlineIcon()), new StyledString(tag), null, new Ttcn3HoverContent(tag + " tag"), tag.startsWith(prefix) ? 2 : 1);
            propCollector.addProposal(proposal);
        }
        propCollector.sortAll();
    }

    private void addDocCommentTagParamProposals(ProposalCollector propCollector, String tag, String prefix) {
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        switch (tag) {
            case "@status": {
                String deprecatedStr = "deprecated";
                CompletionProposal proposal = new CompletionProposal("deprecated", replacementOffset, replacementLength, "deprecated".length(), ImageCache.getImage(this.proposalContextInfo.module.getOutlineIcon()), new StyledString("deprecated"), null, new Ttcn3HoverContent(tag + " " + "deprecated"), "deprecated".startsWith(prefix) ? 2 : 1);
                propCollector.addProposal(proposal);
            }
        }
        propCollector.sortAll();
    }

    private void addHtmlTagProposals(ProposalCollector propCollector, String prefix) {
        int replacementOffset = this.proposalContextInfo.offset - prefix.length();
        int replacementLength = prefix.length();
        for (String tag : HTML_TAGS) {
            CompletionProposal proposal = new CompletionProposal(tag + this.getHtmlClosingTag(tag), replacementOffset, replacementLength, tag.length(), ImageCache.getImage(this.proposalContextInfo.module.getOutlineIcon()), new StyledString(tag), null, new Ttcn3HoverContent(tag + " html tag"), tag.startsWith(prefix) ? 2 : 1);
            propCollector.addProposal(proposal);
        }
        CompletionProposal proposal = new CompletionProposal(LINE_BREAK, replacementOffset, replacementLength, LINE_BREAK.length(), ImageCache.getImage(this.proposalContextInfo.module.getOutlineIcon()), new StyledString(LINE_BREAK), null, new Ttcn3HoverContent("<br>html tag"), LINE_BREAK.startsWith(prefix) ? 2 : 1);
        propCollector.addProposal(proposal);
        propCollector.sortAll();
    }

    private String getHtmlClosingTag(String tag) {
        StringBuilder sb = new StringBuilder(tag);
        return sb.insert(1, '/').toString();
    }
}

