/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.models.TimeInterval;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.LogFileHandler;

public class MSCFilterDialog
extends Dialog {
    private FilterPattern filterPattern;
    private Tree checkTree;
    private Button allButton;
    private Button noneButton;
    private Button inclusiveButton;
    private Button isCaseSensitiveButton;
    private Button isRegularExpressionButton;
    private Button sourceInfoButton;
    private Button messageButton;
    private Text filterStringBox;
    private Text startTimestamp;
    private Text endTimestamp;
    private boolean changed = false;
    private CLabel invalidStartTimestamp;
    private CLabel invalidEndTimestamp;
    private boolean isFilterStringValid = true;
    private boolean isStartTimeStampValid = true;
    private boolean isEndTimeStampValid = true;
    private final Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            MSCFilterDialog.this.changed = true;
        }
    };
    private final Listener filterStringChanged = new Listener(){

        public void handleEvent(Event event) {
            if (!MSCFilterDialog.this.isRegularExpressionButton.getSelection()) {
                MSCFilterDialog.this.filterStringBox.setBackground(null);
                MSCFilterDialog.this.filterStringBox.setToolTipText(null);
                MSCFilterDialog.this.isFilterStringValid = true;
                MSCFilterDialog.this.validate();
                return;
            }
            try {
                Pattern.compile(MSCFilterDialog.this.filterStringBox.getText());
                MSCFilterDialog.this.filterStringBox.setBackground(null);
                MSCFilterDialog.this.filterStringBox.setToolTipText(null);
                MSCFilterDialog.this.isFilterStringValid = true;
            }
            catch (PatternSyntaxException e) {
                MSCFilterDialog.this.filterStringBox.setBackground(MSCFilterDialog.this.getShell().getDisplay().getSystemColor(3));
                MSCFilterDialog.this.filterStringBox.setToolTipText("Invalid regular expression!");
                MSCFilterDialog.this.isFilterStringValid = false;
            }
            MSCFilterDialog.this.validate();
        }
    };
    private final Listener startTimeStampChanged = new Listener(){

        public void handleEvent(Event event) {
            if (MSCFilterDialog.this.startTimestamp.getText().length() > 0 && LogFileHandler.validateTimeStamp(MSCFilterDialog.this.startTimestamp.getText(), MSCFilterDialog.this.filterPattern.getTimeInterval().getTimeStampFormat()) == null) {
                MSCFilterDialog.this.startTimestamp.setToolTipText("Invalid timestamp");
                MSCFilterDialog.this.startTimestamp.setBackground(MSCFilterDialog.this.getShell().getDisplay().getSystemColor(3));
                MSCFilterDialog.this.invalidStartTimestamp.setVisible(true);
                MSCFilterDialog.this.isStartTimeStampValid = false;
                MSCFilterDialog.this.validate();
                return;
            }
            MSCFilterDialog.this.startTimestamp.setToolTipText("");
            MSCFilterDialog.this.startTimestamp.setBackground(null);
            MSCFilterDialog.this.invalidStartTimestamp.setVisible(false);
            MSCFilterDialog.this.isStartTimeStampValid = true;
            MSCFilterDialog.this.validate();
        }
    };
    private final Listener endTimeStampChanged = new Listener(){

        public void handleEvent(Event event) {
            if (MSCFilterDialog.this.endTimestamp.getText().length() > 0 && LogFileHandler.validateTimeStamp(MSCFilterDialog.this.endTimestamp.getText(), MSCFilterDialog.this.filterPattern.getTimeInterval().getTimeStampFormat()) == null) {
                MSCFilterDialog.this.endTimestamp.setToolTipText("Invalid timestamp");
                MSCFilterDialog.this.endTimestamp.setBackground(MSCFilterDialog.this.getShell().getDisplay().getSystemColor(3));
                MSCFilterDialog.this.invalidEndTimestamp.setVisible(true);
                MSCFilterDialog.this.isEndTimeStampValid = false;
                MSCFilterDialog.this.validate();
                return;
            }
            MSCFilterDialog.this.endTimestamp.setToolTipText("");
            MSCFilterDialog.this.endTimestamp.setBackground(null);
            MSCFilterDialog.this.invalidEndTimestamp.setVisible(false);
            MSCFilterDialog.this.isEndTimeStampValid = true;
            MSCFilterDialog.this.validate();
        }
    };

    public MSCFilterDialog(Shell parentShell, FilterPattern filterPattern) {
        super(parentShell);
        this.filterPattern = new FilterPattern(filterPattern);
    }

    public MSCFilterDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Filter");
        parent.getShell().setImage(Activator.getDefault().getIcon("icons/filter2.gif"));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout mainLayout = new GridLayout(2, false);
        mainLayout.marginHeight = 20;
        mainLayout.marginWidth = 20;
        container.setLayout((Layout)mainLayout);
        container.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createEventTypesGroup(container);
        this.setTreeContent(this.filterPattern);
        Composite rightSide = new Composite(container, 0);
        GridLayout rightLayout = new GridLayout(1, true);
        rightLayout.verticalSpacing = 20;
        rightSide.setLayout((Layout)rightLayout);
        rightSide.setLayoutData((Object)new GridData(0x1000000, 128, false, true));
        this.createSearchGroup(rightSide);
        this.createTimeGroup(rightSide);
        return container;
    }

    protected Group createEventTypesGroup(Composite parent) {
        Group eventContainer = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        eventContainer.setText("Event types");
        eventContainer.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 0x1000000;
        eventContainer.setLayoutData((Object)gd);
        this.checkTree = new Tree((Composite)eventContainer, 2080);
        this.checkTree.setLayoutData((Object)new GridData(1808));
        this.checkTree.addListener(13, this.changeListener);
        this.checkTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32 && e.item instanceof TreeItem) {
                    TreeItem item = (TreeItem)e.item;
                    TreeItem parent = item.getParentItem();
                    if (parent != null) {
                        TreeItem[] children = parent.getItems();
                        int numberOfChildren = children.length;
                        int checkedChildren = 0;
                        for (TreeItem child : children) {
                            if (!child.getChecked()) continue;
                            ++checkedChildren;
                        }
                        if (checkedChildren == numberOfChildren) {
                            parent.setGrayed(false);
                            parent.setChecked(true);
                        } else if (checkedChildren == 0) {
                            parent.setGrayed(false);
                            parent.setChecked(false);
                        } else {
                            parent.setChecked(true);
                            parent.setGrayed(true);
                        }
                    } else {
                        TreeItem[] children;
                        item.setGrayed(false);
                        boolean checked = item.getChecked();
                        for (TreeItem aChildren : children = item.getItems()) {
                            aChildren.setChecked(checked);
                        }
                    }
                    MSCFilterDialog.this.changed = true;
                }
            }
        });
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.checkTree.setLayoutData((Object)gridData);
        gridData.widthHint = 180;
        this.inclusiveButton = new Button((Composite)eventContainer, 32);
        this.inclusiveButton.setLayoutData((Object)new GridData(0x1000000, 128, true, false, 2, 1));
        this.inclusiveButton.setText("Inclusive");
        this.inclusiveButton.setSelection(this.filterPattern.isInclusive());
        this.inclusiveButton.addListener(13, this.changeListener);
        this.allButton = new Button((Composite)eventContainer, 8);
        this.allButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.allButton.setText("Select all");
        this.allButton.addListener(13, this.changeListener);
        this.allButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MSCFilterDialog.this.changed = true;
                MSCFilterDialog.this.selectAll();
            }
        });
        this.noneButton = new Button((Composite)eventContainer, 8);
        this.noneButton.setText("Deselect all");
        this.noneButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.noneButton.addListener(13, this.changeListener);
        this.noneButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MSCFilterDialog.this.changed = true;
                MSCFilterDialog.this.deselectAll();
            }
        });
        return eventContainer;
    }

    protected Group createSearchGroup(Composite parent) {
        Group searchGroup = new Group(parent, 0);
        GridLayout searchLayout = new GridLayout(2, true);
        searchGroup.setLayout((Layout)searchLayout);
        searchGroup.setLayoutData((Object)new GridData(4, 2, true, false));
        searchGroup.setText("Filter string");
        CLabel wildCardsLabel = new CLabel((Composite)searchGroup, 0);
        wildCardsLabel.setText("* = any string, ? = any character, \\ = escape for literals: *?\\");
        wildCardsLabel.setImage(Activator.getDefault().getIcon("icons/tree_text_obj.gif"));
        wildCardsLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.filterStringBox = new Text((Composite)searchGroup, 2048);
        this.filterStringBox.setText(this.filterPattern.getFilterExpression());
        this.filterStringBox.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.filterStringBox.addListener(24, this.filterStringChanged);
        this.filterStringBox.addListener(24, this.changeListener);
        this.isCaseSensitiveButton = new Button((Composite)searchGroup, 32);
        this.isCaseSensitiveButton.setText("Case sensitive");
        this.isCaseSensitiveButton.setSelection(this.filterPattern.isCaseSensitive());
        this.isCaseSensitiveButton.addListener(13, this.changeListener);
        this.isRegularExpressionButton = new Button((Composite)searchGroup, 32);
        this.isRegularExpressionButton.setText("Regular expression");
        this.isRegularExpressionButton.setSelection(this.filterPattern.isRegularExpression());
        this.isRegularExpressionButton.addListener(13, this.filterStringChanged);
        this.isRegularExpressionButton.addListener(13, this.changeListener);
        Label searchInLabel = new Label((Composite)searchGroup, 0);
        searchInLabel.setText("Search in: ");
        searchInLabel.setLayoutData((Object)new GridData(16384, 128, true, false, 2, 1));
        this.sourceInfoButton = new Button((Composite)searchGroup, 32);
        this.sourceInfoButton.setText("Source Info");
        if (this.filterPattern.getFieldsToFilter() != null) {
            this.sourceInfoButton.setSelection(this.filterPattern.getFieldsToFilter().get((Object)FilterPattern.Field.SOURCE_INFO).booleanValue());
        } else {
            this.sourceInfoButton.setSelection(true);
        }
        this.sourceInfoButton.addListener(13, this.changeListener);
        this.messageButton = new Button((Composite)searchGroup, 32);
        this.messageButton.setText("Message");
        if (this.filterPattern.getFieldsToFilter() != null) {
            this.messageButton.setSelection(this.filterPattern.getFieldsToFilter().get((Object)FilterPattern.Field.MESSAGE).booleanValue());
        } else {
            this.messageButton.setSelection(true);
        }
        this.messageButton.addListener(13, this.changeListener);
        return searchGroup;
    }

    protected Group createTimeGroup(Composite parent) {
        Group timeGroup = new Group(parent, 0);
        GridLayout timeLayout = new GridLayout(2, true);
        timeLayout.marginHeight = 20;
        timeGroup.setLayout((Layout)timeLayout);
        timeGroup.setLayoutData((Object)new GridData(4, 2, true, false));
        timeGroup.setText("Filter by time interval");
        Composite start = new Composite((Composite)timeGroup, 0);
        start.setLayout((Layout)new GridLayout(2, false));
        Label startLabel = new Label(start, 0);
        startLabel.setText("Start: ");
        this.startTimestamp = new Text(start, 2048);
        this.startTimestamp.setText(this.filterPattern.getTimeInterval() != null ? this.filterPattern.getTimeInterval().getStart() : "");
        this.startTimestamp.setLayoutData((Object)new GridData(this.filterPattern.getTimeInterval().getTimeStampFormat().length() * 6, 20));
        this.startTimestamp.addListener(24, this.startTimeStampChanged);
        this.startTimestamp.addListener(24, this.changeListener);
        this.startTimestamp.setTextLimit(this.filterPattern.getTimeInterval().getTimeStampFormat().length());
        Composite end = new Composite((Composite)timeGroup, 0);
        end.setLayout((Layout)new GridLayout(2, false));
        Label endLabel = new Label(end, 0);
        endLabel.setText("End: ");
        this.endTimestamp = new Text(end, 2048);
        this.endTimestamp.setText(this.filterPattern.getTimeInterval().getEnd() != null ? this.filterPattern.getTimeInterval().getEnd() : "");
        this.endTimestamp.setLayoutData((Object)new GridData(this.filterPattern.getTimeInterval().getTimeStampFormat().length() * 6, 20));
        this.endTimestamp.addListener(24, this.endTimeStampChanged);
        this.endTimestamp.addListener(24, this.changeListener);
        this.endTimestamp.setTextLimit(this.filterPattern.getTimeInterval().getTimeStampFormat().length());
        this.invalidStartTimestamp = new CLabel((Composite)timeGroup, 0);
        this.invalidStartTimestamp.setText("Invalid timestamp");
        this.invalidStartTimestamp.setImage(Activator.getDefault().getIcon("icons/testerr.gif"));
        this.invalidStartTimestamp.setVisible(false);
        this.invalidEndTimestamp = new CLabel((Composite)timeGroup, 0);
        this.invalidEndTimestamp.setText("Invalid timestamp");
        this.invalidEndTimestamp.setImage(Activator.getDefault().getIcon("icons/testerr.gif"));
        this.invalidEndTimestamp.setVisible(false);
        CLabel formatLabel = new CLabel((Composite)timeGroup, 0);
        formatLabel.setText("Format: " + this.filterPattern.getTimeInterval().getTimeStampFormat());
        formatLabel.setImage(Activator.getDefault().getIcon("icons/tree_text_obj.gif"));
        formatLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 2, 1));
        return timeGroup;
    }

    protected void loadFromPreferenceStore() {
        String prefDefValues = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.log.viewer_filter_silent_event_categories");
        if (prefDefValues.length() > 0) {
            this.updateCheckedState(prefDefValues);
            this.updateGrayedState();
        }
    }

    private void updateCheckedState(String prefValues) {
        String[] categories;
        for (String category : categories = prefValues.split(";")) {
            String[] currCategory = category.split("=");
            if (currCategory.length <= 1) continue;
            String currKey = currCategory[0];
            boolean currValue = Boolean.valueOf(currCategory[1]);
            if (currKey.contains("_")) {
                String cat = currKey.split("_")[0];
                int parentIndex = (Integer)this.checkTree.getData(cat);
                int childIndex = (Integer)this.checkTree.getData(currKey);
                this.checkTree.getItem(parentIndex).getItem(childIndex).setChecked(currValue);
                continue;
            }
            this.checkTree.getItem(((Integer)this.checkTree.getData(currKey)).intValue()).setChecked(currValue);
        }
    }

    private void updateGrayedState() {
        TreeItem[] parents;
        for (TreeItem parent : parents = this.checkTree.getItems()) {
            TreeItem[] children = parent.getItems();
            int numOfCheckChildren = 0;
            for (TreeItem child : children) {
                if (!child.getChecked()) continue;
                ++numOfCheckChildren;
            }
            if (numOfCheckChildren > 0 && numOfCheckChildren < children.length) {
                parent.setGrayed(true);
                continue;
            }
            parent.setGrayed(false);
        }
    }

    public FilterPattern getFilterPattern() {
        return this.filterPattern;
    }

    public boolean getChanged() {
        return this.changed;
    }

    private boolean validate() {
        if (this.isFilterStringValid && this.isStartTimeStampValid && this.isEndTimeStampValid) {
            this.getButton(0).setEnabled(true);
            return true;
        }
        this.getButton(0).setEnabled(false);
        return false;
    }

    protected void okPressed() {
        if (!this.changed) {
            this.setReturnCode(0);
            this.close();
            return;
        }
        for (TreeItem item : this.checkTree.getItems()) {
            this.filterPattern.getEventsToFilter().put((String)item.getData(), item.getChecked());
        }
        this.filterPattern.setInclusive(this.inclusiveButton.getSelection());
        HashMap<FilterPattern.Field, Boolean> fieldsToFilter = new HashMap<FilterPattern.Field, Boolean>();
        fieldsToFilter.put(FilterPattern.Field.SOURCE_INFO, this.sourceInfoButton.getSelection());
        fieldsToFilter.put(FilterPattern.Field.MESSAGE, this.messageButton.getSelection());
        this.filterPattern.setFilterExpression(this.filterStringBox.getText(), fieldsToFilter, this.isCaseSensitiveButton.getSelection(), this.isRegularExpressionButton.getSelection());
        this.filterPattern.setCaseSensitive(this.isCaseSensitiveButton.getSelection());
        this.filterPattern.setRegularExpression(this.isRegularExpressionButton.getSelection());
        this.filterPattern.setTimeInterval(new TimeInterval(this.startTimestamp.getText(), this.endTimestamp.getText(), this.filterPattern.getTimeInterval().getTimeStampFormat()));
        this.setReturnCode(0);
        this.close();
    }

    private void setTreeContent(FilterPattern pattern) {
        this.checkTree.setRedraw(false);
        if (pattern.containsSilentEvents()) {
            for (Map.Entry<String, String[]> entry : Constants.EVENT_CATEGORIES.entrySet()) {
                TreeItem parentItem = new TreeItem(this.checkTree, 0);
                parentItem.setText(entry.getKey());
                parentItem.setData((Object)entry.getKey());
                parentItem.setChecked(((Boolean)pattern.getEventsToFilter().get(entry.getKey())).booleanValue());
                for (String str : entry.getValue()) {
                    String silentEvent = entry.getKey() + "_" + str;
                    TreeItem childItem = new TreeItem(parentItem, 0);
                    childItem.setText(str);
                    childItem.setData((Object)silentEvent);
                    if (pattern.getEventsToFilter().get(silentEvent) != null) {
                        childItem.setChecked(((Boolean)pattern.getEventsToFilter().get(silentEvent)).booleanValue());
                        continue;
                    }
                    childItem.setChecked(false);
                }
            }
            this.checkTree.setRedraw(true);
            return;
        }
        for (Map.Entry<String, String[]> entry : Constants.EVENT_CATEGORIES.entrySet()) {
            TreeItem parentItem = new TreeItem(this.checkTree, 0);
            parentItem.setText(entry.getKey());
            parentItem.setData((Object)entry.getKey());
            parentItem.setChecked(((Boolean)this.filterPattern.getEventsToFilter().get(entry.getKey())).booleanValue());
        }
        this.checkTree.setRedraw(true);
    }

    public void deselectAll() {
        TreeItem[] parents;
        for (TreeItem parent : parents = this.checkTree.getItems()) {
            TreeItem[] children;
            parent.setChecked(false);
            if (parent.getGrayed()) {
                parent.setGrayed(false);
            }
            for (TreeItem child : children = parent.getItems()) {
                child.setChecked(false);
            }
        }
    }

    public void selectAll() {
        TreeItem[] parents;
        for (TreeItem parent : parents = this.checkTree.getItems()) {
            TreeItem[] children;
            parent.setChecked(true);
            if (parent.getGrayed()) {
                parent.setGrayed(false);
            }
            for (TreeItem child : children = parent.getItems()) {
                child.setChecked(true);
            }
        }
    }
}

