/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public class SetverdictComp
extends MSCNode {
    private final Lifeline lifeline;
    private final String verdict;

    public SetverdictComp(int eventOccurrence, Lifeline lifeline, String verdict) {
        super(eventOccurrence);
        this.lifeline = lifeline;
        this.verdict = verdict;
    }

    @Override
    public int getX() {
        return MSCConstants.COLUMN_WIDTH * this.lifeline.getIndex() + MSCConstants.COLUMN_WIDTH / 2 - this.getWidth() / 2 + 1;
    }

    @Override
    public int getY() {
        return MSCConstants.ROW_HEIGHT * this.getStartOccurrence() + 5 + this.getHeight() / 2 - 2;
    }

    @Override
    public int getWidth() {
        return this.getHeight() + 4;
    }

    @Override
    public int getHeight() {
        return MSCConstants.ROW_HEIGHT - 20 + 2;
    }

    @Override
    protected void draw(IGC context) {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth() - 1;
        int height = this.getHeight() - 1;
        int size = 4;
        context.setLineStyle(context.getLineSolidStyle());
        context.setLineWidth(2);
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_GREY"));
        int[] shadowPointsA = new int[]{++x, ++y, x + 4, y, x + width, y + height, x + width - 4, y + height};
        int[] shadowPointsB = new int[]{x + width, y, x + width - 4, y, x, y + height, x + 4, y + height};
        context.fillPolygon(shadowPointsA);
        context.fillPolygon(shadowPointsB);
        int[] pointsA = new int[]{--x, --y, x + 4, y, x + --width, y + --height, x + width - 4, y + height};
        int[] pointsB = new int[]{x + width, y, x + width - 4, y, x, y + height, x + 4, y + height};
        context.setForeground((Color)Activator.getDefault().getCachedResource("COLOR_BLACK"));
        context.drawPolygon(pointsA);
        context.drawPolygon(pointsB);
        context.setBackground((Color)Activator.getDefault().getCachedResource(MSCConstants.getVerdictColor(this.verdict)));
        context.fillPolygon(pointsA);
        context.fillPolygon(pointsB);
    }

    @Override
    public MSCNode.Type getType() {
        return MSCNode.Type.SETVERDICT_COMPONENT;
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        return true;
    }
}

