/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.constraintgraph.impl;

import org.eclipse.trace4cps.analysis.constraintgraph.impl.ClaimNode;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.ConstraintGraphNode;

public class Constraint {
    private final ConstraintGraphNode src;
    private final ConstraintGraphNode dst;
    private double weight;

    Constraint(ConstraintGraphNode src, ConstraintGraphNode dst, double weight) {
        this.src = src;
        this.dst = dst;
        this.weight = weight;
    }

    public ConstraintGraphNode getSrc() {
        return this.src;
    }

    public ConstraintGraphNode getDst() {
        return this.dst;
    }

    public final boolean isClaimDurationConstraint() {
        if (this.src instanceof ClaimNode && this.dst instanceof ClaimNode) {
            ClaimNode e1 = (ClaimNode)this.src;
            ClaimNode e2 = (ClaimNode)this.dst;
            return (e1.isClaimStart() && e2.isClaimStop() || e2.isClaimStart() && e1.isClaimStop()) && e1.getClaim() == e2.getClaim();
        }
        return false;
    }

    public double weight() {
        return this.weight;
    }

    public final String toString() {
        return this.src + " ---[" + this.weight + "]--> " + this.dst;
    }
}

