/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.data.xy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeDataItem;
import org.jfree.chart.util.Args;
import org.jfree.data.general.Series;

public class XYEdgeSeries
extends Series {
    private static final long serialVersionUID = 7175710875342448296L;
    private final List<XYEdgeDataItem> items = new ArrayList<XYEdgeDataItem>();

    public XYEdgeSeries(Comparable<?> key) {
        super(key);
    }

    public XYEdgeSeries(Comparable<?> key, String description) {
        super(key, description);
    }

    public void add(XYEdgeDataItem item, boolean notify) {
        Args.nullNotPermitted((Object)item, (String)"item");
        this.items.add(item);
        if (notify) {
            this.fireSeriesChanged();
        }
    }

    public void removeAllSeries() {
        this.items.clear();
        this.fireSeriesChanged();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public XYEdgeDataItem getDataItem(int item) {
        if (item < 0 || item >= this.getItemCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.items.get(item);
    }

    public Number getX(int item) {
        XYEdgeDataItem dataItem = this.getDataItem(item);
        return dataItem.getX0Value() * 0.5 + dataItem.getX1Value() * 0.5;
    }

    public Number getY(int item) {
        XYEdgeDataItem dataItem = this.getDataItem(item);
        return dataItem.getY0Value() * 0.5 + dataItem.getY1Value() * 0.5;
    }

    public Number getStartX(int item) {
        return this.getDataItem(item).getX0Value();
    }

    public Number getEndX(int item) {
        return this.getDataItem(item).getX1Value();
    }

    public Number getStartY(int item) {
        return this.getDataItem(item).getY0Value();
    }

    public Number getEndY(int item) {
        return this.getDataItem(item).getY1Value();
    }
}

