/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.resource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ResourceClientHistogram {
    private static final Comparator<Event> COMP = new Comparator<Event>(){

        @Override
        public int compare(Event o1, Event o2) {
            return Double.compare(o1.timeStamp, o2.timeStamp);
        }
    };
    private final TreeMap<Integer, Double> histogram = new TreeMap();
    private final TreeMap<Integer, Double> normalizedHistogram = new TreeMap();
    private final TreeMap<Integer, Double> normalizedCumulHistogram = new TreeMap();
    private boolean done = false;
    private final List<Event> events = new ArrayList<Event>();

    public void claim(double start, double end) {
        if (this.done) {
            throw new IllegalStateException("client usage has already been called once");
        }
        if (start < end) {
            this.events.add(new Event(start, true));
            this.events.add(new Event(end, false));
        }
    }

    public TreeMap<Integer, Double> getClientUsage() {
        if (!this.done) {
            throw new IllegalStateException("done has not been called");
        }
        return this.histogram;
    }

    public TreeMap<Integer, Double> getNormalizedClientUsage() {
        if (!this.done) {
            throw new IllegalStateException("done has not been called");
        }
        return this.normalizedHistogram;
    }

    public TreeMap<Integer, Double> getNormalizedCumulativeClientUsage() {
        if (!this.done) {
            throw new IllegalStateException("done has not been called");
        }
        return this.normalizedCumulHistogram;
    }

    public void done(double firstTimeStamp, double lastTimeStamp) {
        this.done = true;
        if (this.events.size() == 0) {
            this.histogram.put(0, lastTimeStamp - firstTimeStamp);
            this.normalizedHistogram.put(0, 100.0);
            this.normalizedCumulHistogram.put(0, 100.0);
            return;
        }
        Collections.sort(this.events, COMP);
        int cnt = 0;
        double prevTimeStamp = 0.0;
        if (this.events.size() > 0) {
            prevTimeStamp = this.events.get((int)0).timeStamp;
        }
        if (prevTimeStamp < firstTimeStamp) {
            throw new IllegalStateException("timestamps from claims are before the first timestamp");
        }
        this.process(firstTimeStamp, prevTimeStamp, 0);
        for (Event e : this.events) {
            this.process(prevTimeStamp, e.timeStamp, cnt);
            prevTimeStamp = e.timeStamp;
            if (e.isStart) {
                ++cnt;
                continue;
            }
            --cnt;
        }
        if (prevTimeStamp > lastTimeStamp) {
            throw new IllegalStateException("timestamps from claims are after the last timestamp");
        }
        this.process(prevTimeStamp, lastTimeStamp, cnt);
        double sum = 0.0;
        for (Double t : this.histogram.values()) {
            sum += t.doubleValue();
        }
        double prevV = 0.0;
        for (Map.Entry<Integer, Double> e : this.histogram.entrySet()) {
            double v = e.getValue() * 100.0 / sum;
            this.normalizedHistogram.put(e.getKey(), v);
            this.normalizedCumulHistogram.put(e.getKey(), v + prevV);
            prevV += v;
        }
    }

    private void process(double start, double end, int cnt) {
        if (end > start) {
            Double v = this.histogram.get(cnt);
            if (v == null) {
                v = 0.0;
            }
            this.histogram.put(cnt, v + (end - start));
        }
    }

    private static final class Event {
        private final double timeStamp;
        private boolean isStart;

        private Event(double t, boolean start) {
            this.timeStamp = t;
            this.isStart = start;
        }
    }
}

