/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class StyleManager {
    private static final StyleManager EMPTY = new StyleManager(Collections.emptyMap());
    private final Map<String, OutputElementStyle> fStyleMap;

    public StyleManager(Map<String, OutputElementStyle> styleMap) {
        this.fStyleMap = styleMap;
    }

    public static StyleManager empty() {
        return EMPTY;
    }

    public @Nullable Object getStyle(OutputElementStyle elementStyle, String property) {
        OutputElementStyle style = elementStyle;
        Stack<String> styleQueue = new Stack<String>();
        while (style != null) {
            Map styleValues = style.getStyleValues();
            Object value = styleValues.get(property);
            if (value != null) {
                return value;
            }
            style = this.popNextStyle(style, styleQueue);
        }
        return null;
    }

    private @Nullable OutputElementStyle popNextStyle(OutputElementStyle style, Stack<String> styleQueue) {
        OutputElementStyle nextStyle = null;
        String parentKey = style.getParentKey();
        if (parentKey != null) {
            String[] split = parentKey.split(",");
            styleQueue.addAll(Arrays.asList(split));
        }
        while (nextStyle == null && !styleQueue.isEmpty()) {
            nextStyle = this.fStyleMap.get(styleQueue.pop());
        }
        return nextStyle;
    }

    public @Nullable Float getFactorStyle(OutputElementStyle elementStyle, String property) {
        Float factor = null;
        OutputElementStyle style = elementStyle;
        Stack<String> styleQueue = new Stack<String>();
        while (style != null) {
            Object value;
            Map styleValues = style.getStyleValues();
            if (factor == null && (value = styleValues.get(property + "-factor")) instanceof Number) {
                factor = Float.valueOf(((Number)value).floatValue());
            }
            if ((value = styleValues.get(property)) instanceof Number) {
                float floatValue = ((Number)value).floatValue();
                return Float.valueOf(factor == null ? floatValue : factor.floatValue() * floatValue);
            }
            style = this.popNextStyle(style, styleQueue);
        }
        return factor == null ? null : factor;
    }

    public @Nullable RGBAColor getColorStyle(OutputElementStyle elementStyle, String property) {
        RGBAColor rgba;
        int alpha;
        String color = null;
        Float opacity = null;
        RGBAColor blend = null;
        OutputElementStyle style = elementStyle;
        Stack<String> styleQueue = new Stack<String>();
        while (style != null) {
            RGBAColor rgba2;
            Object value;
            Map styleValues = style.getStyleValues();
            if (blend == null && (value = styleValues.get(property + "-blend")) instanceof String && (rgba2 = RGBAColor.fromString((String)((String)value))) != null) {
                blend = rgba2;
            }
            if (opacity == null && (value = styleValues.get("opacity")) instanceof Number) {
                opacity = Float.valueOf(((Number)value).floatValue());
                if (color != null) break;
            }
            if (color == null && (value = styleValues.get(property)) instanceof String) {
                color = (String)value;
                if (opacity != null) break;
            }
            style = this.popNextStyle(style, styleQueue);
        }
        int n = alpha = opacity == null ? 255 : (int)(opacity.floatValue() * 255.0f);
        RGBAColor rGBAColor = color == null ? (opacity == null ? null : new RGBAColor(0, 0, 0, alpha)) : (rgba = RGBAColor.fromString(color, (int)alpha));
        return rgba == null ? null : (blend == null ? rgba : StyleManager.blend(rgba, blend));
    }

    private static RGBAColor blend(RGBAColor rgba1, RGBAColor rgba2) {
        float alpha1 = (float)rgba1.getAlpha() / 255.0f;
        float alpha2 = (float)rgba2.getAlpha() / 255.0f;
        float alpha = alpha1 + alpha2 - alpha1 * alpha2;
        int r = StyleManager.blend(alpha1, rgba1.getRed(), alpha2, rgba2.getRed(), alpha);
        int g = StyleManager.blend(alpha1, rgba1.getGreen(), alpha2, rgba2.getGreen(), alpha);
        int b = StyleManager.blend(alpha1, rgba1.getBlue(), alpha2, rgba2.getBlue(), alpha);
        return new RGBAColor(r, g, b, Math.round(alpha * 255.0f));
    }

    private static int blend(float alpha1, int color1, float alpha2, int color2, float alpha) {
        return (int)((alpha1 * (1.0f - alpha2) * (float)color1 + alpha2 * (float)color2) / alpha);
    }
}

