/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.net.impl.DefaultNetSocket;
import org.vertx.java.core.net.impl.VertxHandler;

public class VertxNetHandler
extends VertxHandler<DefaultNetSocket> {
    public VertxNetHandler(VertxInternal vertx, Map<Channel, DefaultNetSocket> connectionMap) {
        super(vertx, connectionMap);
    }

    @Override
    protected void channelRead(final DefaultNetSocket sock, final DefaultContext context, ChannelHandlerContext chctx, Object msg) throws Exception {
        if (sock != null) {
            final ByteBuf buf = (ByteBuf)msg;
            Channel ch = chctx.channel();
            if (context.isOnCorrectWorker(ch.eventLoop())) {
                try {
                    this.vertx.setContext(context);
                    try {
                        sock.handleDataReceived(new Buffer(buf));
                    }
                    catch (Throwable t) {
                        context.reportException(t);
                    }
                }
                catch (Throwable t) {
                    context.reportException(t);
                }
            } else {
                context.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            sock.handleDataReceived(new Buffer(buf));
                        }
                        catch (Throwable t) {
                            context.reportException(t);
                        }
                    }
                });
            }
        }
    }

    @Override
    protected Object safeObject(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof ByteBuf) {
            return VertxNetHandler.safeBuffer((ByteBuf)msg, allocator);
        }
        return msg;
    }
}

