/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.vertx.core.dns.impl.netty.DnsEntry;

public class DnsResource
extends DnsEntry
implements ByteBufHolder {
    private final int contentIndex;
    private final long ttl;
    private final ByteBuf content;

    public DnsResource(String name, int type, int aClass, long ttl, int contentIndex, ByteBuf content) {
        super(name, type, aClass);
        this.ttl = ttl;
        this.contentIndex = contentIndex;
        this.content = content;
    }

    public long timeToLive() {
        return this.ttl;
    }

    public int contentIndex() {
        return this.contentIndex;
    }

    public int contentLength() {
        return this.content.writerIndex() - this.content.readerIndex();
    }

    public ByteBuf content() {
        return this.content;
    }

    public DnsResource copy() {
        return new DnsResource(this.name(), this.type(), this.dnsClass(), this.ttl, this.contentIndex, this.content.copy());
    }

    public ByteBufHolder duplicate() {
        return new DnsResource(this.name(), this.type(), this.dnsClass(), this.ttl, this.contentIndex, this.content.duplicate());
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public DnsResource retain() {
        this.content.retain();
        return this;
    }

    public DnsResource retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    public boolean release(int decrement) {
        return this.content.release(decrement);
    }
}

