/*******************************************************************************
 * Copyright (c) 2004, 2008 John Krasnay and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     John Krasnay - initial API and implementation
 *     Igor Jacy Lino Campista - Java 5 warnings fixed (bug 311325)
 *******************************************************************************/
package org.eclipse.vex.core.internal.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.vex.core.internal.core.Insets;
import org.eclipse.vex.core.internal.css.CSS;
import org.eclipse.vex.core.internal.css.Styles;
import org.eclipse.vex.core.internal.dom.Element;

/**
 * An anonymous box that contains the table row groups for a table. This box is generated by a TableBox and assumes the
 * margins and borders of the table element.
 */
public class TableBodyBox extends AbstractBlockBox {

	public TableBodyBox(final LayoutContext context, final TableBox parent, final int startOffset, final int endOffset) {
		super(context, parent, startOffset, endOffset);
	}

	@Override
	protected List<Box> createChildren(final LayoutContext context) {
		// TODO Auto-generated method stub

		// Walk children:
		// each table-*-group gets a non-anonymous TableRowGroupBox
		// runs of others get anonymous TableRowGroupBox

		final List<Box> children = new ArrayList<Box>();

		iterateChildrenByDisplayStyle(context.getStyleSheet(), childDisplayStyles, new ElementOrRangeCallback() {
			public void onElement(final Element child, final String displayStyle) {
				children.add(new TableRowGroupBox(context, TableBodyBox.this, child));
			}

			public void onRange(final Element parent, final int startOffset, final int endOffset) {
				children.add(new TableRowGroupBox(context, TableBodyBox.this, startOffset, endOffset));
			}
		});

		return children;
	}

	/**
	 * Return the insets of the parent box.
	 */
	@Override
	public Insets getInsets(final LayoutContext context, final int containerWidth) {
		if (getParent().getElement() != null) {
			final Styles styles = context.getStyleSheet().getStyles(getParent().getElement());
			return AbstractBox.getInsets(styles, containerWidth);
		} else {
			return Insets.ZERO_INSETS;
		}
	}

	@Override
	public void paint(final LayoutContext context, final int x, final int y) {
		this.drawBox(context, getParent().getElement(), x, y, getParent().getWidth(), true);
		paintChildren(context, x, y);
	}

	// ======================================================== PRIVATE

	private static Set<String> childDisplayStyles = new HashSet<String>();

	static {
		childDisplayStyles.add(CSS.TABLE_ROW_GROUP);
		childDisplayStyles.add(CSS.TABLE_HEADER_GROUP);
		childDisplayStyles.add(CSS.TABLE_FOOTER_GROUP);
	}

}
