/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.ByteIterator;

/**
 * This file was automatically generated from template file collectPrimitiveToPrimitiveIterable.stg.
 */
public class CollectByteToByteIterable
        extends AbstractLazyByteIterable
{
    private final ByteIterable iterable;
    private final ByteToByteFunction function;

    public CollectByteToByteIterable(ByteIterable iterable, ByteToByteFunction function)
    {
        this.iterable = iterable;
        this.function = function;
    }

    public void each(final ByteProcedure procedure)
    {
        this.iterable.forEach(new ByteProcedure()
        {
            public void value(byte each)
            {
                procedure.value(CollectByteToByteIterable.this.function.valueOf(each));
            }
        });
    }

    public ByteIterator byteIterator()
    {
        return new ByteIterator()
        {
            private final ByteIterator iterator = CollectByteToByteIterable.this.iterable.byteIterator();

            public boolean hasNext()
            {
                return this.iterator.hasNext();
            }

            public byte next()
            {
                return CollectByteToByteIterable.this.function.valueOf(this.iterator.next());
            }
        };
    }

    @Override
    public int size()
    {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.iterable.notEmpty();
    }
}
