/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.factory.map.primitive.ImmutableShortObjectMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableShortObjectMap;
import org.eclipse.collections.api.map.primitive.ShortObjectMap;

/**
 * ImmutableShortObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortObjectMapFactoryImpl implements ImmutableShortObjectMapFactory
{
    public <V> ImmutableShortObjectMap<V> empty()
    {
        return (ImmutableShortObjectMap<V>) ImmutableShortObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableShortObjectMap<V> of()
    {
        return this.empty();
    }

    public <V> ImmutableShortObjectMap<V> with()
    {
        return this.empty();
    }

    public <V> ImmutableShortObjectMap<V> of(short key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableShortObjectMap<V> with(short key, V value)
    {
        return new ImmutableShortObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableShortObjectMap<V> ofAll(ShortObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableShortObjectMap<V> withAll(ShortObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableShortObjectMap)
        {
            return (ImmutableShortObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final short[] array = new short[1];
            map.forEachKey(new ShortProcedure()
            {
                public void value(short each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableShortObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableShortObjectHashMap<V>(map);
    }
}
