/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.editor.text.light.vtml;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.viatra2.editor.text.light.IVTEConstants;
import org.eclipse.viatra2.editor.text.light.VTEColorProvider;
import org.eclipse.viatra2.editor.text.light.VTEColorToken;
import org.eclipse.viatra2.editor.text.light.vtml.VTMLWhitespaceDetector;
import org.eclipse.viatra2.editor.text.light.vtml.VTMLWordDetector;

public class VTMLCodeScanner
extends RuleBasedScanner {
    public VTMLCodeScanner(VTEColorProvider provider, VTEColorToken vct) {
        Token keyword = vct.KEYWORD;
        Token string = vct.STRING;
        Token comment = vct.COMMENT;
        Token other = vct.OTHER;
        String[] keywords = IVTEConstants.vtmlKeywords;
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("/*", "*/", (IToken)comment));
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new VTMLWhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new VTMLWordDetector(), (IToken)other);
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

