/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal;

import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.logger.Logger;

public class SearchPlan {
    private SearchPlanOperation[] operations;
    private int currentOperation;

    public SearchPlan(SearchPlanOperation[] operations) {
        this.operations = operations;
        this.currentOperation = -1;
    }

    private void init(MatchingFrame frame) throws PatternMatcherRuntimeException {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            this.operations[this.currentOperation].preprocess(frame);
        } else if (this.currentOperation == this.operations.length - 1) {
            --this.currentOperation;
        } else {
            String[] context = new String[]{frame.getPattern().getParent().getPattern().getName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The search plan initaliziation of the {1} GT Patten failed.", context, (AnnotatedElement)frame.getPattern().getParent().getPattern());
        }
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) throws PatternMatcherRuntimeException {
        int upperBound = this.operations.length - 1;
        this.init(frame);
        while (this.currentOperation >= 0 && this.currentOperation < upperBound) {
            if (this.operations[this.currentOperation].execute(frame)) {
                ++this.currentOperation;
                this.operations[this.currentOperation].preprocess(frame);
                continue;
            }
            this.operations[this.currentOperation].postprocess(frame);
            --this.currentOperation;
        }
        return this.currentOperation == upperBound;
    }

    public void printDebugInformation(Logger logger) {
        int i = 0;
        while (i < this.operations.length) {
            logger.debug("[" + i + "]\t" + this.operations[i].toString());
            ++i;
        }
    }
}

