/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ExtendOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendBoundNodeOperation
extends ExtendOperation {
    private Integer bound;

    public ExtendBoundNodeOperation(Integer bound, Integer unbound, SearchGraphEdge edge) {
        super(unbound, edge);
        this.bound = bound;
    }

    @Override
    public void preprocess(MatchingFrame frame) throws PatternMatcherRuntimeException {
        IModelElement boundElement = null;
        try {
            boundElement = (IModelElement)frame.getValue(this.bound);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.edge.getVPMEdgeType().toString(), frame.getPattern().getSearchGraph().getSearchNode(this.bound).getName(), frame.getValue(this.bound).getClass().getName()};
            throw new PatternMatcherRuntimeException("Type mismatch: {2} did not evaluate to a model element (entity or relation), but to type {3} instead. Developer's note: error occurred during the '{1}' type extend operation.", context, frame.getPattern().getSearchGraph().getSearchNode(this.bound).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (boundElement == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.bound).getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.bound).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && !this.edge.isSource()) {
            this.iterator = boundElement.getAllTypes().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && this.edge.isSource()) {
            this.iterator = boundElement.getAllInstances().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && !this.edge.isSource()) {
            this.iterator = boundElement.getAllSubtypes().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && this.edge.isSource()) {
            this.iterator = boundElement.getAllSupertypes().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && !this.edge.isSource()) {
            this.iterator = boundElement.getRelationsFrom().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && this.edge.isSource()) {
            HashSet<IModelElement> coll = new HashSet<IModelElement>();
            if (boundElement instanceof IRelation) {
                coll.add(((IRelation)boundElement).getFrom());
            }
            this.iterator = coll.iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.TARGET && !this.edge.isSource()) {
            this.iterator = boundElement.getRelationsTo().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.TARGET && this.edge.isSource()) {
            HashSet<IModelElement> coll = new HashSet<IModelElement>();
            if (boundElement instanceof IRelation) {
                coll.add(((IRelation)boundElement).getTo());
            }
            this.iterator = coll.iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.IN && this.edge.isSource()) {
            this.iterator = boundElement.getElementsInNamespace().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.BELOW && this.edge.isSource()) {
            this.iterator = boundElement.getAllElementsInNamespace().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.IN && !this.edge.isSource()) {
            HashSet<IModelElement> coll = new HashSet<IModelElement>();
            if (boundElement.getNamespace() != null) {
                coll.add(boundElement.getNamespace());
            }
            this.iterator = coll.iterator();
        } else {
            if (this.edge.getVPMEdgeType() == EdgeType.BELOW && !this.edge.isSource()) {
                String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getName(), this.edge.getVPMEdgeType().toString()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element generates a '{2}' type operation that is not allowed.", context, this.edge.getTraceabilityElement().getRepresentativeEMFElement());
            }
            if (this.edge.getVPMEdgeType() == EdgeType.NACCHECK) {
                String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getName(), this.edge.getVPMEdgeType().toString()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element generates a '{2}' type operation that is not allowed.", context, this.edge.getTraceabilityElement().getRepresentativeEMFElement());
            }
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.bound + " -- " + this.edge.getVPMEdgeType().name() + " -> " + this.unbound;
    }

    @Override
    public void calculateSidewaysPassedVariables(Set<Integer> variableSet) {
        variableSet.add(this.bound);
        super.calculateSidewaysPassedVariables(variableSet);
    }

    @Override
    public void calculateLocalVariables(Set<Integer> variableSet) {
        variableSet.add(this.bound);
    }
}

