/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction;

import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.AbstractEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.PredicateEvaluatorNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.ReteBoundary;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Buildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Stub;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.DualInputNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ExistenceNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.Indexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.JoinNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.index.ProjectionIndexer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Library;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Network;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.remote.Address;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.EqualityFilterNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.InequalityFilterNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.TrimmerNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.ValueBinderFilterNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.FlatTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.LeftInheritanceTuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteContainerBuildable<PatternDescription>
implements Buildable<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>> {
    protected Library library;
    protected ReteContainer targetContainer;
    protected Network reteNet;
    protected ReteBoundary<PatternDescription> boundary;
    protected ReteEngine<PatternDescription> engine;
    protected boolean headAttached = false;

    public ReteContainerBuildable(ReteEngine<PatternDescription> engine, ReteContainer targetContainer) {
        this.engine = engine;
        this.reteNet = engine.getReteNet();
        this.boundary = engine.getBoundary();
        this.targetContainer = targetContainer;
        this.library = targetContainer.getLibrary();
        this.headAttached = false;
    }

    public ReteContainerBuildable(ReteEngine<PatternDescription> engine) {
        this.engine = engine;
        this.reteNet = engine.getReteNet();
        this.boundary = engine.getBoundary();
        this.targetContainer = this.reteNet.getHeadContainer();
        this.library = this.targetContainer.getLibrary();
        this.headAttached = true;
    }

    @Override
    public void reinitialize() {
        this.reteNet = this.engine.getReteNet();
        this.boundary = this.engine.getBoundary();
        this.targetContainer = this.headAttached ? this.reteNet.getHeadContainer() : this.reteNet.getNextContainer();
        this.library = this.targetContainer.getLibrary();
    }

    @Override
    public Stub<Address<? extends Supplier>> buildTrimmer(Stub<Address<? extends Supplier>> stub, TupleMask trimMask) {
        Address<TrimmerNode> bodyTerminator = this.library.accessTrimmerNode((Address)stub.handle, trimMask);
        return new Stub<Address<? extends Supplier>>(trimMask.transform(stub.calibrationPattern), bodyTerminator);
    }

    @Override
    public void buildConnection(Stub<Address<? extends Supplier>> stub, Address<? extends Receiver> collector) {
        this.reteNet.connectRemoteNodes((Address)stub.handle, collector, true);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildStartStub(Object[] constantValues, Object[] constantNames) {
        return new Stub<Address<? extends Supplier>>(new FlatTuple(constantNames), this.library.accessConstantNode(this.boundary.wrapTuple(new FlatTuple(constantValues))));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildEqualityChecker(Stub<Address<? extends Supplier>> stub, int[] indices) {
        Address<EqualityFilterNode> checker = this.library.accessEqualityFilterNode((Address)stub.handle, indices);
        return new Stub<Address<? extends Supplier>>(stub, checker);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildInjectivityChecker(Stub<Address<? extends Supplier>> stub, int subject, int[] inequalIndices) {
        Address<InequalityFilterNode> checker = this.library.accessInequalityFilterNode((Address)stub.handle, subject, new TupleMask(inequalIndices, stub.calibrationPattern.getSize()));
        return new Stub<Address<? extends Supplier>>(stub, checker);
    }

    @Override
    public Stub<Address<? extends Supplier>> patternCallStub(Tuple nodes, PatternDescription supplierKey) throws RetePatternBuildException {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessProduction(supplierKey));
    }

    @Override
    public Stub<Address<? extends Supplier>> instantiationTransitiveStub(Tuple nodes) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessInstantiationTransitiveRoot());
    }

    @Override
    public Stub<Address<? extends Supplier>> instantiationDirectStub(Tuple nodes) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessInstantiationRoot());
    }

    @Override
    public Stub<Address<? extends Supplier>> generalizationTransitiveStub(Tuple nodes) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessGeneralizationTransitiveRoot());
    }

    @Override
    public Stub<Address<? extends Supplier>> generalizationDirectStub(Tuple nodes) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessGeneralizationRoot());
    }

    @Override
    public Stub<Address<? extends Supplier>> containmentTransitiveStub(Tuple nodes) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessContainmentTransitiveRoot());
    }

    @Override
    public Stub<Address<? extends Supplier>> containmentDirectStub(Tuple nodes) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessContainmentRoot());
    }

    @Override
    public Stub<Address<? extends Supplier>> binaryEdgeTypeStub(Tuple nodes, Object supplierKey) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessBinaryEdgeRoot(supplierKey));
    }

    @Override
    public Stub<Address<? extends Supplier>> ternaryEdgeTypeStub(Tuple nodes, Object supplierKey) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessTernaryEdgeRoot(supplierKey));
    }

    @Override
    public Stub<Address<? extends Supplier>> unaryTypeStub(Tuple nodes, Object supplierKey) {
        return new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessUnaryRoot(supplierKey));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildBetaNode(Stub<Address<? extends Supplier>> primaryStub, Stub<Address<? extends Supplier>> sideStub, TupleMask primaryMask, TupleMask sideMask, TupleMask complementer, boolean negative) {
        Address<ProjectionIndexer> primarySlot = this.library.accessProjectionIndexer((Address)primaryStub.handle, primaryMask);
        Address<ProjectionIndexer> sideSlot = this.library.accessProjectionIndexer((Address)sideStub.handle, sideMask);
        Address<DualInputNode> checker = negative ? this.library.accessExistenceNode(primarySlot, sideSlot, true) : this.library.accessJoinNode(primarySlot, sideSlot, complementer);
        Tuple newCalibrationPattern = negative ? primaryStub.calibrationPattern : complementer.combine(primaryStub.calibrationPattern, sideStub.calibrationPattern, true, true);
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(newCalibrationPattern, checker);
        return result;
    }

    @Override
    public Stub<Address<? extends Supplier>> buildCounterBetaNode(Stub<Address<? extends Supplier>> primaryStub, Stub<Address<? extends Supplier>> sideStub, TupleMask primaryMask, TupleMask originalSideMask, TupleMask complementer, Object aggregateResultCalibrationElement) {
        Address<ProjectionIndexer> primarySlot = this.library.accessProjectionIndexer((Address)primaryStub.handle, primaryMask);
        Address<? extends Indexer> sideSlot = this.library.accessCountOuterIndexer((Address)sideStub.handle, originalSideMask);
        Address<JoinNode> checker = this.library.accessJoinNode(primarySlot, sideSlot, TupleMask.selectSingle(originalSideMask.indices.length, originalSideMask.indices.length + 1));
        Object[] newCalibrationElement = new Object[]{aggregateResultCalibrationElement};
        LeftInheritanceTuple newCalibrationPattern = new LeftInheritanceTuple(primaryStub.calibrationPattern, newCalibrationElement);
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(newCalibrationPattern, checker);
        return result;
    }

    @Override
    public Stub<Address<? extends Supplier>> buildCountCheckBetaNode(Stub<Address<? extends Supplier>> primaryStub, Stub<Address<? extends Supplier>> sideStub, TupleMask primaryMask, TupleMask originalSideMask, int resultPositionInSignature) {
        Address<ProjectionIndexer> primarySlot = this.library.accessProjectionIndexer((Address)primaryStub.handle, primaryMask);
        Address<? extends Indexer> sideSlot = this.library.accessCountOuterIdentityIndexer((Address)sideStub.handle, originalSideMask, resultPositionInSignature);
        Address<JoinNode> checker = this.library.accessJoinNode(primarySlot, sideSlot, TupleMask.empty(originalSideMask.indices.length + 1));
        Tuple newCalibrationPattern = primaryStub.calibrationPattern;
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(newCalibrationPattern, checker);
        return result;
    }

    public Stub<Address<? extends Supplier>> buildPredicateChecker(AbstractEvaluator evaluator, Integer rhsIndex, int[] affectedIndices, Stub<Address<? extends Supplier>> stub) {
        PredicateEvaluatorNode ten = new PredicateEvaluatorNode(this.engine, this.targetContainer, rhsIndex, affectedIndices, stub.calibrationPattern.getSize(), evaluator);
        Address<PredicateEvaluatorNode> checker = Address.of(ten);
        this.reteNet.connectRemoteNodes((Address)stub.handle, checker, true);
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(stub, checker);
        return result;
    }

    public ReteContainerBuildable<PatternDescription> getNextContainer() {
        return new ReteContainerBuildable<PatternDescription>(this.engine, this.reteNet.getNextContainer());
    }

    @Override
    public Stub<Address<? extends Supplier>> buildScopeConstrainer(Stub<Address<? extends Supplier>> stub, boolean transitive, Object unwrappedContainer, int constrainedIndex) {
        Address<Supplier> root = transitive ? this.boundary.accessContainmentTransitiveRoot() : this.boundary.accessContainmentRoot();
        Address<ValueBinderFilterNode> filteredRoot = this.targetContainer.getLibrary().accessValueBinderFilterNode(root, 0, this.boundary.wrapElement(unwrappedContainer));
        int[] secondaryIndices = new int[]{1};
        Address<ProjectionIndexer> secondary = this.targetContainer.getLibrary().accessProjectionIndexer(filteredRoot, new TupleMask(secondaryIndices, 2));
        int[] primaryIndices = new int[]{constrainedIndex};
        TupleMask primaryMask = new TupleMask(primaryIndices, stub.calibrationPattern.getSize());
        Address<ProjectionIndexer> primary = this.targetContainer.getLibrary().accessProjectionIndexer((Address)stub.handle, primaryMask);
        stub = new Stub<Address<ExistenceNode>>(stub, this.targetContainer.getLibrary().accessExistenceNode(primary, secondary, false));
        return stub;
    }

    @Override
    public Address<? extends Receiver> patternCollector(PatternDescription pattern) throws RetePatternBuildException {
        return this.engine.getBoundary().createProductionInternal(pattern);
    }
}

