/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.misc;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Network;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.single.SingleInputNode;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Clearable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaMonitor
extends SingleInputNode
implements Clearable {
    public Collection<Tuple> matchFoundEvents = new LinkedHashSet<Tuple>();
    public Collection<Tuple> matchLostEvents = new LinkedHashSet<Tuple>();

    public DeltaMonitor(ReteContainer reteContainer) {
        super(reteContainer);
        reteContainer.registerClearable(this);
    }

    public boolean statelessFilter(Tuple tuple) {
        return true;
    }

    public DeltaMonitor(Network network) {
        this(network.getHeadContainer());
    }

    @Override
    public void update(Direction direction, Tuple updateElement) {
        if (this.statelessFilter(updateElement)) {
            if (direction == Direction.INSERT) {
                if (!this.matchLostEvents.remove(updateElement)) {
                    this.matchFoundEvents.add(updateElement);
                }
            } else if (!this.matchFoundEvents.remove(updateElement)) {
                this.matchLostEvents.add(updateElement);
            }
        }
    }

    @Override
    public void clear() {
        this.matchFoundEvents.clear();
        this.matchLostEvents.clear();
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        throw new UnsupportedOperationException("DeltaMonitor contents cannot be pulled");
    }
}

