/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Direction;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.ReteContainer;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Supplier;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

public abstract class StandardNode
implements Supplier {
    protected ReteContainer reteContainer;
    protected long nodeId;
    protected Object tag;
    protected List<Receiver> children;

    public StandardNode(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
        this.nodeId = reteContainer.registerNode(this);
        this.children = new LinkedList<Receiver>();
    }

    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        for (Receiver r : this.children) {
            this.reteContainer.sendUpdateInternal(r, direction, updateElement);
        }
    }

    public void appendChild(Receiver receiver) {
        this.children.add(receiver);
    }

    public void removeChild(Receiver receiver) {
        this.children.remove(receiver);
    }

    public String toString() {
        if (this.tag != null) {
            return "[" + this.nodeId + "]" + this.getClass().getSimpleName() + "[[" + this.tag.toString() + "]]";
        }
        return "[" + this.nodeId + "]" + this.getClass().getSimpleName();
    }

    public ReteContainer getContainer() {
        return this.reteContainer;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }
}

