/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple;

import java.util.Arrays;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

public class LeftInheritanceTuple
extends Tuple {
    private final int inheritedIndex;
    private final Tuple ancestor;
    private final Object[] localElements;

    public LeftInheritanceTuple(Tuple ancestor, Object[] localElements) {
        this.localElements = localElements;
        this.ancestor = ancestor;
        this.inheritedIndex = ancestor.getSize();
        this.calcHash();
    }

    public int getSize() {
        return this.inheritedIndex + this.localElements.length;
    }

    public Object get(int index) {
        return index < this.inheritedIndex ? this.ancestor.get(index) : this.localElements[index - this.inheritedIndex];
    }

    void calcHash() {
        this.cachedHash = this.ancestor.hashCode();
        int i = 0;
        while (i < this.localElements.length) {
            this.cachedHash *= 31;
            Object element = this.localElements[i];
            if (element != null) {
                this.cachedHash += element.hashCode();
            }
            ++i;
        }
    }

    protected boolean internalEquals(Tuple other) {
        if (other instanceof LeftInheritanceTuple) {
            LeftInheritanceTuple lit = (LeftInheritanceTuple)other;
            if (lit.inheritedIndex == this.inheritedIndex && this.ancestor.equals(lit.ancestor)) {
                return Arrays.equals(this.localElements, lit.localElements);
            }
        }
        return super.internalEquals(other);
    }
}

