/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Clearable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMask;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.TupleMemory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskedTupleMemory
implements Clearable,
Iterable<Tuple> {
    protected Map<Tuple, Collection<Tuple>> matchings;
    protected TupleMask mask;

    public MaskedTupleMemory(TupleMask mask) {
        this.mask = mask;
        this.matchings = new HashMap<Tuple, Collection<Tuple>>();
    }

    public boolean add(Tuple ps) {
        Tuple signature = this.mask.transform(ps);
        return this.add(ps, signature);
    }

    public boolean add(Tuple ps, Tuple signature) {
        boolean change;
        TupleMemory coll = this.matchings.get(signature);
        boolean bl = change = coll == null;
        if (change) {
            coll = new TupleMemory();
            this.matchings.put(signature, coll);
        }
        coll.add((Tuple)ps);
        return change;
    }

    public boolean remove(Tuple ps) {
        Tuple signature = this.mask.transform(ps);
        return this.remove(ps, signature);
    }

    public boolean remove(Tuple ps, Tuple signature) {
        Collection<Tuple> coll = this.matchings.get(signature);
        coll.remove(ps);
        boolean change = coll.isEmpty();
        if (change) {
            this.matchings.remove(signature);
        }
        return change;
    }

    public Collection<Tuple> get(Tuple signature) {
        return this.matchings.get(signature);
    }

    @Override
    public void clear() {
        this.matchings.clear();
    }

    public Collection<Tuple> getSignatures() {
        return this.matchings.keySet();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new MaskedPatternIterator(this);
    }

    public String toString() {
        return "MTM<" + this.mask + "|" + this.matchings + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MaskedPatternIterator
    implements Iterator<Tuple> {
        Iterator<Collection<Tuple>> signatureGroup;
        Iterator<Tuple> element;

        public MaskedPatternIterator(MaskedTupleMemory memory) {
            this.signatureGroup = memory.matchings.values().iterator();
            Set emptySet = Collections.emptySet();
            this.element = emptySet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.element.hasNext() || this.signatureGroup.hasNext();
        }

        @Override
        public Tuple next() throws NoSuchElementException {
            if (this.element.hasNext()) {
                return this.element.next();
            }
            if (this.signatureGroup.hasNext()) {
                this.element = this.signatureGroup.next().iterator();
                return this.element.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }
    }
}

