/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.adapters.GlobalModelspaceListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.boundary.IManipulationListener;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherBuilderContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VPMContext<PatternDescription>
implements IPatternMatcherBuilderContext<PatternDescription>,
IPatternMatcherRuntimeContext<PatternDescription> {
    WeakReference<IFramework> framework;
    IModelManager manager;

    public VPMContext(IFramework framework) {
        this.framework = new WeakReference<IFramework>(framework);
        this.manager = framework.getTopmodel().getModelManager();
    }

    public IPatternMatcherContext.EdgeInterpretation edgeInterpretation() {
        return IPatternMatcherContext.EdgeInterpretation.TERNARY;
    }

    public IPatternMatcherContext.GeneralizationQueryDirection allowedGeneralizationQueryDirection() {
        return IPatternMatcherContext.GeneralizationQueryDirection.BOTH;
    }

    public Collection<? extends Object> enumerateAllUnaries() {
        return this.manager.getEntities();
    }

    public Collection<IPatternMatcherContext.Pair<Object, Object>> enumerateAllBinaryEdges() {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateAllTernaryEdges() {
        return this.manager.getRelations();
    }

    public Collection<? extends Object> enumerateDirectSupertypes(Object typeObject) {
        return ((IModelElement)typeObject).getSupertypes();
    }

    public Collection<? extends Object> enumerateDirectSubtypes(Object typeObject) {
        return ((IModelElement)typeObject).getSubtypes();
    }

    public Collection<? extends Object> enumerateDirectUnaryInstances(Object typeObject) {
        return ((IEntity)typeObject).getInstances();
    }

    public Collection<? extends Object> enumerateDirectUnarySubtypes(Object typeObject) {
        return ((IEntity)typeObject).getSubtypes();
    }

    public Collection<? extends Object> enumerateDirectUnarySupertypes(Object typeObject) {
        return ((IEntity)typeObject).getSupertypes();
    }

    public Collection<IPatternMatcherContext.Pair<Object, Object>> enumerateDirectBinaryEdgeInstances(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateDirectBinaryEdgeSubtypes(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateDirectBinaryEdgeSupertypes(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeInstances(Object typeObject) {
        return ((IRelation)typeObject).getInstances();
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeSubtypes(Object typeObject) {
        return ((IRelation)typeObject).getSubtypes();
    }

    public Collection<? extends Object> enumerateDirectTernaryEdgeSupertypes(Object typeObject) {
        return ((IRelation)typeObject).getSupertypes();
    }

    public IFramework getFramework() {
        return (IFramework)this.framework.get();
    }

    public boolean inputConstructionEmbargo() {
        return false;
    }

    public Object ternaryEdgeSource(Object relation) {
        return ((IRelation)relation).getFrom();
    }

    public Object ternaryEdgeTarget(Object relation) {
        return ((IRelation)relation).getTo();
    }

    public Object ternaryEdgeSourceType(Object typeObject) {
        IRelation relation = (IRelation)typeObject;
        return relation.getIsAnyFrom() ? null : relation.getFrom();
    }

    public Object ternaryEdgeTargetType(Object typeObject) {
        IRelation relation = (IRelation)typeObject;
        return relation.getIsAnyTo() ? null : relation.getTo();
    }

    public Object binaryEdgeSourceType(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Object binaryEdgeTargetType(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public Object retrieveUnaryType(String fullyQualifiedName) {
        return this.manager.getElementByName(fullyQualifiedName);
    }

    public Object retrieveBinaryEdgeType(String fullyQualifiedName) {
        throw new UnsupportedOperationException();
    }

    public Object retrieveTernaryEdgeType(String fullyQualifiedName) {
        return this.manager.getElementByName(fullyQualifiedName);
    }

    public String retrieveUnaryTypeFQN(Object typeObject) {
        return ((IEntity)typeObject).getFullyQualifiedName();
    }

    public String retrieveBinaryEdgeTypeFQN(Object typeObject) {
        throw new UnsupportedOperationException();
    }

    public String retrieveTernaryEdgeTypeFQN(Object typeObject) {
        return ((IRelation)typeObject).getFullyQualifiedName();
    }

    public Object resolveConstant(String fullyQualifiedName) {
        return this.manager.getElementByName(fullyQualifiedName);
    }

    public Collection<IPatternMatcherContext.Pair<Object, Object>> enumerateAllUnaryContainments() {
        LinkedList<IPatternMatcherContext.Pair<Object, Object>> collector = new LinkedList<IPatternMatcherContext.Pair<Object, Object>>();
        for (IEntity container : ((IFramework)this.framework.get()).getTopmodel().getModelManager().getEntities()) {
            for (IModelElement element : container.getContents()) {
                if (!(element instanceof IEntity)) continue;
                collector.add((IPatternMatcherContext.Pair<Object, Object>)new IPatternMatcherContext.Pair((Object)container, (Object)element));
            }
        }
        return collector;
    }

    public Collection<IPatternMatcherContext.Pair<Object, Object>> enumerateAllInstantiations() {
        LinkedList<IPatternMatcherContext.Pair<Object, Object>> collector = new LinkedList<IPatternMatcherContext.Pair<Object, Object>>();
        for (IModelElement type : ((IFramework)this.framework.get()).getTopmodel().getModelManager().getElements()) {
            for (IModelElement instance : type.getInstances()) {
                collector.add((IPatternMatcherContext.Pair<Object, Object>)new IPatternMatcherContext.Pair((Object)type, (Object)instance));
            }
        }
        return collector;
    }

    public Collection<IPatternMatcherContext.Pair<Object, Object>> enumerateAllGeneralizations() {
        LinkedList<IPatternMatcherContext.Pair<Object, Object>> collector = new LinkedList<IPatternMatcherContext.Pair<Object, Object>>();
        for (IModelElement superType : ((IFramework)this.framework.get()).getTopmodel().getModelManager().getElements()) {
            for (IModelElement subType : superType.getSubtypes()) {
                collector.add((IPatternMatcherContext.Pair<Object, Object>)new IPatternMatcherContext.Pair((Object)superType, (Object)subType));
            }
        }
        return collector;
    }

    public void modelReadLock() {
        ((IFramework)this.framework.get()).getTopmodel().getModelManager().getLock().readLock().lock();
    }

    public void modelReadUnLock() {
        ((IFramework)this.framework.get()).getTopmodel().getModelManager().getLock().readLock().unlock();
    }

    public IManipulationListener subscribePatternMatcherForUpdates(ReteEngine<PatternDescription> engine) {
        return new GlobalModelspaceListener(engine, (IFramework)this.framework.get());
    }

    public void logDebug(String message) {
        ((IFramework)this.framework.get()).getLogger().debug(message);
    }

    public void logError(String message) {
        ((IFramework)this.framework.get()).getLogger().error(message);
    }

    public void logError(String message, Throwable cause) {
        ((IFramework)this.framework.get()).getLogger().message(1, message, cause);
    }
}

