/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.simple;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatternNode
implements Comparable<PatternNode> {
    public String name;
    public ModelElement source;
    public boolean isTouched;
    public boolean isVirtual;
    public boolean isExemptFromInjectivity = false;
    public int lingeringTypeInfoCounter;
    public LinkedList<Object> assertedTypes;
    public HashSet<Object> impliedTypes;

    private PatternNode(String name, boolean isVirtual, boolean isTouched) {
        this.name = name;
        this.source = null;
        this.isVirtual = isVirtual;
        this.isTouched = isTouched;
        this.assertedTypes = new LinkedList();
        this.impliedTypes = new HashSet();
        this.lingeringTypeInfoCounter = 0;
    }

    private PatternNode(String name) {
        this(name, false, false);
    }

    public PatternNode(Variable variable) {
        this(variable.getName());
    }

    public PatternNode(int newId) {
        this(".virtual{" + newId + "}", true, true);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isExemptFromInjectivity() {
        return this.isVirtual || this.isExemptFromInjectivity;
    }

    public void makeExemptFromInjectivity() {
        this.isExemptFromInjectivity = true;
    }

    public void setSource(ModelElement source) {
        this.source = source;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternNode other = (PatternNode)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(PatternNode arg0) {
        return this.name.compareTo(arg0.name);
    }

    public String toString() {
        return this.name;
    }
}

