/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.trigger.engine;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra2.codegen.CodeOutputPlugin;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectTransactionEnd;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.IMachineSetChangedListener;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.ASMFunctionContent;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.EngineManager;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.ReteEngine;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.matcher.RetePatternMatcher;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.misc.DeltaMonitor;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.network.Receiver;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;
import org.eclipse.viatra2.gtasm.trigger.engine.ITriggerSetChangedListener;
import org.eclipse.viatra2.gtasm.trigger.engine.TriggerExecutionEnvironment;
import org.eclipse.viatra2.gtasm.trigger.model.Trigger;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.RuntimeAnnotationElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.InitialValue;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerExecutionEngine
implements ICoreNotificationListener,
IMachineSetChangedListener {
    protected IFramework fw;
    protected ReteEngine<GTPattern> re = null;
    protected HashSet<Trigger> triggers;
    protected HashSet<ITriggerSetChangedListener> trigger_set_listeners;
    protected boolean trigger_running_flag;
    protected boolean serialExecutionMode;

    public TriggerExecutionEngine(IFramework afw) {
        this.fw = afw;
        this.triggers = new HashSet();
        this.trigger_set_listeners = new HashSet();
        this.fw.getTopmodel().getNotificationManager().addAllListener((ICoreNotificationListener)this);
        this.fw.addMachineSetListener((IMachineSetChangedListener)this);
        this.trigger_running_flag = false;
        this.serialExecutionMode = true;
    }

    private ReteEngine<GTPattern> getReteEngine() {
        if (this.re == null) {
            this.re = EngineManager.getInstance().getReteEngine(this.fw);
        }
        return this.re;
    }

    public void initTrigger(Machine current) {
        boolean anyImport = false;
        EList gtrules = current.getGtRuleDefinitions();
        for (Object obj : gtrules) {
            GTRule gtrule = (GTRule)obj;
            EList runtimeAnnotations = gtrule.getRuntimeAnnotations();
            for (Object obj1 : runtimeAnnotations) {
                RuntimeAnnotation ran = (RuntimeAnnotation)obj1;
                if (!ran.getAnnotationName().equals("@Trigger")) continue;
                Trigger input = new Trigger(gtrule.getName());
                anyImport = true;
                input.setMachine(current);
                input.setGtrule(gtrule);
                boolean isRunnable = false;
                EList annotations = ran.getElements();
                for (Object obj2 : annotations) {
                    RuntimeAnnotationElement ranElement = (RuntimeAnnotationElement)obj2;
                    String key = ranElement.getKey();
                    String value = ranElement.getValue();
                    if (key.equals("priority")) {
                        try {
                            int p = Integer.parseInt(value);
                            input.setPriority(p);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.fw.getLogger().info("Trigger engine: the " + input.getName() + " trigger's priority annotation is not a valid integer number.");
                        }
                    }
                    if (key.equals("mode")) {
                        if (value.equals("always")) {
                            input.setMode("always");
                        }
                        if (value.equals("once")) {
                            input.setMode("once");
                        }
                    }
                    if (key.equals("sensitivity")) {
                        if (value.equals("rise")) {
                            input.setSensitivity("rise");
                        }
                        if (value.equals("fall")) {
                            input.setSensitivity("fall");
                        }
                    }
                    if (key.equals("startup")) {
                        if (value.equals("active")) {
                            input.setStartup("active");
                        }
                        if (value.equals("passive")) {
                            input.setStartup("passive");
                        }
                    }
                    if (key.equals("execution")) {
                        if (value.equals("forall")) {
                            input.setExecution("forall");
                        }
                        if (value.equals("iterate")) {
                            input.setExecution("iterate");
                        }
                    }
                    if (!key.equals("autoStart") || !value.equals("true")) continue;
                    isRunnable = true;
                }
                this.addTrigger(input);
                if (!isRunnable) continue;
                this.startTrigger(input);
            }
        }
        if (anyImport) {
            this.actionPerformed((ICoreNotificationObject)new NotificationObjectTransactionEnd());
        }
    }

    public void initTriggerRete(Trigger input) {
        RetePatternMatcher rpm = null;
        try {
            rpm = this.getReteEngine().accessMatcher((Object)input.getGtrule().getPrecondition().getCalledPattern());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DeltaMonitor dm = new DeltaMonitor(this.re.getReteNet());
        if (input.getStartup().equals("active")) {
            rpm.connect((Receiver)dm, true);
        } else {
            rpm.connect((Receiver)dm, false);
        }
        input.setReceiver(dm);
        input.setRetepatternmatcher(rpm);
        input.setReteEngineSet(true);
    }

    public void initTriggerASMFunctions(Trigger input) {
        TriggerExecutionEnvironment ee = new TriggerExecutionEnvironment(this.fw);
        for (Object o : input.getMachine().getAsmFunctionDefinitions()) {
            ASMFunction fun = (ASMFunction)o;
            HashMap<BasicEList, Object> map = new HashMap<BasicEList, Object>();
            for (Object o2 : fun.getInitialValues()) {
                InitialValue initialValue = (InitialValue)o2;
                try {
                    BasicEList locationsList = new BasicEList();
                    for (Object o3 : initialValue.getLocations()) {
                        Term locationsTerm = (Term)o3;
                        locationsList.add(TermEvaluator.getInstance().evaluate((IExecutionEnvironment)ee, locationsTerm));
                    }
                    map.put(locationsList, TermEvaluator.getInstance().evaluate((IExecutionEnvironment)ee, initialValue.getValue()));
                }
                catch (ViatraTransformationException e) {
                    e.printStackTrace();
                }
            }
            if (ASMFunctionContent.getInstance().containsKey((Object)fun)) continue;
            ASMFunctionContent.getInstance().put((Object)fun, map);
        }
        input.setASMFunctionsSet(true);
    }

    public void startTrigger(Trigger input) {
        if (!input.isReteEngineSet()) {
            this.initTriggerRete(input);
        }
        input.setRunning(true);
        for (ITriggerSetChangedListener tsl : this.trigger_set_listeners) {
            tsl.triggerRefreshed(input);
        }
    }

    public void startTriggerWithCommit(Trigger input) {
        this.startTrigger(input);
        this.actionPerformed((ICoreNotificationObject)new NotificationObjectTransactionEnd());
    }

    public void stopTrigger(Trigger input) {
        input.setRunning(false);
        for (ITriggerSetChangedListener tsl : this.trigger_set_listeners) {
            tsl.triggerRefreshed(input);
        }
    }

    public void addTrigger(Trigger input) {
        for (Trigger trigger : this.triggers) {
            if (!trigger.getName().equals(input.getName())) continue;
            this.deleteTrigger(trigger);
            break;
        }
        this.triggers.add(input);
        for (ITriggerSetChangedListener tsl : this.trigger_set_listeners) {
            tsl.triggerAdded(input);
        }
        this.fw.getLogger().info("Trigger engine: the " + input.getName() + " trigger has been imported.");
    }

    public void deleteTrigger(Trigger input) {
        this.triggers.remove(input);
        for (ITriggerSetChangedListener tsl : this.trigger_set_listeners) {
            tsl.triggerRemoved(input);
        }
        this.fw.getLogger().info("Trigger engine: the " + input.getName() + " trigger has been removed.");
    }

    public void runTriggerAction(IFramework fw, final Trigger input, Tuple ps) {
        TriggerExecutionEnvironment ee = new TriggerExecutionEnvironment(fw);
        HashMap params = input.getRetepatternmatcher().getPosMapping();
        params.keySet();
        try {
            for (SymbolicRuleParameter param : input.getGtrule().getSymParameters()) {
                ee.addVariable(param.getVariable(), ValueKind.UNDEF_LITERAL);
            }
            EList actpars = input.getGtrule().getPrecondition().getActualParameters();
            int pos = 0;
            for (Object _o : actpars) {
                Object value = ps.get(pos++);
                VariableReference ref = (VariableReference)_o;
                Variable var = ref.getVariable();
                if (!ee.getVariableValues().keySet().contains(var)) {
                    ee.addVariable(var, value);
                    continue;
                }
                ee.setVariableValue(var, value);
            }
            ASMRuleInvocation asmri = input.getGtrule().getAction();
            RuleInterpreter.initInterpreters((Logger)fw.getLogger(), (CodeOutputPlugin)fw.getCodeOutput());
            fw.getTopmodel().getTransactionManager().beginTransaction();
            try {
                RuleInterpreter.getInstance().interpretRule((IExecutionEnvironment)ee, asmri, null);
            }
            finally {
                fw.getTopmodel().getTransactionManager().commitTransaction();
            }
        }
        catch (ViatraTransformationException e) {
            fw.getLogger().message(1, e.getMessage(), (Throwable)e);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"VIATRA2 R3", (String)("Error executing trigger " + input.getName() + ": " + e.getMessage() + " (see the Error Log view for details)"));
                }
            });
        }
    }

    public void runTrigger(Trigger triggertorun) {
        if (triggertorun.getExecution().equals("forall")) {
            Tuple ps;
            if (triggertorun.getSensitivity().equals("rise")) {
                while (triggertorun.getReceiver().matchFoundEvents.iterator().hasNext()) {
                    ps = (Tuple)triggertorun.getReceiver().matchFoundEvents.iterator().next();
                    triggertorun.getReceiver().matchFoundEvents.remove(ps);
                    this.runTriggerAction(this.fw, triggertorun, ps);
                }
            }
            if (triggertorun.getSensitivity().equals("fall")) {
                while (triggertorun.getReceiver().matchLostEvents.iterator().hasNext()) {
                    ps = (Tuple)triggertorun.getReceiver().matchLostEvents.iterator().next();
                    triggertorun.getReceiver().matchLostEvents.remove(ps);
                    this.runTriggerAction(this.fw, triggertorun, ps);
                }
            }
        } else if (triggertorun.getExecution().equals("iterate")) {
            Tuple ps;
            if (triggertorun.getSensitivity().equals("rise") && triggertorun.getReceiver().matchFoundEvents.iterator().hasNext()) {
                ps = (Tuple)triggertorun.getReceiver().matchFoundEvents.iterator().next();
                triggertorun.getReceiver().matchFoundEvents.remove(ps);
                this.runTriggerAction(this.fw, triggertorun, ps);
            }
            if (triggertorun.getSensitivity().equals("fall") && triggertorun.getReceiver().matchLostEvents.iterator().hasNext()) {
                ps = (Tuple)triggertorun.getReceiver().matchLostEvents.iterator().next();
                triggertorun.getReceiver().matchLostEvents.remove(ps);
                this.runTriggerAction(this.fw, triggertorun, ps);
            }
        }
    }

    public void execute_serial() {
        Trigger triggertorun = null;
        for (Trigger tr : this.triggers) {
            if (!tr.isRunning()) continue;
            if (!tr.getReceiver().matchFoundEvents.isEmpty() && tr.getSensitivity().equals("rise")) {
                if (triggertorun == null) {
                    triggertorun = tr;
                } else if (tr.getPriority() > triggertorun.getPriority()) {
                    triggertorun = tr;
                }
            }
            if (tr.getReceiver().matchLostEvents.isEmpty() || !tr.getSensitivity().equals("fall")) continue;
            if (triggertorun == null) {
                triggertorun = tr;
                continue;
            }
            if (tr.getPriority() <= triggertorun.getPriority()) continue;
            triggertorun = tr;
        }
        if (triggertorun != null) {
            if (!triggertorun.isASMFunctionsSet()) {
                this.initTriggerASMFunctions(triggertorun);
            }
            this.runTrigger(triggertorun);
            if (triggertorun.getMode().equals("once")) {
                this.deleteTrigger(triggertorun);
            }
        }
    }

    public void execute_parallel() {
        HashSet<Trigger> triggertorunlist = new HashSet<Trigger>();
        for (Trigger tr : this.triggers) {
            if (!tr.isRunning()) continue;
            if (!tr.getReceiver().matchFoundEvents.isEmpty() && tr.getSensitivity().equals("rise")) {
                triggertorunlist.add(tr);
            }
            if (tr.getReceiver().matchLostEvents.isEmpty() || !tr.getSensitivity().equals("fall")) continue;
            triggertorunlist.add(tr);
        }
        for (Trigger triggertorun : triggertorunlist) {
            if (!triggertorun.isASMFunctionsSet()) {
                this.initTriggerASMFunctions(triggertorun);
            }
            this.runTrigger(triggertorun);
            if (!triggertorun.getMode().equals("once")) continue;
            this.deleteTrigger(triggertorun);
        }
    }

    public void actionPerformed(ICoreNotificationObject notification) {
        if ((notification.getActionType().equals("begin transaction") || notification.getActionType().equals("begin undoable transaction")) && !this.trigger_running_flag) {
            for (Trigger tr : this.triggers) {
                if (!tr.isRunning()) continue;
                tr.getReceiver().clear();
            }
            this.fw.getLogger().info("Trigger engine: Receiver cleared.");
        }
        if (notification.getActionType().equals("end transaction") || notification.getActionType().equals("end undo")) {
            this.fw.getLogger().info("Trigger engine: A transactional operation ended in the system.");
            if (!this.triggers.isEmpty()) {
                this.getReteEngine().settle();
                this.trigger_running_flag = true;
                if (this.serialExecutionMode) {
                    this.execute_serial();
                } else {
                    this.execute_parallel();
                }
                this.trigger_running_flag = false;
            }
        }
    }

    public int getListenerCategory() {
        return 0;
    }

    public HashSet<Trigger> getTriggers() {
        return this.triggers;
    }

    public void addTriggerSetListener(ITriggerSetChangedListener l) {
        if (!this.trigger_set_listeners.contains(l)) {
            this.trigger_set_listeners.add(l);
        }
    }

    public void removeTriggerSetListener(ITriggerSetChangedListener l) {
        this.trigger_set_listeners.remove(l);
    }

    public boolean isSerialExecutionMode() {
        return this.serialExecutionMode;
    }

    public void setSerialExecutionMode(boolean serialExecutionMode) {
        this.serialExecutionMode = serialExecutionMode;
    }

    public boolean isTrigger_running_flag() {
        return this.trigger_running_flag;
    }

    public void machineAdded(Object objMachine) {
        Machine machine = (Machine)objMachine;
        this.fw.getLogger().info("Trigger engine: The " + machine.getName() + " machine has been added to the system.");
        this.initTrigger(machine);
    }

    public void machineRemoved(Object objMachine) {
        Machine machine = (Machine)objMachine;
        this.fw.getLogger().info("Trigger engine: The " + machine.getName() + " machine has been removed from the system.");
    }
}

