/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.trigger.natives;

import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.gtasm.trigger.engine.TriggerEngineManager;
import org.eclipse.viatra2.gtasm.trigger.engine.TriggerExecutionEngine;
import org.eclipse.viatra2.gtasm.trigger.model.Trigger;
import org.eclipse.viatra2.natives.ASMNativeFunction;

public class StopTriggerFunction
implements ASMNativeFunction {
    public Object evaluate(IModelSpace msp, Object[] params) throws VPMRuntimeException {
        String name = (String)params[0];
        boolean founded = false;
        TriggerExecutionEngine single = TriggerEngineManager.getInstance().getTriggerEngine(msp.getFramework());
        for (Trigger trigger : single.getTriggers()) {
            if (!trigger.getName().equals(name)) continue;
            founded = true;
            single.stopTrigger(trigger);
        }
        if (founded) {
            return "stopTrigger: the " + name + " trigger stopped.";
        }
        return "stopTrigger: the " + name + " trigger can not be found.";
    }

    public String getDescription() {
        return "Stops a trigger in the trigger execution engine";
    }

    public String getID() {
        return "org.eclipse.viatra2.gtasm.trigger.natives.StopTriggerFunction";
    }

    public String getName() {
        return "stopTrigger";
    }
}

