/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.loader;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.loaders.Loader;
import org.eclipse.viatra2.logger.Logger;
import org.eclipse.viatra2.lpgparser.loader.VTCLParseController;
import org.eclipse.viatra2.lpgparser.loader.VTCLParserManager;

public class LPGVTCLLoader
implements Loader {
    public void process(InputStream f, IFramework fw) throws VPMRuntimeException {
    }

    protected void loadNativeFunctions(IFramework framework) {
    }

    public void processFile(String fileName, IFramework framework) throws VPMRuntimeException {
        VTCLParserManager parserManager = (VTCLParserManager)framework.getVTCLParserManager();
        VTCLParseController parseController = parserManager.lookupAndCreateParseController(fileName);
        Logger log = framework.getLogger();
        try {
            parseController.parseAndBuild();
            if (parseController.getErrors().size() == 0) {
                String msg = "Parsing completed successfully. Transformation " + parseController.getMachine().getName() + " can now be executed in the VIATRA Frameworks view";
                log.info(msg);
                Machine m = parseController.getMachine();
                framework.addMachine(m.getFqn(), (Object)m);
            } else {
                boolean hasErrors = false;
                Iterator<ErrorInformation> it1 = parseController.getErrors().iterator();
                while (!hasErrors && it1.hasNext()) {
                    ErrorInformation error = it1.next();
                    if (error.getErrorSeverity().compareTo((Enum)ErrorInformation.ErrorSeverity.ERROR) != 0) continue;
                    hasErrors = true;
                }
                if (!hasErrors) {
                    String msg = "Parsing completed, but there are some warnings in the Error Log. Transformation " + parseController.getMachine().getName() + " can now be executed in the VIATRA Frameworks view";
                    log.info(msg);
                    Machine m = parseController.getMachine();
                    framework.addMachine(m.getFqn(), (Object)m);
                }
                List<ErrorInformation> errorList = parseController.getErrors();
                int i = 0;
                while (i < errorList.size()) {
                    ErrorInformation errorInfo = errorList.get(i);
                    String errorMsg = errorInfo.getMessageWithLocation();
                    ErrorInformation.ErrorSeverity errorSeverity = errorInfo.getErrorSeverity();
                    switch (errorSeverity) {
                        case ERROR: {
                            log.error(errorMsg);
                            break;
                        }
                        case WARNING: {
                            log.warning(errorMsg);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

