/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.modelbuilder;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.simple.UniqueNameProvider;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.errors.info.Location;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.BlockRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.CompoundRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.compoundRules.NestedRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.Annotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.GTASMElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ImportDeclaration;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.InitialValue;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Machine;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Module;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.TypeConstant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.CallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ConditionalRuleIf;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ConditionalRuleTry;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.GTRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdateASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ASMFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GtFactory;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariableAssignment;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariableConstraint;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.ElementCreateRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.EntityCreateRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.RelationCreateRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.queryFunctions.ElementReference;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.EditmodelFactory;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relationship;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.SupertypeOf;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.TypeOf;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.VPMElement;
import org.eclipse.viatra2.lpgparser.typechecker.TypeResolver;
import org.eclipse.viatra2.natives.ASMNativeFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VTCLModelResolver {
    private static final String PARSER_MARKER = "org.eclipse.viatra2.loaders.vtclparsermarker";
    private ASMNativeFunction[] asmNativeFunctions;
    private IModelSpace modelSpace;
    private IModelManager modelManager;
    private TypeResolver typeResolver;
    private UniqueNameProvider uniqueNameProvider;
    private Machine storedMachine;
    private List<ErrorInformation> referenceResolutionErrorInfos = new ArrayList<ErrorInformation>();
    private Map<GTPatternBody, List<VPMElement>> orphanBodyElements = new HashMap<GTPatternBody, List<VPMElement>>();
    private Stack<List<VariableReference>> unresolvedVariableRefsStack = new Stack();
    private List<GTPatternCall> unresolvedPatternCalls = new ArrayList<GTPatternCall>();
    private List<RuleUpdateASMFunction> unresolvedAsmFunctionUpdates = new ArrayList<RuleUpdateASMFunction>();
    private List<ASMFunctionInvocation> unresolvedAsmFunctionInvocations = new ArrayList<ASMFunctionInvocation>();
    private List<CallRule> unresolvedAsmRuleCalls = new ArrayList<CallRule>();
    private List<GTRuleInvocation> unresolvedGTRuleInvoc = new ArrayList<GTRuleInvocation>();
    private Map<GTPatternBody, List<VariableReference>> unresolvedPatternVariableRefs = new HashMap<GTPatternBody, List<VariableReference>>();
    private Map<GTPatternBody, Map<PatternVariable, ModelElement>> bodyMapElement2Var = new HashMap<GTPatternBody, Map<PatternVariable, ModelElement>>();
    private Map<GTPatternBody, Map<ModelElement, PatternVariable>> bodyMapVar2Element = new HashMap<GTPatternBody, Map<ModelElement, PatternVariable>>();
    private Map<ASMRuleInvocation, GTRule> actionRuleMap = new HashMap<ASMRuleInvocation, GTRule>();

    public VTCLModelResolver() {
        this.modelSpace = null;
        this.modelManager = null;
        this.asmNativeFunctions = null;
        this.typeResolver = new TypeResolver();
        this.uniqueNameProvider = null;
    }

    public VTCLModelResolver(IModelSpace aModelSpace, ASMNativeFunction[] allAsmNativeFunctions) {
        this.modelSpace = aModelSpace;
        this.modelManager = this.modelSpace.getModelManager();
        this.asmNativeFunctions = allAsmNativeFunctions;
        this.typeResolver = new TypeResolver();
        this.uniqueNameProvider = new UniqueNameProvider();
    }

    public IModelSpace getModelSpace() {
        return this.modelSpace;
    }

    public IModelManager getModelManager() {
        return this.modelManager;
    }

    public ASMNativeFunction[] getNativeFunctions() {
        return this.asmNativeFunctions;
    }

    public Machine getMachine() {
        return this.storedMachine;
    }

    public void setMachine(Machine machine) {
        this.storedMachine = machine;
    }

    public void clearBuffers() {
        this.unresolvedPatternCalls.clear();
        this.unresolvedAsmFunctionInvocations.clear();
        this.unresolvedAsmFunctionUpdates.clear();
        this.unresolvedAsmRuleCalls.clear();
        this.unresolvedGTRuleInvoc.clear();
    }

    public void resolveModel() {
        this.resolvePatternCalls(this.storedMachine);
        this.resolveAsmFunInvocations(this.storedMachine);
        this.resolveAsmFunUpdates(this.storedMachine);
        this.resolveAsmRulesInvocations(this.storedMachine);
        this.resolveGTRuleInvocations(this.storedMachine);
        this.validateDistinctVariables(this.storedMachine);
        this.validateNoDuplicateNames(this.storedMachine);
    }

    public List<ErrorInformation> getAllReferenceErrorInfos() {
        return this.referenceResolutionErrorInfos;
    }

    public void clearAllReferenceErrors() {
        this.referenceResolutionErrorInfos.clear();
    }

    public List<VPMElement> getOrphanBodyElements(GTPatternBody body) {
        if (this.orphanBodyElements.get(body) == null) {
            ArrayList<VPMElement> list = new ArrayList<VPMElement>();
            this.orphanBodyElements.put(body, list);
            return list;
        }
        return this.orphanBodyElements.get(body);
    }

    public Stack<List<VariableReference>> getUnresolvedVariableRefsStack() {
        return this.unresolvedVariableRefsStack;
    }

    public void addVariableReferenceToStack(VariableReference varRef) {
        try {
            this.unresolvedVariableRefsStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.unresolvedVariableRefsStack.push(new ArrayList());
        }
        this.unresolvedVariableRefsStack.peek().add(varRef);
    }

    public List<GTPatternCall> getUnresolvedPatternCalls() {
        return this.unresolvedPatternCalls;
    }

    public List<RuleUpdateASMFunction> getUnresolvedAsmFunctionUpdates() {
        return this.unresolvedAsmFunctionUpdates;
    }

    public List<ASMFunctionInvocation> getUnresolvedAsmFunctionInvocations() {
        return this.unresolvedAsmFunctionInvocations;
    }

    public List<CallRule> getUnresolvedAsmRuleCalls() {
        return this.unresolvedAsmRuleCalls;
    }

    public List<GTRuleInvocation> getUnresolvedGTRuleInvoc() {
        return this.unresolvedGTRuleInvoc;
    }

    public List<VariableReference> getUnresolvedPatternVariableRefs(GTPatternBody body) {
        if (this.unresolvedPatternVariableRefs.get(body) == null) {
            ArrayList<VariableReference> list = new ArrayList<VariableReference>();
            this.unresolvedPatternVariableRefs.put(body, list);
            return list;
        }
        return this.unresolvedPatternVariableRefs.get(body);
    }

    public Map<PatternVariable, ModelElement> getBodyMapElement4Var(GTPatternBody body) {
        if (this.bodyMapElement2Var.get(body) == null) {
            HashMap<PatternVariable, ModelElement> map = new HashMap<PatternVariable, ModelElement>();
            this.bodyMapElement2Var.put(body, map);
            return map;
        }
        return this.bodyMapElement2Var.get(body);
    }

    public Map<ModelElement, PatternVariable> getBodyMapVar4Element(GTPatternBody body) {
        if (this.bodyMapVar2Element.get(body) == null) {
            HashMap<ModelElement, PatternVariable> map = new HashMap<ModelElement, PatternVariable>();
            this.bodyMapVar2Element.put(body, map);
            return map;
        }
        return this.bodyMapVar2Element.get(body);
    }

    public Map<ASMRuleInvocation, GTRule> getActionRuleMap() {
        return this.actionRuleMap;
    }

    public void resolveNamespaceImport(ImportDeclaration declaration) {
        if (this.modelManager.getElementByName(declaration.getImportValue()) == null) {
            String[] context = new String[]{declaration.getImportValue()};
            this.addReferenceResolutionError((List<?>)declaration.getAnnotations(), "Import declaration '{1}' is unresolvable", ErrorInformation.ErrorSeverity.ERROR, context);
        }
    }

    public Variable resolveLocalVariableInGTRule(VariableReference varRef, GTRule rule) {
        Variable varDef = this.lookupVariableDefByName(varRef.getName(), rule);
        if (varDef != null) {
            varRef.setVariable(varDef);
        } else {
            varDef = this.createPatternVariableFromReference(varRef, (List)rule.getLocalVariables());
            Annotation annotation = this.lookupAnnotation("node_info", (List<?>)varRef.getAnnotations());
            if (annotation != null) {
                varDef.getAnnotations().add((Object)annotation);
            }
        }
        return varDef;
    }

    public PatternVariable resolveLocalVariableInPattern(VariableReference varRef, GTPatternBody body) {
        PatternVariable varDef = this.lookupVariableDefByName(varRef.getName(), body);
        if (varDef != null) {
            varRef.setVariable((Variable)varDef);
        } else {
            varDef = this.createPatternVariableFromReference(varRef, (List)body.getLocalVariables());
            Annotation annotation = this.lookupAnnotation("node_info", (List<?>)varRef.getAnnotations());
            if (annotation != null) {
                varDef.getAnnotations().add((Object)annotation);
            }
        }
        return varDef;
    }

    public void resolvePatternVariableRefs(GTPatternBody body) {
        List<VariableReference> list = this.getUnresolvedPatternVariableRefs(body);
        for (VariableReference varRef : list) {
            PatternVariable varDef = this.lookupVariableDefByName(varRef.getName(), body);
            if (varDef != null) {
                varRef.setVariable((Variable)varDef);
                continue;
            }
            String[] context = new String[]{varRef.getName()};
            this.addReferenceResolutionError((List<?>)varRef.getAnnotations(), "Variable Reference '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
    }

    public PatternVariable createPatternVariableFromReference(VariableReference varRef, List list) {
        PatternVariable varDef = GtFactory.eINSTANCE.createPatternVariable();
        varRef.setVariable((Variable)varDef);
        if (varRef.getName().charAt(0) == '_') {
            varDef.setName(this.uniqueNameProvider.uniqueName("Var"));
        } else {
            varDef.setName(varRef.getName());
        }
        list.add(varDef);
        return varDef;
    }

    public void resolveModelElementReferences(GTPatternBody body) {
        List<VPMElement> orphanElements = this.getOrphanBodyElements(body);
        for (VPMElement object : orphanElements) {
            SupertypeOf relship;
            if (object instanceof Relation) {
                Relation relation = (Relation)object;
                this.resolveRelationReferences(relation, body);
                continue;
            }
            if (object instanceof SupertypeOf) {
                relship = (SupertypeOf)object;
                this.resolveRelationshipReferences((Relationship)relship, body);
                continue;
            }
            if (!(object instanceof TypeOf)) continue;
            relship = (TypeOf)object;
            this.resolveRelationshipReferences((Relationship)relship, body);
        }
    }

    private void resolveRelationReferences(Relation relation, GTPatternBody body) {
        PatternVariable srcVar = this.lookupVariableDefByName(relation.getFromStr(), body);
        if (srcVar != null && this.bodyMapElement2Var.get(body).get(srcVar) != null) {
            ModelElement srcElem = this.bodyMapElement2Var.get(body).get(srcVar);
            relation.setFrom(srcElem);
            VariableReference srcRef = (VariableReference)relation.getVariableReferences().get(1);
            srcRef.setVariable((Variable)srcVar);
        } else if (srcVar != null && this.bodyMapElement2Var.get(body).get(srcVar) == null) {
            body.getDanglingRelations().add((Object)relation);
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relation.getFromStr(), (VPMElement)relation).getAnnotations(), "Source end of Relation cannot be resolved locally ", ErrorInformation.ErrorSeverity.WARNING, new String[0]);
        } else {
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relation.getFromStr(), (VPMElement)relation).getAnnotations(), "Source end of Relation cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
        }
        PatternVariable trgVar = this.lookupVariableDefByName(relation.getToStr(), body);
        if (trgVar != null && this.bodyMapElement2Var.get(body).get(trgVar) != null) {
            ModelElement trgElem = this.bodyMapElement2Var.get(body).get(trgVar);
            relation.setTo(trgElem);
            VariableReference trgRef = (VariableReference)relation.getVariableReferences().get(2);
            trgRef.setVariable((Variable)trgVar);
        } else if (trgVar != null && this.bodyMapElement2Var.get(body).get(trgVar) == null) {
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relation.getToStr(), (VPMElement)relation).getAnnotations(), "Target end of Relation cannot be resolved locally ", ErrorInformation.ErrorSeverity.WARNING, new String[0]);
        } else {
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relation.getToStr(), (VPMElement)relation).getAnnotations(), "Target end of Relation cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
        }
    }

    private void resolveRelationshipReferences(Relationship relship, GTPatternBody body) {
        PatternVariable clientVar = this.lookupVariableDefByName(relship.getClientStr(), body);
        if (clientVar != null && this.bodyMapElement2Var.get(body).get(clientVar) != null) {
            ModelElement clientElem = this.bodyMapElement2Var.get(body).get(clientVar);
            relship.setClient(clientElem);
            VariableReference clientRef = (VariableReference)relship.getVariableReferences().get(1);
            clientRef.setVariable((Variable)clientVar);
        } else if (clientVar != null && this.bodyMapElement2Var.get(body).get(clientVar) == null) {
            body.getDanglingRelationships().add((Object)relship);
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relship.getClientStr(), (VPMElement)relship).getAnnotations(), "Client (instance or subtype) end of Relationship cannot be resolved locally ", ErrorInformation.ErrorSeverity.WARNING, new String[0]);
        } else {
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relship.getClientStr(), (VPMElement)relship).getAnnotations(), "Client (instance or subtype) end  of Relationship cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
        }
        PatternVariable supplierVar = this.lookupVariableDefByName(relship.getSupplierStr(), body);
        if (supplierVar != null && this.bodyMapElement2Var.get(body).get(supplierVar) != null) {
            ModelElement supplierElem = this.bodyMapElement2Var.get(body).get(supplierVar);
            relship.setSupplier(supplierElem);
            VariableReference supplierRef = (VariableReference)relship.getVariableReferences().get(0);
            supplierRef.setVariable((Variable)supplierVar);
        } else if (supplierVar != null && this.bodyMapElement2Var.get(body).get(supplierVar) == null) {
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relship.getSupplierStr(), (VPMElement)relship).getAnnotations(), "Supplier (type or supertype) end of Relationship cannot be resolved locally ", ErrorInformation.ErrorSeverity.WARNING, new String[0]);
        } else {
            this.addReferenceResolutionError((List<?>)this.lookupVariableRefByName(relship.getSupplierStr(), (VPMElement)relship).getAnnotations(), "Supplier (type or supertype) end of Relationship cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
        }
    }

    public void addReferenceResolutionError(List<?> annotations, String errorString, ErrorInformation.ErrorSeverity errorSeverity, String[] context) {
        Annotation locInfo = this.lookupAnnotation("node_info", annotations);
        Location location = new Location(locInfo != null ? locInfo.getValue() : "0,0,0,0");
        ErrorInformation errorInfo = new ErrorInformation(errorString, PARSER_MARKER, ErrorInformation.ErrorKind.VALIDATION_ERROR, location, errorSeverity);
        errorInfo.bind(context);
        this.referenceResolutionErrorInfos.add(errorInfo);
    }

    public void storeVarDefForModelElement(GTPatternBody body, PatternVariable varDef, ModelElement me) {
        if (this.getBodyMapElement4Var(body).get(varDef) == null) {
            this.getBodyMapElement4Var(body).put(varDef, me);
        } else {
            String[] context = new String[]{varDef.getName()};
            this.addReferenceResolutionError((List<?>)varDef.getAnnotations(), "Duplicate definition of pattern variable '{1}'", ErrorInformation.ErrorSeverity.ERROR, context);
        }
        this.getBodyMapVar4Element(body).put(me, varDef);
    }

    public GTPattern reportGtPatternCallResolutionError(GTPatternCall call, GTPattern patternDef, IFramework fw) {
        String[] context;
        String machineStr;
        Machine extMachine;
        int lastDotIndex;
        String nameStr = call.getFqn();
        int callArity = call.getActualParameters().size();
        if (patternDef == null && (lastDotIndex = nameStr.lastIndexOf(".")) != -1 && (extMachine = (Machine)fw.getMachineByFQN(machineStr = nameStr.substring(0, lastDotIndex))) != null) {
            patternDef = this.lookupGTPattern(nameStr, callArity, extMachine);
        }
        if (patternDef != null) {
            if (patternDef.getSymParameters().size() == call.getActualParameters().size()) {
                call.setCalledPattern(patternDef);
            } else {
                String arity = String.valueOf(patternDef.getSymParameters().size());
                context = new String[]{String.valueOf(patternDef.getFqn()) + "/" + arity};
                this.addReferenceResolutionError((List<?>)call.getAnnotations(), "Parameter mismatch in pattern call. Expecting '{1}' ", ErrorInformation.ErrorSeverity.ERROR, context);
            }
        } else {
            String arity = String.valueOf(call.getActualParameters().size());
            context = new String[]{String.valueOf(call.getFqn()) + "/" + arity};
            this.addReferenceResolutionError((List<?>)call.getAnnotations(), "Pattern Call '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
        return patternDef;
    }

    public void resolvePatternCalls(Machine machine) {
        List<GTPatternCall> list = this.getUnresolvedPatternCalls();
        for (GTPatternCall call : list) {
            String nameStr = call.getFqn();
            int arity = call.getActualParameters().size();
            GTPattern patternDef = this.lookupGTPattern(nameStr, arity, machine);
            this.reportGtPatternCallResolutionError(call, patternDef, this.modelSpace.getFramework());
        }
    }

    public GTRule reportGtRuleResolutionError(GTRuleInvocation gtInvoc, GTRule gtRuleDef, IFramework fw) {
        String[] context;
        String machineStr;
        Machine extMachine;
        int lastDotIndex;
        String nameStr = gtInvoc.getFqn();
        int callArity = gtInvoc.getActualParameters().size();
        if (gtRuleDef == null && (lastDotIndex = nameStr.lastIndexOf(".")) != -1 && (extMachine = (Machine)fw.getMachineByFQN(machineStr = nameStr.substring(0, lastDotIndex))) != null) {
            gtRuleDef = this.lookupGTRule(nameStr, callArity, extMachine);
        }
        if (gtRuleDef != null) {
            if (gtRuleDef.getSymParameters().size() == gtInvoc.getActualParameters().size()) {
                gtInvoc.setRule(gtRuleDef);
            } else {
                String arity = String.valueOf(gtRuleDef.getSymParameters().size());
                context = new String[]{String.valueOf(gtRuleDef.getName()) + "/" + arity};
                this.addReferenceResolutionError((List<?>)gtInvoc.getAnnotations(), "Parameter mismatch in GT rule invocation. Expecting '{1}'", ErrorInformation.ErrorSeverity.ERROR, context);
            }
        } else {
            String arity = String.valueOf(gtInvoc.getActualParameters().size());
            context = new String[]{String.valueOf(gtInvoc.getName()) + "/" + arity};
            this.addReferenceResolutionError((List<?>)gtInvoc.getAnnotations(), "GT Rule Invocation '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
        return gtRuleDef;
    }

    public void resolveGTRuleInvocations(Machine machine) {
        List<GTRuleInvocation> list = this.getUnresolvedGTRuleInvoc();
        for (GTRuleInvocation gtInvoc : list) {
            String nameStr = gtInvoc.getFqn();
            int arity = gtInvoc.getActualParameters().size();
            GTRule gtRuleDef = this.lookupGTRule(nameStr, arity, machine);
            this.reportGtRuleResolutionError(gtInvoc, gtRuleDef, this.modelSpace.getFramework());
        }
    }

    public ASMFunction reportFunInvocResolutionError(ASMFunctionInvocation funInvoc, ASMFunction asmFunDef, IFramework fw) {
        String[] context;
        String machineStr;
        Machine extMachine;
        int lastDotIndex;
        String nameStr = funInvoc.getFqn();
        int callArity = funInvoc.getActualParameters().size();
        if (asmFunDef == null && (lastDotIndex = nameStr.lastIndexOf(".")) != -1 && (extMachine = (Machine)fw.getMachineByFQN(machineStr = nameStr.substring(0, lastDotIndex))) != null) {
            asmFunDef = this.lookupAsmFunction(nameStr, callArity, extMachine, true);
        }
        if (asmFunDef != null) {
            if (asmFunDef.getArity() == funInvoc.getActualParameters().size()) {
                funInvoc.setCalledFunction(asmFunDef);
            } else {
                String arity = String.valueOf(asmFunDef.getArity());
                context = new String[]{String.valueOf(asmFunDef.getName()) + "/" + arity};
                this.addReferenceResolutionError((List<?>)funInvoc.getAnnotations(), "Parameter mismatch in ASM function. Expecting '{1}' ", ErrorInformation.ErrorSeverity.ERROR, context);
            }
        } else {
            String arity = String.valueOf(funInvoc.getActualParameters().size());
            context = new String[]{String.valueOf(funInvoc.getName()) + "/" + arity};
            this.addReferenceResolutionError((List<?>)funInvoc.getAnnotations(), "ASM Function Invocation cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
        return asmFunDef;
    }

    public void resolveAsmFunInvocations(Machine machine) {
        List<ASMFunctionInvocation> list = this.getUnresolvedAsmFunctionInvocations();
        for (ASMFunctionInvocation funInvoc : list) {
            String nameStr = funInvoc.getFqn();
            int arity = funInvoc.getActualParameters().size();
            ASMFunction asmFunDef = this.lookupAsmFunction(nameStr, arity, machine, true);
            this.reportFunInvocResolutionError(funInvoc, asmFunDef, this.modelSpace.getFramework());
        }
    }

    public ASMFunction reportAsmFunUpdateResolutionError(RuleUpdateASMFunction updateRule, ASMFunction asmFunDef, IFramework fw) {
        String[] context;
        String machineStr;
        Machine extMachine;
        int lastDotIndex;
        String nameStr = updateRule.getFqn();
        int callArity = updateRule.getLocations().size();
        if (asmFunDef == null && (lastDotIndex = nameStr.lastIndexOf(".")) != -1 && (extMachine = (Machine)fw.getMachineByFQN(machineStr = nameStr.substring(0, lastDotIndex))) != null) {
            asmFunDef = this.lookupAsmFunction(nameStr, callArity, extMachine, false);
        }
        if (asmFunDef != null) {
            if (asmFunDef.getArity() == updateRule.getLocations().size()) {
                updateRule.setFunction(asmFunDef);
            } else {
                String arity = String.valueOf(asmFunDef.getArity());
                context = new String[]{String.valueOf(asmFunDef.getName()) + "/" + arity};
                this.addReferenceResolutionError((List<?>)updateRule.getAnnotations(), "Parameter mismatch in ASM function. Expecting '{1}' ", ErrorInformation.ErrorSeverity.ERROR, context);
            }
        } else {
            String arity = String.valueOf(updateRule.getLocations().size());
            context = new String[]{String.valueOf(updateRule.getFqn()) + "/" + arity};
            this.addReferenceResolutionError((List<?>)updateRule.getAnnotations(), "The ASM Function '{1}' to be updated cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
        return asmFunDef;
    }

    public void resolveAsmFunUpdates(Machine machine) {
        List<RuleUpdateASMFunction> list = this.getUnresolvedAsmFunctionUpdates();
        for (RuleUpdateASMFunction updateRule : list) {
            String nameStr = updateRule.getFqn();
            int arity = updateRule.getLocations().size();
            ASMFunction asmFunDef = this.lookupAsmFunction(nameStr, arity, machine, false);
            this.reportAsmFunUpdateResolutionError(updateRule, asmFunDef, this.modelSpace.getFramework());
        }
    }

    public Rule reportAsmRuleInvocResolutionError(CallRule ruleInvoc, Rule ruleDef, IFramework fw) {
        String[] context;
        String machineStr;
        Machine extMachine;
        int lastDotIndex;
        String ruleName = ruleInvoc.getFqn();
        int callArity = ruleInvoc.getActualParameters().size();
        if (ruleDef == null && (lastDotIndex = ruleName.lastIndexOf(".")) != -1 && (extMachine = (Machine)fw.getMachineByFQN(machineStr = ruleName.substring(0, lastDotIndex))) != null) {
            ruleDef = this.lookupAsmRule(ruleName, callArity, extMachine);
        }
        if (ruleDef != null) {
            if (ruleDef.getSymParameters().size() == ruleInvoc.getActualParameters().size()) {
                ruleInvoc.setRule(ruleDef);
            } else {
                String arity = String.valueOf(ruleDef.getSymParameters().size());
                context = new String[]{String.valueOf(ruleDef.getName()) + "/" + arity};
                this.addReferenceResolutionError((List<?>)ruleInvoc.getAnnotations(), "Parameter mismatch in ASM rule invocation. Expecting '{1}' ", ErrorInformation.ErrorSeverity.ERROR, context);
            }
        } else {
            String arity = String.valueOf(ruleInvoc.getActualParameters().size());
            context = new String[]{String.valueOf(ruleName) + "/" + arity};
            this.addReferenceResolutionError((List<?>)ruleInvoc.getAnnotations(), "ASM Call Rule '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
        return ruleDef;
    }

    public void resolveAsmRulesInvocations(Machine machine) {
        List<CallRule> list = this.getUnresolvedAsmRuleCalls();
        for (CallRule ruleInvoc : list) {
            String ruleName = ruleInvoc.getFqn();
            int arity = ruleInvoc.getActualParameters().size();
            Rule ruleDef = this.lookupAsmRule(ruleName, arity, machine);
            this.reportAsmRuleInvocResolutionError(ruleInvoc, ruleDef, this.modelSpace.getFramework());
        }
    }

    public void resolveVariableRefsInRule(GTASMElement defScope) {
        List<VariableReference> list = this.unresolvedVariableRefsStack.peek();
        for (VariableReference varRef : list) {
            Variable varDef = null;
            if (defScope instanceof ASMRuleInvocation) {
                ASMRuleInvocation ruleInvoc = (ASMRuleInvocation)defScope;
                varDef = this.traverseCallHierarchy(varRef.getName(), ruleInvoc);
            } else if (defScope instanceof GTPatternBody) {
                GTPatternBody body = (GTPatternBody)defScope;
                varDef = this.lookupVariableDefByName(varRef.getName(), body);
            }
            if (varDef != null) {
                varRef.setVariable(varDef);
                continue;
            }
            String[] context = new String[]{varRef.getName()};
            this.addReferenceResolutionError((List<?>)varRef.getAnnotations(), "Variable Reference '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
        }
    }

    public void resolveEntityTypesInBody(GTPatternBody body) {
        Entity top = body.getPatternGraph();
        for (Entity entity : top.getComponents()) {
            List<String> fqnList = this.lookupEntityType(this.getMachine(), entity.getTypeStr());
            this.resolveTypeNames((AnnotatedElement)entity, fqnList, body);
        }
    }

    public void resolveRelationTypesInBody(GTPatternBody body) {
        for (Relation relation : body.getDanglingRelations()) {
            List<String> fqnList = this.lookupRelationType(this.getMachine(), relation.getTypeStr());
            this.resolveTypeNames((AnnotatedElement)relation, fqnList, body);
            this.checkRelationEndTypes(relation);
        }
        Entity top = body.getPatternGraph();
        for (Entity entity : top.getComponents()) {
            this.checkRelationsFrom(body, (ModelElement)entity);
        }
    }

    private void checkRelationsFrom(GTPatternBody body, ModelElement element) {
        for (Relation relation : element.getRelationsFrom()) {
            List<String> fqnList2 = this.lookupRelationType(this.getMachine(), relation.getTypeStr());
            this.resolveTypeNames((AnnotatedElement)relation, fqnList2, body);
            this.checkRelationEndTypes(relation);
            this.checkRelationsFrom(body, (ModelElement)relation);
        }
    }

    private TypeInfo calculateVariableType(ModelElement element, IModelElement expectedType) {
        boolean found = false;
        Iterator it = element.getType().iterator();
        IModelElement actualType = null;
        while (!found && it.hasNext()) {
            ModelElement typeSrc = (ModelElement)it.next();
            actualType = this.modelManager.getElementByName(typeSrc.getRealElement());
            if (actualType == null || expectedType != actualType && !expectedType.isSupertypeOf(actualType)) continue;
            found = true;
        }
        return new TypeInfo(found, actualType);
    }

    private void checkRelationEndTypes(Relation relation) {
        Relation typeRel;
        IRelation vpmTypeOfRelInPattern;
        if (!relation.getType().isEmpty() && (vpmTypeOfRelInPattern = this.modelManager.getRelationByName((typeRel = (Relation)relation.getType().get(0)).getRealElement())) != null) {
            ModelElement target;
            String[] context;
            String actualTypeStr;
            String expectedTypeStr;
            TypeInfo info;
            ModelElement source;
            if (relation.getFrom() != null && !(source = relation.getFrom()).getType().isEmpty()) {
                info = this.calculateVariableType(source, vpmTypeOfRelInPattern.getFrom());
                if (!info.isValid) {
                    IModelElement vpmTypeOfSrcElementInPattern = info.type;
                    expectedTypeStr = vpmTypeOfRelInPattern.getFrom().getFullyQualifiedName();
                    if (vpmTypeOfSrcElementInPattern != null) {
                        actualTypeStr = vpmTypeOfSrcElementInPattern.getFullyQualifiedName();
                        context = new String[]{actualTypeStr, expectedTypeStr};
                        this.addReferenceResolutionError((List<?>)relation.getAnnotations(), "The source end of Relation is not properly typed. The actual type is '{1}' while expecting '{2}'.", ErrorInformation.ErrorSeverity.ERROR, context);
                    } else {
                        this.addReferenceResolutionError((List<?>)relation.getAnnotations(), "Source end of Relation cannot be resolved ", ErrorInformation.ErrorSeverity.WARNING, new String[0]);
                    }
                }
            }
            if (relation.getTo() != null && !(target = relation.getTo()).getType().isEmpty()) {
                info = this.calculateVariableType(target, vpmTypeOfRelInPattern.getTo());
                if (!info.isValid) {
                    IModelElement vpmTypeOfTrgElementInPattern = info.type;
                    expectedTypeStr = vpmTypeOfRelInPattern.getTo().getFullyQualifiedName();
                    if (vpmTypeOfTrgElementInPattern != null) {
                        actualTypeStr = vpmTypeOfTrgElementInPattern.getFullyQualifiedName();
                        context = new String[]{actualTypeStr, expectedTypeStr};
                        this.addReferenceResolutionError((List<?>)relation.getAnnotations(), "The target end of Relation is not properly typed. The actual type is '{1}' while expecting '{2}'.", ErrorInformation.ErrorSeverity.ERROR, context);
                    } else {
                        this.addReferenceResolutionError((List<?>)relation.getAnnotations(), "Target end of Relation cannot be resolved ", ErrorInformation.ErrorSeverity.WARNING, new String[0]);
                    }
                }
            }
        }
    }

    public void resolveTypesInASMRules(ElementCreateRule rule, String typeStr) {
        List<String> fqnList = null;
        if (rule instanceof EntityCreateRule) {
            fqnList = this.lookupEntityType(this.getMachine(), typeStr);
        } else if (rule instanceof RelationCreateRule) {
            fqnList = this.lookupRelationType(this.getMachine(), typeStr);
        }
        if (fqnList != null) {
            if (fqnList.size() == 1) {
                ElementReference elemRef = (ElementReference)rule.getType();
                Constant typeCons = (Constant)elemRef.getArgument();
                typeCons.setValue(fqnList.get(0));
            }
            if (fqnList.size() > 1) {
                String[] context = new String[fqnList.size()];
                int i = 0;
                while (i < fqnList.size()) {
                    context[i] = fqnList.get(i);
                    ++i;
                }
                this.addReferenceResolutionError((List<?>)rule.getAnnotations(), "Ambiguous type of model element. Possible resolutions are {ALL}. This ambiguity is most probably caused by conflicting import declarations", ErrorInformation.ErrorSeverity.ERROR, context);
            } else if (fqnList.size() == 0) {
                if (rule instanceof EntityCreateRule) {
                    this.addReferenceResolutionError((List<?>)rule.getAnnotations(), "Type of Entity cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
                } else if (rule instanceof RelationCreateRule) {
                    this.addReferenceResolutionError((List<?>)rule.getAnnotations(), "Type of Relation cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
                }
            }
        }
    }

    private void resolveTypeNames(AnnotatedElement element, List<String> fqnList) {
        this.resolveTypeNames(element, fqnList, null);
    }

    private void resolveTypeNames(AnnotatedElement element, List<String> fqnList, GTPatternBody body) {
        if (fqnList.size() == 1) {
            if (element instanceof Entity) {
                Entity entity = (Entity)element;
                this.resolveEntity(entity, fqnList.get(0), body);
            } else if (element instanceof Relation) {
                Relation relation = (Relation)element;
                this.resolveRelation(relation, fqnList.get(0), body);
            } else if (element instanceof Variable) {
                Variable variable = (Variable)element;
                this.resolveAsmVariableType(variable, fqnList.get(0));
            } else if (element instanceof ASMFunction) {
                ASMFunction asmFun = (ASMFunction)element;
                this.resolveAsmFunctionType(asmFun, fqnList.get(0));
            } else if (element instanceof TypeConstant) {
                TypeConstant typeConst = (TypeConstant)element;
                this.resolveTypeConstantType(typeConst, fqnList.get(0));
            }
        } else if (fqnList.size() > 1) {
            String[] context = new String[fqnList.size()];
            int i = 0;
            while (i < fqnList.size()) {
                context[i] = fqnList.get(i);
                ++i;
            }
            this.addReferenceResolutionError((List<?>)element.getAnnotations(), "Ambiguous type of model element. Possible resolutions are {ALL}. This ambiguity is most probably caused by conflicting import declarations", ErrorInformation.ErrorSeverity.ERROR, context);
        } else if (fqnList.size() == 0) {
            if (element instanceof Entity) {
                Entity entity = (Entity)element;
                this.addReferenceResolutionError((List<?>)entity.getAnnotations(), "Type of Entity cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
            } else if (element instanceof Relation) {
                Relation relation = (Relation)element;
                this.addReferenceResolutionError((List<?>)relation.getAnnotations(), "Type of Relation cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
            } else if (element instanceof Variable) {
                Variable variable = (Variable)element;
                String[] context = new String[]{variable.getName()};
                this.addReferenceResolutionError((List<?>)variable.getVariableType().getAnnotations(), "Type of Variable '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
            } else if (element instanceof ASMFunction) {
                ASMFunction asmFun = (ASMFunction)element;
                String[] context = new String[]{asmFun.getName()};
                this.addReferenceResolutionError((List<?>)asmFun.getReturnType().getAnnotations(), "Type of ASM function '{1}' cannot be resolved ", ErrorInformation.ErrorSeverity.ERROR, context);
            }
        }
    }

    private void resolveTypeConstantType(TypeConstant typeConst, String fqn) {
        if (!(fqn.equals("entity") || fqn.equals("vpm.entity") || fqn.equals("ENTITY") || fqn.equals("relation") || fqn.equals("vpm.entity.relation") || fqn.equals("RELATION"))) {
            if (typeConst != null) {
                typeConst.setFqn(fqn);
            }
        } else {
            typeConst.setFqn(typeConst.getName());
        }
    }

    private void resolveAsmFunctionType(ASMFunction asmFun, String fqn) {
        TypeConstant typeConst;
        if (!(fqn.equals("entity") || fqn.equals("vpm.entity") || fqn.equals("relation") || fqn.equals("vpm.entity.relation") || (typeConst = asmFun.getReturnType()) == null)) {
            typeConst.setFqn(fqn);
        }
    }

    private void resolveAsmVariableType(Variable variable, String fqn) {
        TypeConstant typeConst;
        if (!(fqn.equals("entity") || fqn.equals("vpm.entity") || fqn.equals("relation") || fqn.equals("vpm.entity.relation") || (typeConst = variable.getVariableType()) == null)) {
            typeConst.setFqn(fqn);
        }
    }

    private void resolveEntity(Entity entity, String fqn, GTPatternBody body) {
        Entity typeEntity;
        if (!(fqn.contentEquals("TOP") || fqn.contentEquals("ENTITY") || fqn.equals("entity") || fqn.equals("vpm.entity") || (typeEntity = (Entity)this.resolveElementInElementWrapper(fqn, body, true)) == null)) {
            entity.getType().add((Object)typeEntity);
            TypeOf relship = EditmodelFactory.eINSTANCE.createTypeOf();
            relship.setSupplier((ModelElement)typeEntity);
            relship.setSupplierStr(typeEntity.getName());
            relship.setClient((ModelElement)entity);
            relship.setClientStr(entity.getName());
        }
    }

    private void resolveRelation(Relation relation, String fqn, GTPatternBody body) {
        Relation typeRelation;
        if (!(fqn.contentEquals("TOP") || fqn.contentEquals("RELATION") || fqn.equals("relation") || fqn.equals("vpm.entity.relation") || (typeRelation = (Relation)this.resolveElementInElementWrapper(fqn, body, false)) == null)) {
            relation.getType().add((Object)typeRelation);
            TypeOf relship = EditmodelFactory.eINSTANCE.createTypeOf();
            relship.setSupplier((ModelElement)typeRelation);
            relship.setSupplierStr(typeRelation.getName());
            relship.setClient((ModelElement)relation);
            relship.setClientStr(relation.getName());
        }
    }

    private ModelElement resolveElementInElementWrapper(String fqn, GTPatternBody body, boolean isEntity) {
        ModelElement element = this.lookupElementWrapperInBody(fqn, (List)body.getElementWrappers());
        if (element == null) {
            IModelElement type = this.modelManager.getElementByName(fqn);
            if (type != null && type.isEntity()) {
                Entity typeEntity = EditmodelFactory.eINSTANCE.createEntity();
                typeEntity.setRealElement(fqn);
                typeEntity.setName(fqn);
                typeEntity.setTypeStr(fqn);
                body.getElementWrappers().add((Object)typeEntity);
                return typeEntity;
            }
            if (type != null && type.isRelation()) {
                Relation typeRelation = EditmodelFactory.eINSTANCE.createRelation();
                typeRelation.setRealElement(fqn);
                typeRelation.setName(fqn);
                typeRelation.setTypeStr(fqn);
                body.getElementWrappers().add((Object)typeRelation);
                return typeRelation;
            }
        }
        return element;
    }

    public PatternVariable lookupVariableDefByName(String varStr, GTPatternBody body) {
        if (varStr.charAt(0) == '_') {
            return null;
        }
        boolean found = false;
        PatternVariable varDef = null;
        Iterator iter1 = body.getHeader().getSymParameters().iterator();
        while (!found && iter1.hasNext()) {
            varDef = (PatternVariable)iter1.next();
            if (!varStr.equals(varDef.getName())) continue;
            found = true;
        }
        Iterator iter2 = body.getLocalVariables().iterator();
        while (!found && iter2.hasNext()) {
            varDef = (PatternVariable)iter2.next();
            if (!varStr.equals(varDef.getName())) continue;
            found = true;
        }
        if (found) {
            return varDef;
        }
        return null;
    }

    public Variable lookupVariableDefByName(String varStr, GTRule rule) {
        boolean found = false;
        Variable varDef = null;
        Iterator iter2 = rule.getLocalVariables().iterator();
        while (!found && iter2.hasNext()) {
            varDef = (Variable)iter2.next();
            if (!varStr.equals(varDef.getName())) continue;
            found = true;
        }
        if (found) {
            return varDef;
        }
        return null;
    }

    public VariableReference lookupVariableRefByName(String varStr, VPMElement localElement) {
        boolean found = false;
        VariableReference varRef = null;
        Iterator iter1 = localElement.getVariableReferences().iterator();
        while (!found && iter1.hasNext()) {
            varRef = (VariableReference)iter1.next();
            if (!varStr.equals(varRef.getName())) continue;
            found = true;
        }
        if (found) {
            return varRef;
        }
        return null;
    }

    public Variable traverseCallHierarchy(String varName, ASMRuleInvocation ruleInvoc) {
        GTRule gtRule;
        Variable var = null;
        if (ruleInvoc instanceof BlockRule) {
            BlockRule rule = (BlockRule)ruleInvoc;
            var = this.lookupVariableDefInRule(varName, (List<?>)rule.getLocalVariables());
        }
        if (var == null && ruleInvoc.getCaller() != null) {
            return this.traverseCallHierarchy(varName, ruleInvoc.getCaller());
        }
        if (var == null && ruleInvoc.getAsmRule() != null) {
            Rule asmRule = ruleInvoc.getAsmRule();
            var = this.lookupVariableDefInRule(varName, (List<?>)asmRule.getLocalVariables());
        } else if (var == null && ruleInvoc.getAsmRule() == null && (gtRule = this.actionRuleMap.get(ruleInvoc)) != null) {
            var = this.lookupVariableDefInRule(varName, (List<?>)gtRule.getLocalVariables());
        }
        return var;
    }

    protected Variable lookupVariableDefInRule(String varName, List<?> list) {
        boolean found = false;
        Variable varDef = null;
        Iterator<?> iter1 = list.iterator();
        while (!found && iter1.hasNext()) {
            varDef = (Variable)iter1.next();
            if (!varName.equals(varDef.getName())) continue;
            found = true;
        }
        if (found) {
            return varDef;
        }
        return null;
    }

    public GTPattern lookupGTPattern(String patternName, int arity, Machine machine) {
        boolean found = false;
        GTPattern patternDef = null;
        Iterator iter1 = machine.getGtPatternDefinitions().iterator();
        while (!found && iter1.hasNext()) {
            patternDef = (GTPattern)iter1.next();
            if (!patternName.equals(patternDef.getFqn()) && !patternName.equals(patternDef.getName()) || arity != patternDef.getSymParameters().size()) continue;
            found = true;
        }
        if (found) {
            return patternDef;
        }
        return null;
    }

    public GTRule lookupGTRule(String ruleName, int arity, Machine machine) {
        boolean found = false;
        GTRule gtRuleDef = null;
        Iterator iter1 = machine.getGtRuleDefinitions().iterator();
        while (!found && iter1.hasNext()) {
            gtRuleDef = (GTRule)iter1.next();
            if (!ruleName.equals(gtRuleDef.getFqn()) && !ruleName.equals(gtRuleDef.getName()) || arity != gtRuleDef.getSymParameters().size()) continue;
            found = true;
        }
        if (found) {
            return gtRuleDef;
        }
        return null;
    }

    public Rule lookupAsmRule(String ruleName, int arity, Machine machine) {
        boolean found = false;
        Rule ruleDef = null;
        Iterator iter1 = machine.getAsmRuleDefinitions().iterator();
        while (!found && iter1.hasNext()) {
            ruleDef = (Rule)iter1.next();
            if (!ruleName.equals(ruleDef.getFqn()) && !ruleName.equals(ruleDef.getName()) || arity != ruleDef.getSymParameters().size()) continue;
            found = true;
        }
        if (found) {
            return ruleDef;
        }
        return null;
    }

    public ASMFunction lookupAsmFunction(String asmFunName, int arity, Machine machine, boolean isRValue) {
        boolean found = false;
        ASMFunction asmFunDef = null;
        Iterator iter1 = machine.getAsmFunctionDefinitions().iterator();
        while (!found && iter1.hasNext()) {
            asmFunDef = (ASMFunction)iter1.next();
            if (!asmFunName.equals(asmFunDef.getFqn()) && !asmFunName.equals(asmFunDef.getName()) || arity != asmFunDef.getArity()) continue;
            found = true;
        }
        if (found) {
            return asmFunDef;
        }
        return null;
    }

    public boolean lookupNativeAsmFunction(String asmFunName) {
        boolean found = false;
        if (!found) {
            int i = 0;
            while (!found && i < this.getNativeFunctions().length) {
                ASMNativeFunction nativeFunction = this.getNativeFunctions()[i];
                if (asmFunName.equals(nativeFunction.getName())) {
                    found = true;
                }
                ++i;
            }
        }
        return found;
    }

    public ModelElement lookupElementWrapperInBody(String fqn, List elementWrappers) {
        boolean found = false;
        ModelElement element = null;
        Iterator iter1 = elementWrappers.iterator();
        while (!found && iter1.hasNext()) {
            element = (ModelElement)iter1.next();
            if (!fqn.equals(element.getName())) continue;
            found = true;
        }
        if (found) {
            return element;
        }
        return null;
    }

    public Annotation lookupAnnotation(String key, List<?> annotations) {
        boolean found = false;
        Annotation annotation = null;
        Iterator<?> iter1 = annotations.iterator();
        while (!found && iter1.hasNext()) {
            annotation = (Annotation)iter1.next();
            if (!annotation.getKey().equals(key)) continue;
            found = true;
        }
        return annotation;
    }

    public List<String> lookupEntityType(Machine machine, String type) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (type.equals("entity") || type.equals("vpm.entity") || type.equals("ENTITY")) {
            nameList.add("ENTITY");
            return nameList;
        }
        Module module = machine.getModule();
        IEntity e = this.modelManager.getEntityByName(type);
        if (e != null) {
            nameList.add(e.getFullyQualifiedName());
            return nameList;
        }
        for (ImportDeclaration id : module.getImport()) {
            String fqn = this.fqn(id.getImportValue(), type);
            e = this.modelManager.getEntityByName(fqn);
            if (e == null) continue;
            nameList.add(e.getFullyQualifiedName());
        }
        return nameList;
    }

    public List<String> lookupRelationType(Machine machine, String type) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (type.equals("relation") || type.equals("vpm.entity.relation") || type.equals("RELATION")) {
            nameList.add("RELATION");
            return nameList;
        }
        Module module = (Module)machine.eContainer();
        IRelation r = this.modelManager.getRelationByName(type);
        if (r != null) {
            nameList.add(r.getFullyQualifiedName());
        }
        for (ImportDeclaration id : module.getImport()) {
            String fqn = this.fqn(id.getImportValue(), type);
            r = this.modelManager.getRelationByName(fqn);
            if (r == null) continue;
            nameList.add(r.getFullyQualifiedName());
        }
        return nameList;
    }

    private String fqn(String ns, String n) {
        if (ns == null) {
            return n;
        }
        if (ns.length() == 0) {
            return n;
        }
        return String.valueOf(ns) + "." + n;
    }

    public void validateDistinctVariables(Machine machine) {
        for (Rule asmRule : machine.getAsmRuleDefinitions()) {
            this.validateDistinctVariablesAsmRule(asmRule);
        }
        for (GTRule gtRule : machine.getGtRuleDefinitions()) {
            this.validateDistinctVariablesGTRule(gtRule);
            this.validatePostcondition(gtRule);
        }
        for (GTPattern pattern : machine.getGtPatternDefinitions()) {
            this.validateDistinctVariablesPattern(pattern);
        }
    }

    private void validatePostcondition(GTRule gtRule) {
        GTPattern rhs;
        GTPatternCall rhsCall = gtRule.getPostcondition();
        if (rhsCall != null && (rhs = rhsCall.getCalledPattern()) != null) {
            if (rhs.getPatternBodies().size() > 1) {
                String[] context = new String[]{rhs.getName(), gtRule.getName()};
                this.addReferenceResolutionError((List<?>)rhs.getAnnotations(), "OR-pattern in '{1}' is not allowed to be used as a postcondition of GT Rule '{2}'", ErrorInformation.ErrorSeverity.ERROR, context);
            }
            for (GTPatternBody body : rhs.getPatternBodies()) {
                String[] context;
                for (Term term : body.getCheckExpressions()) {
                    context = new String[]{rhs.getName(), gtRule.getName()};
                    this.addReferenceResolutionError((List<?>)term.getAnnotations(), "Check expressions are ignored when using pattern '{1}' as a postcondition of GT Rule '{2}'.", ErrorInformation.ErrorSeverity.WARNING, context);
                }
                for (GTPatternCall gtCall : body.getNegativePatterns()) {
                    context = new String[]{rhs.getName(), gtRule.getName()};
                    this.addReferenceResolutionError((List<?>)gtCall.getAnnotations(), "Negative patterns are ignored when using pattern '{1}' as a postcondition of GT Rule '{2}'.", ErrorInformation.ErrorSeverity.WARNING, context);
                }
            }
        }
    }

    public void validateDistinctVariablesGTRule(GTRule gtRule) {
        HashSet<String> variableNames = new HashSet<String>();
        for (Variable varDef : gtRule.getLocalVariables()) {
            this.checkNameExistence((GTASMElement)varDef, variableNames, "Duplicate definition of variable '{1}' in GT rule");
            this.checkVariableIsInUse(varDef, "Variable '{1}' is not currently in use");
        }
        if (gtRule.getAction() != null) {
            this.checkSubruleInvocations(gtRule.getAction(), variableNames);
        }
        for (GTPattern pattern : gtRule.getLocalPatternDefinition()) {
            this.validateDistinctVariablesPattern(pattern);
        }
    }

    public void validateDistinctVariablesPattern(GTPattern pattern) {
        HashSet<String> variableNames = new HashSet<String>();
        for (PatternVariable varDef : pattern.getSymParameters()) {
            this.checkNameExistence((GTASMElement)varDef, variableNames, "Duplicate definition of pattern variable '{1}'");
            this.checkVariableIsInUse((Variable)varDef, "Variable '{1}' is not currently in use");
        }
        HashSet<String> localVarNames = new HashSet<String>();
        Iterator iter = pattern.getPatternBodies().iterator();
        while (iter.hasNext()) {
            localVarNames.clear();
            for (String nameStr : variableNames) {
                localVarNames.add(nameStr);
            }
            GTPatternBody body = (GTPatternBody)iter.next();
            for (PatternVariable bodyVarDef : body.getLocalVariables()) {
                this.checkNameExistence((GTASMElement)bodyVarDef, localVarNames, "Duplicate definition of pattern variable '{1}'");
                this.checkVariableIsInUse((Variable)bodyVarDef, "Variable '{1}' is not currently in use");
            }
            for (GTPattern subPattern : body.getLocalPatternDefinition()) {
                this.validateDistinctVariablesPattern(subPattern);
            }
        }
    }

    public void validateDistinctVariablesAsmRule(Rule asmRule) {
        HashSet<String> varNames = new HashSet<String>();
        for (Variable varDef : asmRule.getLocalVariables()) {
            this.checkNameExistence((GTASMElement)varDef, varNames, "Duplicate definition of ASM variable '{1}'");
            this.checkVariableIsInUse(varDef, "Variable '{1}' is not currently in use");
        }
        this.checkSubruleInvocations(asmRule.getBody(), varNames);
    }

    protected void checkSubruleInvocations(ASMRuleInvocation ruleInvoc, Set<String> varNames) {
        ASMRuleInvocation subRule2;
        ASMRuleInvocation subRule1;
        BlockRule rule;
        if (ruleInvoc instanceof BlockRule) {
            rule = (BlockRule)ruleInvoc;
            for (Variable varDef : rule.getLocalVariables()) {
                this.checkNameExistence((GTASMElement)varDef, varNames, "Duplicate definition of ASM variable '{1}'");
                this.checkVariableIsInUse(varDef, "Variable '{1}' is not currently in use");
            }
        }
        if (ruleInvoc instanceof ConditionalRuleIf) {
            rule = (ConditionalRuleIf)ruleInvoc;
            subRule1 = rule.getRuleTrue();
            if (subRule1 != null) {
                HashSet<String> varNamesIf = new HashSet<String>(varNames);
                this.checkSubruleInvocations(subRule1, varNamesIf);
            }
            if ((subRule2 = rule.getRuleFalse()) != null) {
                HashSet<String> varNamesIf = new HashSet<String>(varNames);
                this.checkSubruleInvocations(subRule2, varNamesIf);
            }
        } else if (ruleInvoc instanceof ConditionalRuleTry) {
            rule = (ConditionalRuleTry)ruleInvoc;
            subRule1 = rule.getRuleToTry();
            if (subRule1 != null) {
                HashSet<String> varNamesTry = new HashSet<String>(varNames);
                this.checkSubruleInvocations(subRule1, varNamesTry);
            }
            if ((subRule2 = rule.getRuleElse()) != null) {
                HashSet<String> varNamesTry = new HashSet<String>(varNames);
                this.checkSubruleInvocations(subRule2, varNamesTry);
            }
        } else if (ruleInvoc instanceof CompoundRule) {
            rule = (CompoundRule)ruleInvoc;
            ASMRuleInvocation subRule = rule.getBody();
            if (subRule != null) {
                this.checkSubruleInvocations(subRule, varNames);
            }
        } else if (ruleInvoc instanceof NestedRule) {
            rule = (NestedRule)ruleInvoc;
            for (ASMRuleInvocation subRule : rule.getSubrules()) {
                HashSet<String> oldVarNames = new HashSet<String>(varNames);
                this.checkSubruleInvocations(subRule, varNames);
                varNames = oldVarNames;
            }
        }
    }

    protected void checkNameExistence(GTASMElement element, Set<String> names, String errorCode) {
        if (!names.contains(element.getName())) {
            if (element.getName().charAt(0) != '_') {
                names.add(element.getName());
            }
        } else {
            String[] context = new String[]{element.getName()};
            this.addReferenceResolutionError((List<?>)element.getAnnotations(), errorCode, ErrorInformation.ErrorSeverity.ERROR, context);
        }
    }

    protected void checkSignatureExistence(GTASMElement element, String signature, Set<String> names, String errorCode) {
        if (!names.contains(signature)) {
            names.add(signature);
        } else {
            String[] context = new String[]{signature};
            this.addReferenceResolutionError((List<?>)element.getAnnotations(), errorCode, ErrorInformation.ErrorSeverity.ERROR, context);
        }
    }

    public void validateNoDuplicateNames(Machine machine) {
        HashSet<String> asmFunNames = new HashSet<String>();
        for (ASMFunction asmFun : machine.getAsmFunctionDefinitions()) {
            String signature = String.valueOf(asmFun.getName()) + "/" + String.valueOf(asmFun.getArity());
            this.checkSignatureExistence((GTASMElement)asmFun, signature, asmFunNames, "Duplicate definition of ASM function '{1}'");
        }
        HashSet<String> asmRuleNames = new HashSet<String>();
        for (Rule asmRule : machine.getAsmRuleDefinitions()) {
            String signature = String.valueOf(asmRule.getName()) + "/" + String.valueOf(asmRule.getSymParameters().size());
            this.checkSignatureExistence((GTASMElement)asmRule, signature, asmRuleNames, "Duplicate definition of ASM rule '{1}'");
        }
        HashSet<String> patternNames = new HashSet<String>();
        for (GTPattern pattern : machine.getGtPatternDefinitions()) {
            String signature = String.valueOf(pattern.getName()) + "/" + String.valueOf(pattern.getSymParameters().size());
            this.checkSignatureExistence((GTASMElement)pattern, signature, patternNames, "Duplicate definition of pattern '{1}'");
        }
        HashSet<String> gtRuleNames = new HashSet<String>();
        for (GTRule gtRule : machine.getGtRuleDefinitions()) {
            String signature = String.valueOf(gtRule.getName()) + "/" + String.valueOf(gtRule.getSymParameters().size());
            this.checkSignatureExistence((GTASMElement)gtRule, signature, gtRuleNames, "Duplicate definition of GT rule '{1}'");
            HashSet<String> containedPatternNames = new HashSet<String>();
            for (GTPattern pattern : gtRule.getLocalPatternDefinition()) {
                String pSignature = String.valueOf(pattern.getName()) + "/" + String.valueOf(pattern.getSymParameters().size());
                this.checkSignatureExistence((GTASMElement)pattern, pSignature, containedPatternNames, "Duplicate definition of pattern '{1}'");
            }
        }
    }

    public void validateAsmFunctionInitialValues(ASMFunction asmFun) {
        for (InitialValue initValue : asmFun.getInitialValues()) {
            if (initValue.getLocations().size() == asmFun.getArity()) continue;
            this.addReferenceResolutionError((List<?>)initValue.getAnnotations(), "The initial values of ASM function does not match its arity ", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
        }
    }

    public String resolveModelElementConstant(Constant meConst) {
        String name = meConst.getValue();
        IModelElement element = this.modelManager.getElementByName(name);
        if (element == null) {
            String[] context = new String[]{name};
            this.addReferenceResolutionError((List<?>)meConst.getAnnotations(), "Model element constant '{1}' is non-existing in the model space.", ErrorInformation.ErrorSeverity.ERROR, context);
            meConst.setType("TOP");
            meConst.setKind(ValueKind.UNDEF_LITERAL);
            return "";
        }
        String typeStr = this.typeResolver.lookupType(element);
        meConst.setType(typeStr);
        meConst.setKind(ValueKind.MODELELEMENT_LITERAL);
        return element.getFullyQualifiedName();
    }

    public void resolveAsmType(AnnotatedElement element, String typeStr) {
        List<String> fqnList1 = this.lookupEntityType(this.getMachine(), typeStr);
        List<String> fqnList2 = this.lookupRelationType(this.getMachine(), typeStr);
        fqnList1.addAll(fqnList2);
        this.resolveTypeNames(element, fqnList1);
    }

    protected void checkVariableIsInUse(Variable varDef, String errorCode) {
        if (varDef.getReferences().isEmpty()) {
            String[] context = new String[]{varDef.getName()};
            this.addReferenceResolutionError((List<?>)varDef.getAnnotations(), errorCode, ErrorInformation.ErrorSeverity.WARNING, context);
        }
    }

    public void reportInvalidMatchCounter(GTPatternCall patternCall, String element) {
        String[] context = new String[]{patternCall.getName(), element};
        this.addReferenceResolutionError((List<?>)patternCall.getAnnotations(), "Match counters are not allowed to be used in {2}: '{1}'.", ErrorInformation.ErrorSeverity.ERROR, context);
    }

    public void reportUnusedPatternParameter(GTPatternBody body) {
        for (PatternVariable varDef : body.getHeader().getSymParameters()) {
            boolean found = false;
            Iterator itEnt = body.getPatternGraph().getComponents().iterator();
            while (!found && itEnt.hasNext()) {
                Entity ent = (Entity)itEnt.next();
                if (ent.getName().equals(varDef.getName())) {
                    found = true;
                }
                Iterator itRels = ent.getRelationsFrom().iterator();
                while (!found && itRels.hasNext()) {
                    Relation rel = (Relation)itRels.next();
                    if (!rel.getName().equals(varDef.getName())) continue;
                    found = true;
                }
            }
            Iterator itPattCall = body.getCalledPatterns().iterator();
            while (!found && itPattCall.hasNext()) {
                GTPatternCall pattCall = (GTPatternCall)itPattCall.next();
                Iterator itParams = pattCall.getActualParameters().iterator();
                while (!found && itParams.hasNext()) {
                    Term param = (Term)itParams.next();
                    if (!(param instanceof VariableReference) || !param.getName().equals(varDef.getName())) continue;
                    found = true;
                }
            }
            Iterator itDangRels = body.getDanglingRelations().iterator();
            while (!found && itDangRels.hasNext()) {
                Relation rel = (Relation)itDangRels.next();
                if (!rel.getName().equals(varDef.getName())) continue;
                found = true;
            }
            Iterator itPVA = body.getVariableAssignments().iterator();
            while (!found && itPVA.hasNext()) {
                PatternVariableAssignment pva = (PatternVariableAssignment)itPVA.next();
                if (pva.getLeftValue().getName().equals(varDef.getName())) {
                    found = true;
                }
                if (!pva.getRightValue().getName().equals(varDef.getName())) continue;
                found = true;
            }
            if (found) continue;
            String[] context = new String[]{varDef.getName()};
            this.addReferenceResolutionError((List<?>)varDef.getAnnotations(), "Pattern parameter '{1}' is not defined locally. Please check if it is intentional.", ErrorInformation.ErrorSeverity.WARNING, context);
        }
    }

    public void validatePatternVariableConstraint(PatternVariableConstraint varAssign) {
        if (varAssign.getLeftValue().getName().equals(varAssign.getRightValue().getName())) {
            this.addReferenceResolutionError((List<?>)varAssign.getAnnotations(), "The left and right values of a pattern variable constraint should be different", ErrorInformation.ErrorSeverity.ERROR, new String[0]);
        }
    }

    private class TypeInfo {
        boolean isValid;
        IModelElement type;

        public TypeInfo(boolean isValid, IModelElement type) {
            this.isValid = isValid;
            this.type = type;
        }
    }
}

