/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.typechecker;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Constant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;

public class CustomTypeJudgementCheck {
    public static final String typeElementReference(IModelManager modelManager, Term operand) {
        if (operand instanceof Constant) {
            Constant constant = (Constant)operand;
            return constant.getValue();
        }
        return "TOP";
    }

    public static final String typeSource(IModelManager modelManager, String operand) {
        IModelElement element = modelManager.getElementByName(operand);
        if (element != null && element instanceof IRelation) {
            IRelation relation = (IRelation)element;
            return relation.getFrom().getFullyQualifiedName();
        }
        return "TOP";
    }

    public static final String typeTarget(IModelManager modelManager, String operand) {
        IModelElement element = modelManager.getElementByName(operand);
        if (element != null && element instanceof IRelation) {
            IRelation relation = (IRelation)element;
            return relation.getFrom().getFullyQualifiedName();
        }
        return "TOP";
    }

    public static final String typeInverse(IModelManager modelManager, String operand) {
        IRelation relation;
        IRelation inverse;
        IModelElement element = modelManager.getElementByName(operand);
        if (element != null && element instanceof IRelation && (inverse = (relation = (IRelation)element).getInverse()) != null) {
            return inverse.getFullyQualifiedName();
        }
        return "TOP";
    }
}

