/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.lpgparser.typechecker;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.errors.info.ErrorInformation;
import org.eclipse.viatra2.errors.info.Location;
import org.eclipse.viatra2.gtasm.typerules.BinaryTypeJudgement;
import org.eclipse.viatra2.gtasm.typerules.CustomTypeJudgement;
import org.eclipse.viatra2.gtasm.typerules.RuleSet;
import org.eclipse.viatra2.gtasm.typerules.TypeJudgement;
import org.eclipse.viatra2.gtasm.typerules.TypeRule;
import org.eclipse.viatra2.gtasm.typerules.TyperulesPackage;
import org.eclipse.viatra2.gtasm.typerules.UnaryTypeJudgement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.Annotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.ASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.DefinitionsFactory;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.InitialValue;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.SymbolicRuleParameter;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.TypeConstant;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.Variable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.definitions.VariableDefinition;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.CallRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.GTRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdate;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdateASMFunction;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.RuleUpdateVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ASMFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.FunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.GTPatternCall;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.ModelElementQuery;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.NativeFunctionInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.Term;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ArithmeticOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.ConversionOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.builtInFunctions.RelationalOperation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPatternBody;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariable;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.PatternVariableAssignment;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Entity;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.ModelElement;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relation;
import org.eclipse.viatra2.gtasmmodel.vpm.editmodel.Relationship;
import org.eclipse.viatra2.lpgparser.typechecker.CustomTypeJudgementCheck;
import org.eclipse.viatra2.lpgparser.typechecker.StringPair;
import org.eclipse.viatra2.lpgparser.typechecker.StringTriple;
import org.eclipse.viatra2.lpgparser.typechecker.TermTypeChecker;
import org.eclipse.viatra2.lpgparser.typechecker.TypeResolver;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VTCLTypeChecker {
    private static final String PARSER_MARKER = "org.eclipse.viatra2.loaders.vtclparsermarker";
    private IModelSpace modelSpace;
    private IModelManager modelManager;
    private TypeResolver typeResolver = new TypeResolver();
    private RuleSet typeRuleSet = null;
    private Map<String, List<CustomTypeJudgement>> customTypeRuleMap = null;
    private Map<StringTriple, BinaryTypeJudgement> binaryTypeRuleMap = null;
    private Map<StringPair, UnaryTypeJudgement> unaryTypeRuleMap = null;
    private List<Term> termsToCheck = new ArrayList<Term>();
    private List<GTRuleInvocation> gtRuleInvocsToCheck = new ArrayList<GTRuleInvocation>();
    private List<CallRule> asmCallRuleToCheck = new ArrayList<CallRule>();
    private List<ASMFunctionInvocation> asmFunInvocsToCheck = new ArrayList<ASMFunctionInvocation>();
    private List<NativeFunctionInvocation> nativeFunInvocsToCheck = new ArrayList<NativeFunctionInvocation>();
    private List<GTPatternCall> patternCallToCheck = new ArrayList<GTPatternCall>();
    private List<RuleUpdate> updateRulesToCheck = new ArrayList<RuleUpdate>();
    private List<InitialValue> initValuesToCheck = new ArrayList<InitialValue>();
    private List<VariableDefinition> varDefsToCheck = new ArrayList<VariableDefinition>();
    private List<GTPattern> gtPatternDefToCheck = new ArrayList<GTPattern>();
    private List<ErrorInformation> typeErrorInfos = new ArrayList<ErrorInformation>();
    protected final String[] longTypeCheckList = new String[]{"MYSELF", "STAR", "SUPERTYPE", "ENTITY", "RELATION", "MODELELEMENT"};
    protected final String[] builtInTypeCheckList = new String[]{"MYSELF", "STAR"};
    protected final String[] topTypeCheckList = new String[]{"TOP", "STAR"};
    protected final String[] bottomTypeCheckList = new String[]{"BOTTOM"};

    public VTCLTypeChecker(IModelSpace aModelSpace) {
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelSpace = aModelSpace;
        this.modelManager = this.modelSpace.getModelManager();
        this.typeRuleSet = null;
        try {
            this.initializeTypeRuleSet();
        }
        catch (VPMRuntimeException e) {
            e.printStackTrace();
        }
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public List<Term> getTermsToCheck() {
        return this.termsToCheck;
    }

    public List<ASMFunctionInvocation> getAsmFunInvocsToCheck() {
        return this.asmFunInvocsToCheck;
    }

    public List<NativeFunctionInvocation> getNativeFunInvocsToCheck() {
        return this.nativeFunInvocsToCheck;
    }

    public List<GTRuleInvocation> getGtRuleInvocsToCheck() {
        return this.gtRuleInvocsToCheck;
    }

    public List<CallRule> getAsmCallRuleToCheck() {
        return this.asmCallRuleToCheck;
    }

    public List<GTPatternCall> getPatternCallToCheck() {
        return this.patternCallToCheck;
    }

    public List<RuleUpdate> getUpdateRulesToCheck() {
        return this.updateRulesToCheck;
    }

    public List<InitialValue> getInitValuesToCheck() {
        return this.initValuesToCheck;
    }

    public List<VariableDefinition> getVarDefsToCheck() {
        return this.varDefsToCheck;
    }

    public List<GTPattern> getPatternDefToCheck() {
        return this.gtPatternDefToCheck;
    }

    public List<ErrorInformation> getAllTypeErrorInfos() {
        return this.typeErrorInfos;
    }

    public void clearAllTypeErrors() {
        this.typeErrorInfos.clear();
    }

    public void addTypeError(List<?> annotations, String errorString, ErrorInformation.ErrorSeverity errorSeverity, String[] context) {
        Annotation locInfo = this.lookupAnnotation("node_info", annotations);
        Location location = new Location(locInfo != null ? locInfo.getValue() : "0,0,0,0");
        ErrorInformation errorInfo = new ErrorInformation(errorString, PARSER_MARKER, ErrorInformation.ErrorKind.VALIDATION_ERROR, location, errorSeverity);
        errorInfo.bind(context);
        this.typeErrorInfos.add(errorInfo);
    }

    public void loadTypeRules(File file) throws VPMRuntimeException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http:///typerules.ecore", (Object)TyperulesPackage.eINSTANCE);
        Resource res = resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        try {
            res.load(null);
        }
        catch (IOException iOException) {
            throw new VPMRuntimeException("Type rules cannot be loaded");
        }
        if (res.getContents().get(0) instanceof RuleSet) {
            RuleSet rs = (RuleSet)res.getContents().get(0);
            rs.setExtends(this.typeRuleSet);
            this.typeRuleSet = rs;
        }
    }

    public void initializeTypeChecker() {
        this.clearAllTypeErrors();
        this.clearLists();
    }

    private void clearLists() {
        this.termsToCheck.clear();
        this.asmCallRuleToCheck.clear();
        this.gtRuleInvocsToCheck.clear();
        this.asmFunInvocsToCheck.clear();
        this.nativeFunInvocsToCheck.clear();
        this.patternCallToCheck.clear();
        this.updateRulesToCheck.clear();
        this.initValuesToCheck.clear();
        this.varDefsToCheck.clear();
        this.gtPatternDefToCheck.clear();
    }

    public void doTypeChecking() {
        try {
            assert (this.typeErrorInfos.isEmpty()) : "Type error list is not empty";
            for (GTPattern patternDef : this.gtPatternDefToCheck) {
                this.typeCheckPatternDefinition(patternDef);
            }
            for (Term term : this.termsToCheck) {
                this.typeCheckTerm(term);
            }
            for (CallRule callRule : this.asmCallRuleToCheck) {
                this.typeCheckCallRule(callRule);
            }
            for (GTRuleInvocation gtRuleInvoc : this.gtRuleInvocsToCheck) {
                this.typeCheckGTRuleCall(gtRuleInvoc);
            }
            for (ASMFunctionInvocation asmFunInvoc : this.asmFunInvocsToCheck) {
                this.typeCheckAsmFunctionInvocation(asmFunInvoc);
            }
            for (NativeFunctionInvocation nativeFunInvoc : this.nativeFunInvocsToCheck) {
                this.typeCheckNativeFunctionInvocation(nativeFunInvoc);
            }
            for (GTPatternCall patternCall : this.patternCallToCheck) {
                this.typeCheckPatternCall(patternCall);
            }
            for (RuleUpdate updateRule : this.updateRulesToCheck) {
                this.typeCheckUpdateRule(updateRule);
            }
            for (InitialValue initValue : this.initValuesToCheck) {
                this.typeCheckInitialValue(initValue);
            }
            for (VariableDefinition varDef : this.varDefsToCheck) {
                this.typeCheckVariableDefinition(varDef);
            }
        }
        finally {
            this.clearLists();
        }
    }

    protected void initializeTypeRuleSet() throws VPMRuntimeException {
        File file;
        String bundleStr = "org.eclipse.viatra2.gtasm.typing.model";
        String fileName = "/model/VTCLCore.typerules";
        try {
            file = this.getFileFromBundle(bundleStr, fileName);
        }
        catch (IOException iOException) {
            throw new VPMRuntimeException("Type rule file cannot be found");
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http:///typerules.ecore", (Object)TyperulesPackage.eINSTANCE);
        Resource res = resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        try {
            res.load(null);
        }
        catch (IOException iOException) {
            throw new VPMRuntimeException("Type rules cannot be loaded");
        }
        if (res.getContents().get(0) instanceof RuleSet) {
            this.typeRuleSet = (RuleSet)res.getContents().get(0);
        }
        if (this.typeRuleSet != null) {
            this.binaryTypeRuleMap = new HashMap<StringTriple, BinaryTypeJudgement>();
            this.unaryTypeRuleMap = new HashMap<StringPair, UnaryTypeJudgement>();
            this.customTypeRuleMap = new HashMap<String, List<CustomTypeJudgement>>();
            for (TypeRule typeRule : this.typeRuleSet.getTyperules()) {
                List<CustomTypeJudgement> customList = null;
                for (TypeJudgement judgement : typeRule.getJudgements()) {
                    if (judgement instanceof BinaryTypeJudgement) {
                        BinaryTypeJudgement binaryJudge = (BinaryTypeJudgement)judgement;
                        StringTriple triple = new StringTriple(typeRule.getOperator(), binaryJudge.getFirstOperand(), binaryJudge.getSecondOperand());
                        this.binaryTypeRuleMap.put(triple, binaryJudge);
                        continue;
                    }
                    if (judgement instanceof UnaryTypeJudgement) {
                        UnaryTypeJudgement unaryJudge = (UnaryTypeJudgement)judgement;
                        StringPair pair = new StringPair(typeRule.getOperator(), unaryJudge.getOperand());
                        this.unaryTypeRuleMap.put(pair, unaryJudge);
                        continue;
                    }
                    if (!(judgement instanceof CustomTypeJudgement)) continue;
                    CustomTypeJudgement customJudge = (CustomTypeJudgement)judgement;
                    customList = this.customTypeRuleMap.get(typeRule.getOperator());
                    if (customList == null) {
                        customList = new ArrayList<CustomTypeJudgement>();
                    }
                    customList.add(customJudge);
                }
                this.customTypeRuleMap.put(typeRule.getOperator(), customList);
            }
        }
    }

    protected void typeCheckPatternDefinition(GTPattern patternDef) {
        for (Object param : patternDef.getSymParameters()) {
            PatternVariable patternVar = (PatternVariable)param;
            TypeConstant typeConst = DefinitionsFactory.eINSTANCE.createTypeConstant();
            typeConst.setKind(ValueKind.UNDEF_LITERAL);
            typeConst.setFqn("TOP");
            for (Object varRefObj : patternVar.getReferences()) {
                VariableReference varRef = (VariableReference)varRefObj;
                typeConst = this.inferTypeForPatternVariableRef(varRef, typeConst);
            }
            this.inferTypeForPatternVariableDef(patternVar, typeConst);
        }
        for (Object bodyObj : patternDef.getPatternBodies()) {
            GTPatternBody body = (GTPatternBody)bodyObj;
            for (Object varObj : body.getLocalVariables()) {
                PatternVariable patternVar = (PatternVariable)varObj;
                TypeConstant typeConst = DefinitionsFactory.eINSTANCE.createTypeConstant();
                typeConst.setKind(ValueKind.UNDEF_LITERAL);
                typeConst.setFqn("TOP");
                for (Object varRefObj : patternVar.getReferences()) {
                    VariableReference varRef = (VariableReference)varRefObj;
                    typeConst = this.inferTypeForPatternVariableRef(varRef, typeConst);
                }
                this.inferTypeForPatternVariableDef(patternVar, typeConst);
            }
        }
    }

    protected TypeConstant inferTypeForPatternVariableRef(VariableReference varRef, TypeConstant prevTypeConst) {
        ValueKind kind;
        EObject parent = varRef.eContainer();
        String typeStr = null;
        if (parent instanceof ModelElement) {
            ModelElement element = (ModelElement)parent;
            if (varRef.equals(element.getVariableReferences().get(0)) || prevTypeConst == null) {
                if (!element.getType().isEmpty()) {
                    ModelElement type = (ModelElement)element.getType().get(0);
                    typeStr = type.getName();
                } else {
                    typeStr = parent instanceof Entity ? "ENTITY" : (parent instanceof Relation ? "RELATION" : "MODELELEMENT");
                }
                if (prevTypeConst != null && !prevTypeConst.getKind().equals((Object)ValueKind.UNDEF_LITERAL)) {
                    typeStr = this.typeResolver.leastUpperBound(this.modelManager, typeStr, prevTypeConst.getFqn());
                }
            } else {
                typeStr = this.typeResolver.greatestLowerBound(this.modelManager, "MODELELEMENT", prevTypeConst.getFqn());
            }
            kind = ValueKind.MODELELEMENT_LITERAL;
            this.termsToCheck.add((Term)varRef);
        } else if (parent instanceof Relationship) {
            typeStr = "MODELELEMENT";
            kind = ValueKind.MODELELEMENT_LITERAL;
            this.termsToCheck.add((Term)varRef);
            if (prevTypeConst != null) {
                typeStr = this.typeResolver.greatestLowerBound(this.modelManager, typeStr, prevTypeConst.getFqn());
            }
        } else if (parent instanceof PatternVariableAssignment) {
            typeStr = "MODELELEMENT";
            kind = ValueKind.MODELELEMENT_LITERAL;
            this.termsToCheck.add((Term)varRef);
            if (prevTypeConst != null) {
                typeStr = this.typeResolver.greatestLowerBound(this.modelManager, typeStr, prevTypeConst.getFqn());
            }
        } else if (prevTypeConst != null) {
            typeStr = prevTypeConst.getFqn();
            kind = prevTypeConst.getKind();
        } else {
            typeStr = "TOP";
            kind = ValueKind.MODELELEMENT_LITERAL;
        }
        if (typeStr.contentEquals("MODELELEMENT") || typeStr.contentEquals("ENTITY") || typeStr.contentEquals("RELATION")) {
            return null;
        }
        TypeConstant resultTypeConst = DefinitionsFactory.eINSTANCE.createTypeConstant();
        resultTypeConst.setFqn(typeStr);
        resultTypeConst.setKind(kind);
        varRef.setType(typeStr);
        varRef.setKind(kind);
        return resultTypeConst;
    }

    protected void inferTypeForPatternVariableDef(PatternVariable varDef, TypeConstant typeConst) {
        if (varDef.getVariableType() == null && typeConst != null) {
            varDef.setVariableType(typeConst);
        }
    }

    protected void typecheckPatternBody(GTPatternBody body) {
        for (Object paramObject : body.getHeader().getSymParameters()) {
            PatternVariable param = (PatternVariable)paramObject;
            for (Object varRefObj : param.getReferences()) {
                VariableReference varRef = (VariableReference)varRefObj;
                EObject parent = varRef.eContainer();
                if (parent instanceof ModelElement) {
                    ModelElement element = (ModelElement)parent;
                    if (!element.getType().isEmpty()) {
                        ModelElement type = (ModelElement)element.getType().get(0);
                        String typeStr = type.getName();
                        varRef.setType(typeStr);
                    } else if (parent instanceof Entity) {
                        varRef.setType("ENTITY");
                    } else if (parent instanceof Relation) {
                        varRef.setType("RELATION");
                    } else {
                        varRef.setType("MODELELEMENT");
                    }
                    varRef.setKind(ValueKind.MODELELEMENT_LITERAL);
                    continue;
                }
                boolean cfr_ignored_0 = parent instanceof PatternVariableAssignment;
            }
        }
    }

    protected void typeCheckTerm(Term term) {
        if (term instanceof RelationalOperation || term instanceof ArithmeticOperation || term instanceof ConversionOperation) {
            FunctionInvocation funInvoc = (FunctionInvocation)term;
            if (funInvoc.getActualParameters().size() == 1) {
                Term operand = (Term)funInvoc.getActualParameters().get(0);
                if (operand.getType() == null) {
                    this.typeCheckTerm(operand);
                }
                this.typeCheckUnaryTerm(term, operand);
            } else if (funInvoc.getActualParameters().size() == 2) {
                Term rightOperand;
                Term leftOperand = (Term)funInvoc.getActualParameters().get(0);
                if (leftOperand.getType() == null) {
                    this.typeCheckTerm(leftOperand);
                }
                if ((rightOperand = (Term)funInvoc.getActualParameters().get(1)).getType() == null) {
                    this.typeCheckTerm(rightOperand);
                }
                this.typeCheckBinaryTerm(term, leftOperand, rightOperand);
            }
        } else if (term instanceof ASMFunctionInvocation) {
            ASMFunctionInvocation asmFunInvoc = (ASMFunctionInvocation)term;
            for (Object param : asmFunInvoc.getActualParameters()) {
                Term actualParam = (Term)param;
                if (actualParam.getType() != null) continue;
                this.typeCheckTerm(actualParam);
            }
            ASMFunction asmFunDef = asmFunInvoc.getCalledFunction();
            assert (asmFunDef != null) : "ASM function definition is not resolved for " + asmFunInvoc.getFqn();
            if (asmFunDef.getReturnType() != null) {
                TypeConstant type = asmFunDef.getReturnType();
                asmFunInvoc.setType(type.getFqn());
                asmFunInvoc.setKind(type.getKind());
            } else {
                asmFunInvoc.setType("TOP");
                asmFunInvoc.setKind(ValueKind.UNDEF_LITERAL);
            }
        } else if (term instanceof NativeFunctionInvocation) {
            NativeFunctionInvocation nativeFunInvoc = (NativeFunctionInvocation)term;
            for (Object param : nativeFunInvoc.getActualParameters()) {
                Term actualParam = (Term)param;
                if (actualParam.getType() != null) continue;
                this.typeCheckTerm(actualParam);
            }
            nativeFunInvoc.setType("TOP");
            nativeFunInvoc.setKind(ValueKind.UNDEF_LITERAL);
        } else if (term instanceof ModelElementQuery) {
            ModelElementQuery meQuery = (ModelElementQuery)term;
            Term argument = meQuery.getArgument();
            if (argument.getType() == null) {
                this.typeCheckTerm(argument);
            }
            this.typeCheckUnaryTerm(term, argument);
        } else if (term instanceof GTPatternCall) {
            GTPatternCall patternCall = (GTPatternCall)term;
            for (Object param : patternCall.getActualParameters()) {
                Term actualParam = (Term)param;
                if (actualParam.getType() != null) continue;
                this.typeCheckTerm(actualParam);
            }
            patternCall.setKind(ValueKind.BOOLEAN_LITERAL);
            patternCall.setType("datatypes.Boolean");
        } else if (term instanceof VariableReference) {
            VariableReference varRef = (VariableReference)term;
            this.typeCheckVariableReference(varRef);
        }
    }

    protected void typeCheckVariableReference(VariableReference varRef) {
        Variable varDef = varRef.getVariable();
        if (varDef == null) {
            varRef.setType("TOP");
            varRef.setKind(ValueKind.UNDEF_LITERAL);
            return;
        }
        if (varDef.getVariableType() != null) {
            TypeConstant typeConstant = varDef.getVariableType();
            String typeStr = typeConstant.getFqn();
            ValueKind kind = typeConstant.getKind();
            if (typeStr != null && !typeStr.equals("")) {
                assert (kind != null) : "Kind of type constant is not yet set";
                if (varRef.getType() == null) {
                    varRef.setType(typeStr);
                    varRef.setKind(kind);
                } else if (!this.typeResolver.isSupertype(this.modelManager, typeStr, varRef.getType())) {
                    String[] context = new String[]{varRef.getType(), typeStr};
                    this.addTypeError((List<?>)varRef.getAnnotations(), "The type '{1}' of variable reference is not compatible with the type '{2}' of its definition.", ErrorInformation.ErrorSeverity.WARNING, context);
                }
            } else if (varRef.getType() == null) {
                varRef.setType("TOP");
                varRef.setKind(ValueKind.UNDEF_LITERAL);
            }
        } else if (varRef.getType() == null) {
            varRef.setType("TOP");
            varRef.setKind(ValueKind.UNDEF_LITERAL);
        }
    }

    protected void typeCheckGTRuleCall(GTRuleInvocation gtRuleInvoc) {
        GTRule gtRuleDef = gtRuleInvoc.getRule();
        assert (gtRuleDef != null) : "GT rule is not resolved for " + gtRuleInvoc.getFqn();
        assert (gtRuleDef.getSymParameters().size() == gtRuleInvoc.getActualParameters().size()) : "Parameter mismatch in GT rule invocation";
        int i = 0;
        while (i < gtRuleDef.getSymParameters().size()) {
            TypeConstant type;
            SymbolicRuleParameter symParam = (SymbolicRuleParameter)gtRuleDef.getSymParameters().get(i);
            Variable varDef = symParam.getVariable();
            assert (varDef != null) : "Variable is not resolved for Symbolic parameter";
            Term actualParam = (Term)gtRuleInvoc.getActualParameters().get(i);
            if (varDef.getVariableType() != null && !this.typeResolver.isSupertype(this.modelManager, (type = varDef.getVariableType()).getFqn(), actualParam.getType())) {
                String[] context = new String[]{actualParam.getType(), type.getFqn(), varDef.getName(), gtRuleInvoc.getFqn()};
                this.addTypeError((List<?>)actualParam.getAnnotations(), "The type '{1}' of actual parameter is not compatible with the type '{2}' of symbolic parameter '{3}'. See the definition of '{4}'.", ErrorInformation.ErrorSeverity.WARNING, context);
            }
            ++i;
        }
    }

    protected void typeCheckPatternCall(GTPatternCall patternCall) {
        GTPattern patternDef = patternCall.getCalledPattern();
        assert (patternDef != null) : "Pattern definition is not resolved";
        assert (patternDef.getSymParameters().size() == patternCall.getActualParameters().size()) : "Parameter mismatch in pattern call";
        int i = 0;
        while (i < patternDef.getSymParameters().size()) {
            PatternVariable symParam = (PatternVariable)patternDef.getSymParameters().get(i);
            Term actualParam = (Term)patternCall.getActualParameters().get(i);
            if (symParam.getVariableType() != null) {
                TypeConstant type = symParam.getVariableType();
                String actualParamType = actualParam.getType();
                String paramType = type.getFqn();
                if (!this.typeResolver.isSupertype(this.modelManager, paramType, actualParamType) && !this.typeResolver.isSupertype(this.modelManager, actualParamType, paramType)) {
                    String[] context = new String[]{actualParamType, paramType, symParam.getName(), patternCall.getFqn()};
                    this.addTypeError((List<?>)actualParam.getAnnotations(), "The type '{1}' of actual parameter is not compatible with the type '{2}' of symbolic parameter '{3}'. See the definition of '{4}'.", ErrorInformation.ErrorSeverity.WARNING, context);
                }
            }
            ++i;
        }
    }

    protected void typeCheckCallRule(CallRule callRule) {
        Rule ruleDef = callRule.getRule();
        assert (ruleDef != null) : "ASM rule is not resolved";
        assert (ruleDef.getSymParameters().size() == callRule.getActualParameters().size()) : "Parameter mismatch in call rule";
        int i = 0;
        while (i < ruleDef.getSymParameters().size()) {
            TypeConstant type;
            SymbolicRuleParameter symParam = (SymbolicRuleParameter)ruleDef.getSymParameters().get(i);
            Variable varDef = symParam.getVariable();
            assert (varDef != null) : "Variable cannot be resolved for Symbolic rule parameter";
            Term actualParam = (Term)callRule.getActualParameters().get(i);
            if (varDef.getVariableType() != null && !this.typeResolver.isSupertype(this.modelManager, (type = varDef.getVariableType()).getFqn(), actualParam.getType())) {
                String[] context = new String[]{actualParam.getType(), type.getFqn(), varDef.getName(), callRule.getFqn()};
                this.addTypeError((List<?>)actualParam.getAnnotations(), "The type '{1}' of actual parameter is not compatible with the type '{2}' of symbolic parameter '{3}'. See the definition of '{4}'.", ErrorInformation.ErrorSeverity.WARNING, context);
            }
            ++i;
        }
    }

    protected void typeCheckUpdateRule(RuleUpdate updateRule) {
        String leftValueType = "";
        if (updateRule instanceof RuleUpdateVariable) {
            RuleUpdateVariable varUpdateRule = (RuleUpdateVariable)updateRule;
            VariableReference varRef = varUpdateRule.getVariable();
            assert (varRef != null);
            leftValueType = varRef.getType();
        } else if (updateRule instanceof RuleUpdateASMFunction) {
            RuleUpdateASMFunction asmFunUpdateRule = (RuleUpdateASMFunction)updateRule;
            ASMFunction asmFunDef = asmFunUpdateRule.getFunction();
            assert (asmFunDef != null);
            TypeConstant typeConst = asmFunDef.getReturnType();
            leftValueType = typeConst != null ? typeConst.getFqn() : "TOP";
            if (!asmFunDef.getArgumentTypes().isEmpty()) {
                int i = 0;
                while (i < asmFunUpdateRule.getLocations().size()) {
                    Term term = (Term)asmFunUpdateRule.getLocations().get(i);
                    TypeConstant typeConstArg = (TypeConstant)asmFunDef.getArgumentTypes().get(i);
                    this.typeCheckCompatibility((AnnotatedElement)term, typeConstArg.getFqn(), term.getType());
                    ++i;
                }
            }
        }
        Term value = updateRule.getValue();
        assert (value != null);
        String rightValueType = value.getType();
        if (!this.typeResolver.isSupertype(this.modelManager, leftValueType, rightValueType)) {
            String[] context = new String[]{leftValueType, rightValueType};
            this.addTypeError((List<?>)updateRule.getAnnotations(), "Type incompatible assignment: left value is of type '{1}', right value is of type '{2}'.", ErrorInformation.ErrorSeverity.WARNING, context);
        }
    }

    protected void typeCheckNativeFunctionInvocation(NativeFunctionInvocation nativeFunInvoc) {
    }

    protected void typeCheckAsmFunctionInvocation(ASMFunctionInvocation asmFunInvoc) {
        ASMFunction asmFun = asmFunInvoc.getCalledFunction();
        assert (asmFun != null);
        if (!asmFun.getArgumentTypes().isEmpty()) {
            int i = 0;
            while (i < asmFunInvoc.getActualParameters().size()) {
                Term term = (Term)asmFunInvoc.getActualParameters().get(i);
                TypeConstant typeConst = (TypeConstant)asmFun.getArgumentTypes().get(i);
                this.typeCheckCompatibility((AnnotatedElement)term, typeConst.getFqn(), term.getType());
                ++i;
            }
        }
    }

    protected void typeCheckInitialValue(InitialValue initValue) {
        ASMFunction asmFun = (ASMFunction)initValue.eContainer();
        if (!asmFun.getArgumentTypes().isEmpty()) {
            int i = 0;
            while (i < initValue.getLocations().size()) {
                Term term = (Term)initValue.getLocations().get(i);
                TypeConstant typeConst = (TypeConstant)asmFun.getArgumentTypes().get(i);
                this.typeCheckCompatibility((AnnotatedElement)term, typeConst.getFqn(), term.getType());
                ++i;
            }
        }
        if (asmFun.getReturnType() != null) {
            Term term = initValue.getValue();
            TypeConstant typeConst = asmFun.getReturnType();
            this.typeCheckCompatibility((AnnotatedElement)term, typeConst.getFqn(), term.getType());
        }
    }

    protected void typeCheckVariableDefinition(VariableDefinition varDefine) {
        Variable var = varDefine.getVariable();
        TypeConstant typeConst = var.getVariableType();
        if (typeConst != null) {
            Term initValue = varDefine.getValue();
            this.typeCheckCompatibility((AnnotatedElement)varDefine, typeConst.getFqn(), initValue.getType());
        }
    }

    protected void typeCheckCompatibility(AnnotatedElement element, String supertypeStr, String subtypeStr) {
        if (!this.typeResolver.isSupertype(this.modelManager, supertypeStr, subtypeStr)) {
            String[] context = new String[]{supertypeStr, subtypeStr};
            this.addTypeError((List<?>)element.getAnnotations(), "Type incompatible initialization: expecting a term of type '{1}' instead of '{2}'.", ErrorInformation.ErrorSeverity.WARNING, context);
        }
    }

    protected void typeCheckBinaryTerm(Term term, Term leftOperand, Term rightOperand) {
        ValueKind resultKind = TermTypeChecker.typeCheck(term, leftOperand.getKind(), rightOperand.getKind());
        term.setKind(resultKind);
        String resultType = this.typeCheckBinaryTerm(term.eClass().getName(), leftOperand, rightOperand);
        term.setType(resultType);
        if (resultType.equals("BOTTOM")) {
            String[] context = new String[]{TermTypeChecker.getOperationString(term), leftOperand.getType(), rightOperand.getType()};
            this.addTypeError((List<?>)term.getAnnotations(), "Operator '{1}' is undefined for the argument types ('{2}', '{3}')", ErrorInformation.ErrorSeverity.WARNING, context);
        }
    }

    protected void typeCheckUnaryTerm(Term term, Term operand) {
        ValueKind resultKind = TermTypeChecker.typeCheck(term, operand.getKind());
        term.setKind(resultKind);
        String resultType = this.typeCheckUnaryTerm(term.eClass().getName(), operand);
        term.setType(resultType);
        if (resultType.equals("BOTTOM")) {
            String[] context = new String[]{TermTypeChecker.getOperationString(term), operand.getType()};
            this.addTypeError((List<?>)term.getAnnotations(), "Operator '{1}' is undefined for the argument type ('{2}')", ErrorInformation.ErrorSeverity.WARNING, context);
        }
    }

    protected String nextTypeToCheck(String typeCode, String operand) {
        if (typeCode.equals(String.valueOf("MYSELF"))) {
            return operand;
        }
        if (typeCode.equals(String.valueOf("STAR"))) {
            return String.valueOf("*");
        }
        if (typeCode.equals(String.valueOf("SUPERTYPE"))) {
            return String.valueOf("SUPERTYPE");
        }
        return typeCode;
    }

    private String[] createTypeCheckList(ValueKind kind, String type) {
        if (kind.equals((Object)ValueKind.MODELELEMENT_LITERAL)) {
            IModelElement element = this.modelManager.getElementByName(type);
            if (element != null) {
                if (element.isEntity()) {
                    String[] resultList = new String[]{"MYSELF", "STAR", "SUPERTYPE", "ENTITY", "MODELELEMENT"};
                    return resultList;
                }
                if (element.isRelation()) {
                    String[] resultList = new String[]{"MYSELF", "STAR", "SUPERTYPE", "RELATION", "MODELELEMENT"};
                    return resultList;
                }
                String[] resultList = new String[]{"MYSELF", "STAR", "SUPERTYPE", "MODELELEMENT"};
                return resultList;
            }
            if (type.equals("ENTITY") || type.equals("entity")) {
                String[] resultList = new String[]{"STAR", "ENTITY", "MODELELEMENT"};
                return resultList;
            }
            if (type.equals("RELATION") || type.equals("relation")) {
                String[] resultList = new String[]{"STAR", "RELATION", "MODELELEMENT"};
                return resultList;
            }
            String[] resultList = new String[]{"STAR", "MODELELEMENT"};
            return resultList;
        }
        if (kind.equals((Object)ValueKind.UNDEF_LITERAL)) {
            return this.topTypeCheckList;
        }
        if (kind.equals((Object)ValueKind.ERROR_LITERAL)) {
            return this.bottomTypeCheckList;
        }
        return this.builtInTypeCheckList;
    }

    protected String typeCheckBinaryTerm(String termClassName, Term leftOperandTerm, Term rightOperandTerm) {
        String leftOperand = leftOperandTerm.getType();
        String rightOperand = rightOperandTerm.getType();
        ValueKind leftKind = leftOperandTerm.getKind();
        ValueKind rightKind = rightOperandTerm.getKind();
        String[] leftCheckList = this.createTypeCheckList(leftKind, leftOperand);
        String[] rightCheckList = this.createTypeCheckList(rightKind, rightOperand);
        String[] stringArray = leftCheckList;
        int n = leftCheckList.length;
        int n2 = 0;
        while (n2 < n) {
            String leftType = stringArray[n2];
            String leftCheck = this.nextTypeToCheck(leftType, leftOperand);
            String[] stringArray2 = rightCheckList;
            int n3 = rightCheckList.length;
            int n4 = 0;
            while (n4 < n3) {
                String rightType = stringArray2[n4];
                String rightCheck = this.nextTypeToCheck(rightType, rightOperand);
                StringTriple triple = new StringTriple(termClassName, leftCheck, rightCheck);
                BinaryTypeJudgement judgement = this.binaryTypeRuleMap.get(triple);
                if (judgement != null) {
                    return judgement.getResult();
                }
                ++n4;
            }
            ++n2;
        }
        return "BOTTOM";
    }

    protected String typeCheckUnaryTerm(String termClassName, Term operand) {
        String[] leftCheckList;
        String operandStr = operand.getType();
        String resultType = "BOTTOM";
        List<CustomTypeJudgement> customList = this.customTypeRuleMap.get(termClassName);
        if (customList != null) {
            for (CustomTypeJudgement customJudgement : customList) {
                if (customJudgement.getName().equals("typeSource")) {
                    resultType = CustomTypeJudgementCheck.typeSource(this.modelManager, operandStr);
                    continue;
                }
                if (customJudgement.getName().equals("typeTarget")) {
                    resultType = CustomTypeJudgementCheck.typeTarget(this.modelManager, operandStr);
                    continue;
                }
                if (customJudgement.getName().equals("typeInverse")) {
                    resultType = CustomTypeJudgementCheck.typeInverse(this.modelManager, operandStr);
                    continue;
                }
                if (!customJudgement.getName().equals("typeElementReference")) continue;
                resultType = CustomTypeJudgementCheck.typeElementReference(this.modelManager, operand);
            }
        }
        if (resultType != "BOTTOM") {
            return resultType;
        }
        ValueKind leftKind = operand.getKind();
        String[] stringArray = leftCheckList = this.createTypeCheckList(leftKind, operandStr);
        int n = leftCheckList.length;
        int n2 = 0;
        while (n2 < n) {
            String leftType = stringArray[n2];
            String leftCheck = this.nextTypeToCheck(leftType, operandStr);
            StringPair pair = new StringPair(termClassName, leftCheck);
            UnaryTypeJudgement judgement = this.unaryTypeRuleMap.get(pair);
            if (judgement != null) {
                return judgement.getResult();
            }
            ++n2;
        }
        return resultType;
    }

    protected File getFileFromBundle(String bundleId, String path) throws IOException {
        URL url;
        URL fullPathString;
        File f;
        block3: {
            f = null;
            Bundle bundle = Platform.getBundle((String)bundleId);
            fullPathString = null;
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            if (url != null) break block3;
            return null;
        }
        try {
            fullPathString = FileLocator.toFileURL((URL)url);
            java.net.URI uri = fullPathString.toURI();
            f = new File(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            f = new File(fullPathString.getPath());
        }
        return f;
    }

    public Annotation lookupAnnotation(String key, List<?> annotations) {
        boolean found = false;
        Annotation annotation = null;
        Iterator<?> iter1 = annotations.iterator();
        while (!found && iter1.hasNext()) {
            annotation = (Annotation)iter1.next();
            if (!annotation.getKey().equals(key)) continue;
            found = true;
        }
        return annotation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AbstractionKind {
        FIRST,
        SECOND,
        BOTH;

    }
}

