/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.intercept.custom.CustomInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessObservableMethod;
import org.apache.webbeans.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AfterBeanDiscoveryImpl
implements AfterBeanDiscovery {
    private BeanManagerImpl beanManager = null;
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(AfterBeanDiscoveryImpl.class);
    private final WebBeansContext webBeansContext;

    public AfterBeanDiscoveryImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    public void addBean(Bean<?> bean) {
        AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(bean.getBeanClass());
        GProcessBean processBeanEvent = new GProcessBean(bean, annotatedType);
        this.beanManager.fireEvent(processBeanEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (bean instanceof Interceptor) {
            ManagedBean managedBean = this.webBeansContext.getWebBeansUtil().defineManagedBeanWithoutFireEvents(annotatedType);
            CustomInterceptor interceptor = new CustomInterceptor(managedBean, (Interceptor)bean);
            if (interceptor.getScope() != Dependent.class && logger.wblWillLogWarn()) {
                logger.warn("WARN_0005_1", interceptor.getBeanClass().getName());
            }
            if (interceptor.getName() != null && logger.wblWillLogWarn()) {
                logger.warn("WARN_0005_2", interceptor.getBeanClass().getName());
            }
            if (interceptor.isAlternative() && logger.wblWillLogWarn()) {
                logger.warn("WARN_0005_3", interceptor.getBeanClass().getName());
            }
            this.beanManager.addInterceptor(interceptor);
            this.webBeansContext.getBeanManagerImpl().addCustomInterceptorClass(bean.getBeanClass());
        } else if (bean instanceof Decorator) {
            ManagedBean managedBean = this.webBeansContext.getWebBeansUtil().defineManagedBeanWithoutFireEvents(annotatedType);
            if (managedBean.getScope() != Dependent.class && logger.wblWillLogWarn()) {
                logger.warn("WARN_0005_1", managedBean.getBeanClass().getName());
            }
            if (managedBean.getName() != null && logger.wblWillLogWarn()) {
                logger.warn("WARN_0005_2", managedBean.getBeanClass().getName());
            }
            if (managedBean.isAlternative() && logger.wblWillLogWarn()) {
                logger.warn("WARN_0005_3", managedBean.getBeanClass().getName());
            }
            this.beanManager.addDecorator(new WebBeansDecorator(managedBean, (Decorator)bean));
            this.webBeansContext.getBeanManagerImpl().addCustomDecoratorClass(bean.getBeanClass());
        } else {
            this.beanManager.addBean(bean);
        }
    }

    public void addContext(Context context) {
        this.beanManager.addContext(context);
    }

    public void addDefinitionError(Throwable t) {
        this.beanManager.getErrorStack().pushError(t);
    }

    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        GProcessObservableMethod event = new GProcessObservableMethod(null, observerMethod);
        this.beanManager.fireEvent(event, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        this.beanManager.getNotificationManager().addObserver(observerMethod, observerMethod.getObservedType());
    }
}

