/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.service;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.webbeans.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManualImplementationLoaderService<T> {
    private static final String SERVICE_CONFIG = "META-INF/services/";
    private static final String FILE_ENCODING = "UTF-8";
    protected List<Class<?>> foundServiceClasses = new ArrayList();
    private Class<T> serviceType;
    private ClassLoader currentClassLoader;

    ManualImplementationLoaderService(Class<T> serviceType, ClassLoader currentClassLoader) {
        this.serviceType = serviceType;
        this.currentClassLoader = currentClassLoader;
    }

    List<T> loadServiceImplementations() {
        List<Class<?>> result = this.resolveServiceImplementations();
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<T> foundServices = new ArrayList<T>();
        for (Class<?> serviceClass : result) {
            foundServices.add(this.createInstance(serviceClass));
        }
        return foundServices;
    }

    private List<Class<?>> resolveServiceImplementations() {
        for (URL configFile : this.getConfigFileList()) {
            this.loadConfiguredServices(configFile);
        }
        return this.foundServiceClasses;
    }

    private List<URL> getConfigFileList() {
        ArrayList<URL> serviceFiles = new ArrayList<URL>();
        try {
            Enumeration<URL> serviceFileEnumerator = this.currentClassLoader.getResources(this.getConfigFileLocation());
            while (serviceFileEnumerator.hasMoreElements()) {
                serviceFiles.add(serviceFileEnumerator.nextElement());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load " + this.serviceType.getName() + " configured in " + this.getConfigFileLocation(), e);
        }
        return serviceFiles;
    }

    private String getConfigFileLocation() {
        return SERVICE_CONFIG + this.serviceType.getName();
    }

    private void loadConfiguredServices(URL serviceFile) {
        InputStream inputStream = null;
        try {
            String serviceClassName;
            inputStream = serviceFile.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, FILE_ENCODING));
            while ((serviceClassName = bufferedReader.readLine()) != null) {
                if ("".equals(serviceClassName = this.extractConfiguredServiceClassName(serviceClassName))) continue;
                this.loadService(serviceClassName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to process service-config: " + serviceFile, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to close " + serviceFile, e);
                }
            }
        }
    }

    private String extractConfiguredServiceClassName(String currentConfigLine) {
        int startOfComment = currentConfigLine.indexOf(35);
        if (startOfComment > -1) {
            currentConfigLine = currentConfigLine.substring(0, startOfComment);
        }
        return currentConfigLine.trim();
    }

    private void loadService(String serviceClassName) {
        Class<T> serviceClass = this.loadClass(serviceClassName);
        if (serviceClass != null && !this.foundServiceClasses.contains(serviceClass)) {
            this.foundServiceClasses.add(serviceClass);
        } else if (serviceClass == null) {
            throw new IllegalStateException(serviceClassName + " couldn't be loaded. " + "Please ensure that this class is in the classpath or remove the entry from " + this.getConfigFileLocation() + ".");
        }
    }

    private Class<? extends T> loadClass(String serviceClassName) {
        Class<?> targetClass = ClassUtil.getClassFromName(serviceClassName);
        if (targetClass == null && (targetClass = ManualImplementationLoaderService.loadClassForName(serviceClassName, this.currentClassLoader)) == null) {
            return null;
        }
        return targetClass.asSubclass(this.serviceType);
    }

    private static Class<?> loadClassForName(String serviceClassName, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        try {
            return classLoader.loadClass(serviceClassName);
        }
        catch (Exception e) {
            return ManualImplementationLoaderService.loadClassForName(serviceClassName, classLoader.getParent());
        }
    }

    private T createInstance(Class<?> serviceClass) {
        try {
            Constructor<?> constructor = serviceClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "Config file: " + this.getConfigFileLocation();
    }
}

