/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.internal.environment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.core.internal.environment.EFSFileHandle;

public class LocalEnvironment
implements IEnvironment,
IAdaptable {
    public static final String ENVIRONMENT_ID = "org.eclipse.dltk.mod.core.environment.localEnvironment";
    private static IEnvironment instance = new LocalEnvironment();
    private IFileSystem fs = EFS.getLocalFileSystem();

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public IFileHandle getFile(IPath path) {
        IFile[] files;
        if (path == null) {
            return null;
        }
        IFileStore store = this.fs.getStore(path);
        EFSFileHandle fileHandle = new EFSFileHandle(this, store);
        if (!fileHandle.exists() && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path)).length == 1) {
            store = this.fs.getStore(files[0].getLocation());
            fileHandle = new EFSFileHandle(this, store);
        }
        return fileHandle;
    }

    @Override
    public String getId() {
        return ENVIRONMENT_ID;
    }

    public static IEnvironment getInstance() {
        return instance;
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public char getSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public String getName() {
        return "Localhost";
    }

    @Override
    public String convertPathToString(IPath path) {
        return EnvironmentPathUtils.getLocalPath(path).toOSString();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    @Override
    public URI getURI(IPath location) {
        return URIUtil.toURI((IPath)location);
    }

    @Override
    public IFileHandle getFile(URI locationURI) {
        return new EFSFileHandle(this, this.fs.getStore(locationURI));
    }

    @Override
    public String getPathsSeparator() {
        return Character.toString(this.getPathsSeparatorChar());
    }

    @Override
    public char getPathsSeparatorChar() {
        return Platform.getOS().equals("win32") ? (char)';' : ':';
    }

    @Override
    public String getCanonicalPath(IPath path) {
        try {
            return path.toFile().getCanonicalFile().toString();
        }
        catch (IOException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return path.toOSString();
        }
    }
}

