/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ExternalFoldersManager;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ScriptProject;

public class ExternalFolderChange {
    private ScriptProject project;
    private IBuildpathEntry[] oldResolvedBuildpath;

    public ExternalFolderChange(ScriptProject project, IBuildpathEntry[] oldResolvedBuildpath) {
        this.project = project;
        this.oldResolvedBuildpath = oldResolvedBuildpath;
    }

    public void updateExternalFoldersIfNecessary(boolean refreshIfExistAlready, IProgressMonitor monitor) throws ModelException {
        HashSet oldFolders = ExternalFoldersManager.getExternalFolders(this.oldResolvedBuildpath);
        IBuildpathEntry[] newResolvedBuildpath = this.project.getResolvedBuildpath();
        HashSet newFolders = ExternalFoldersManager.getExternalFolders(newResolvedBuildpath);
        if (newFolders == null) {
            return;
        }
        ExternalFoldersManager foldersManager = ModelManager.getExternalManager();
        for (Object folderPath : newFolders) {
            if (oldFolders != null && oldFolders.remove(folderPath)) continue;
            try {
                foldersManager.createLinkFolder((IPath)folderPath, refreshIfExistAlready, monitor);
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
    }

    public String toString() {
        return "ExternalFolderChange: " + this.project.getElementName();
    }
}

