/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.codeassist.ISearchRequestor;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRestriction;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.ModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.NameLookup;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;

class SearchableEnvironmentRequestor
extends ModelElementRequestor {
    protected ISearchRequestor requestor;
    protected ISourceModule unitToSkip;
    protected IScriptProject project;
    protected NameLookup nameLookup;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironmentRequestor(ISearchRequestor requestor) {
        this.requestor = requestor;
        this.unitToSkip = null;
        this.project = null;
        this.nameLookup = null;
        this.checkAccessRestrictions = false;
    }

    public SearchableEnvironmentRequestor(ISearchRequestor requestor, ISourceModule unitToSkip, IScriptProject project, NameLookup nameLookup) {
        this.requestor = requestor;
        this.unitToSkip = unitToSkip;
        this.project = project;
        this.nameLookup = nameLookup;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.dltk.mod.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.dltk.mod.core.compiler.problem.discouragedReference", true));
    }

    @Override
    public void acceptScriptFolder(IScriptFolder ScriptFolder2) {
        this.requestor.acceptPackage(ScriptFolder2.getElementName().toCharArray());
    }

    @Override
    public void acceptType(IType type) {
        try {
            AccessRuleSet accessRuleSet;
            ProjectFragment root;
            BuildpathEntry entry;
            if (this.unitToSkip != null && this.unitToSkip.equals(type.getSourceModule())) {
                return;
            }
            char[] packageName = type.getScriptFolder().getElementName().toCharArray();
            AccessRestriction accessRestriction = null;
            if (this.checkAccessRestrictions && !type.getScriptProject().equals(this.project) && (entry = (BuildpathEntry)this.nameLookup.rootToResolvedEntries.get(root = (ProjectFragment)type.getAncestor(3))) != null && (accessRuleSet = entry.getAccessRuleSet()) != null) {
                char[][] packageChars = CharOperation.splitOn('.', packageName);
                char[] fileWithoutExtension = type.getElementName().toCharArray();
                accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, fileWithoutExtension, '/'));
            }
            this.requestor.acceptType(packageName, type.getElementName().toCharArray(), null, type.getFlags(), accessRestriction);
        }
        catch (ModelException modelException) {}
    }
}

